/*
 * Decompiled with CFR 0.152.
 */
package dtteam.dtru.block;

import com.dtteam.dynamictrees.DynamicTrees;
import com.dtteam.dynamictrees.block.branch.BasicBranchBlock;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;

public class BambooBranchBlock
extends BasicBranchBlock {
    public static final BooleanProperty LEAVES = BooleanProperty.create((String)"leaves");

    public BambooBranchBlock(ResourceLocation name, BlockBehaviour.Properties properties) {
        super(name, properties);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{LEAVES});
    }

    public int setRadius(LevelAccessor level, BlockPos pos, int radius, @Nullable Direction originDir, int flags) {
        destroyMode = DynamicTrees.DestroyMode.SET_RADIUS;
        BlockState oldState = level.getBlockState(pos);
        boolean replacingWater = oldState.getFluidState() == Fluids.WATER.getSource(false);
        boolean setWaterlogged = replacingWater && radius <= 7;
        boolean leaves = oldState.hasProperty((Property)LEAVES) ? ((Boolean)oldState.getValue((Property)LEAVES)).booleanValue() : level.getRandom().nextBoolean();
        level.setBlock(pos, (BlockState)((BlockState)this.getStateForRadius(radius).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(setWaterlogged))).setValue((Property)LEAVES, (Comparable)Boolean.valueOf(leaves)), flags);
        destroyMode = DynamicTrees.DestroyMode.SLOPPY;
        return radius;
    }
}

