/*
 * Decompiled with CFR 0.152.
 */
package dtteam.dtru.genfeature;

import com.dtteam.dynamictrees.api.configuration.ConfigurationProperty;
import com.dtteam.dynamictrees.api.network.MapSignal;
import com.dtteam.dynamictrees.api.network.NodeInspector;
import com.dtteam.dynamictrees.systems.genfeature.GenFeature;
import com.dtteam.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.dtteam.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.dtteam.dynamictrees.systems.nodemapper.FindEndsNode;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictreesplus.block.mushroom.DynamicCapCenterBlock;
import com.dtteam.dynamictreesplus.systems.mushroomlogic.context.MushroomCapContext;
import com.dtteam.dynamictreesplus.tree.HugeMushroomSpecies;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class MushroomVinesGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Float> VINE_PLACE_CHANCE = ConfigurationProperty.floatProperty((String)"vine_place_chance");
    public static final ConfigurationProperty<Integer> MAX_LENGTH = ConfigurationProperty.integer((String)"max_length");
    public static final ConfigurationProperty<Block> BLOCK = ConfigurationProperty.block((String)"block");
    public static final ConfigurationProperty<Block> TIP_BLOCK = ConfigurationProperty.block((String)"tip_block");

    public MushroomVinesGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{VINE_PLACE_CHANCE, MAX_LENGTH, BLOCK, TIP_BLOCK});
    }

    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(VINE_PLACE_CHANCE, (Object)Float.valueOf(0.05f))).with(MAX_LENGTH, (Object)8)).with(BLOCK, (Object)Blocks.WEEPING_VINES_PLANT)).with(TIP_BLOCK, (Object)Blocks.WEEPING_VINES);
    }

    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        Species species = context.species();
        if (species instanceof HugeMushroomSpecies) {
            HugeMushroomSpecies mushroomSpecies = (HugeMushroomSpecies)species;
            LevelAccessor level = context.level();
            BlockPos rootPos = context.pos();
            FindEndsNode endFinder = new FindEndsNode();
            TreeHelper.startAnalysisFromRoot((LevelAccessor)level, (BlockPos)rootPos, (MapSignal)new MapSignal(new NodeInspector[]{endFinder}));
            List endPoints = endFinder.getEnds();
            for (BlockPos endPoint : endPoints) {
                if (endPoint.equals((Object)BlockPos.ZERO) || !(level.getBlockState(endPoint.above()).getBlock() instanceof DynamicCapCenterBlock)) continue;
                int age = (Integer)level.getBlockState(endPoint.above()).getValue((Property)DynamicCapCenterBlock.AGE);
                for (BlockPos findPos : mushroomSpecies.getMushroomShapeKit().getShapeCluster(new MushroomCapContext(level, endPoint.above(), mushroomSpecies, Integer.valueOf(age)))) {
                    if (!(level.getRandom().nextFloat() < ((Float)configuration.get(VINE_PLACE_CHANCE)).floatValue()) || !level.getBlockState(findPos.below()).isAir()) continue;
                    BlockPos vinePos = findPos.below();
                    this.placeVines(level, vinePos, ((Block)configuration.get(BLOCK)).defaultBlockState(), (Integer)configuration.get(MAX_LENGTH), configuration.getAsOptional(TIP_BLOCK).map(block -> (BlockState)block.defaultBlockState().setValue((Property)GrowingPlantHeadBlock.AGE, (Comparable)Integer.valueOf(context.isWorldGen() ? 25 : 0))).orElse(null), context.isWorldGen());
                }
            }
            return true;
        }
        return false;
    }

    protected void placeVines(LevelAccessor level, BlockPos vinePos, BlockState vinesState, int maxLength, @Nullable BlockState tipState, boolean worldGen) {
        int len = worldGen ? Mth.clamp((int)(level.getRandom().nextInt(maxLength) + 3), (int)3, (int)maxLength) : 1;
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos(vinePos.getX(), vinePos.getY(), vinePos.getZ());
        tipState = tipState == null ? vinesState : tipState;
        for (int i = 0; i < len; ++i) {
            if (!level.isEmptyBlock((BlockPos)mPos)) {
                if (i <= 0) break;
                mPos.setY(mPos.getY() + 1);
                level.setBlock((BlockPos)mPos, tipState, 3);
                break;
            }
            level.setBlock((BlockPos)mPos, i == len - 1 ? tipState : vinesState, 3);
            mPos.setY(mPos.getY() + -1);
        }
    }
}

