/*
 * Decompiled with CFR 0.152.
 */
package dtteam.dtru.init;

import com.dtteam.dynamictrees.api.registry.Registry;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.block.leaves.LeavesProperties;
import com.dtteam.dynamictrees.block.soil.SoilProperties;
import com.dtteam.dynamictrees.data.GatherDataHelper;
import com.dtteam.dynamictrees.event.TypeRegistryEvent;
import com.dtteam.dynamictrees.systems.BranchConnectables;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.tree.family.Family;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictreesplus.block.mushroom.CapProperties;
import dtteam.dtru.DynamicTreesRU;
import dtteam.dtru.block.BioshroomCapProperties;
import dtteam.dtru.block.GreenBioshroomCapProperties;
import dtteam.dtru.block.PinkBioshroomCapProperties;
import dtteam.dtru.block.YellowBioshroomCapProperties;
import dtteam.dtru.tree.BioshroomSpecies;
import dtteam.dtru.tree.SmallBioshroomSpecies;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.regions_unexplored.block.RuBlocks;

public class DTRUPlusRegistries {
    public static void gatherData(GatherDataEvent event) {
        GatherDataHelper.gatherAllData((String)"dtru", (GatherDataEvent)event, (Registry[])new Registry[]{SoilProperties.REGISTRY, Family.REGISTRY, Species.REGISTRY, LeavesProperties.REGISTRY, CapProperties.REGISTRY});
    }

    @SubscribeEvent
    public void registerCapPropertiesTypes(TypeRegistryEvent<CapProperties> event) {
        if (!event.isEntryOfType(CapProperties.class)) {
            return;
        }
        event.registerType(DynamicTreesRU.location("bioshroom_cap"), BioshroomCapProperties.TYPE);
        event.registerType(DynamicTreesRU.location("pink_bioshroom_cap"), PinkBioshroomCapProperties.TYPE);
        event.registerType(DynamicTreesRU.location("yellow_bioshroom_cap"), YellowBioshroomCapProperties.TYPE);
        event.registerType(DynamicTreesRU.location("green_bioshroom_cap"), GreenBioshroomCapProperties.TYPE);
    }

    public static void registerSpeciesTypes(TypeRegistryEvent<Species> event) {
        if (!event.isEntryOfType(Species.class)) {
            return;
        }
        event.registerType(DynamicTreesRU.location("bioshroom"), BioshroomSpecies.TYPE);
        event.registerType(DynamicTreesRU.location("small_bioshroom"), SmallBioshroomSpecies.TYPE);
    }

    public static void setup() {
        DTRUPlusRegistries.setupBioshroomConnectable((Block)RuBlocks.BLUE_BIOSHROOM_BLOCK.get());
        DTRUPlusRegistries.setupBioshroomConnectable((Block)RuBlocks.GLOWING_BLUE_BIOSHROOM_BLOCK.get());
        DTRUPlusRegistries.setupBioshroomConnectable((Block)RuBlocks.GLOWING_GREEN_BIOSHROOM_BLOCK.get());
        DTRUPlusRegistries.setupBioshroomConnectable((Block)RuBlocks.GLOWING_PINK_BIOSHROOM_BLOCK.get());
        DTRUPlusRegistries.setupBioshroomConnectable((Block)RuBlocks.GLOWING_YELLOW_BIOSHROOM_BLOCK.get());
        BranchConnectables.makeBlockConnectable((Block)Blocks.SHROOMLIGHT, (state, level, pos, side) -> {
            if (side.getAxis() == Direction.Axis.Y) {
                return 0;
            }
            BlockState branchState = level.getBlockState(pos.relative(side.getOpposite()));
            BranchBlock branch = TreeHelper.getBranch((BlockState)branchState);
            return branch != null ? Mth.clamp((int)(branch.getRadius(branchState) - 1), (int)1, (int)3) : 1;
        });
    }

    private static void setupBioshroomConnectable(Block block) {
        BranchConnectables.makeBlockConnectable((Block)block, (state, level, pos, side) -> {
            if (side.getAxis() == Direction.Axis.Y) {
                return 0;
            }
            BlockState branchState = level.getBlockState(pos.relative(side.getOpposite()));
            BranchBlock branch = TreeHelper.getBranch((BlockState)branchState);
            return branch != null ? Mth.clamp((int)(branch.getRadius(branchState) - 1), (int)1, (int)3) : 1;
        });
    }
}

