/*
 * Decompiled with CFR 0.152.
 */
package com.xblq.crystalpreview.client.render;

import com.xblq.crystalpreview.CrystalPreviewMod;
import com.xblq.crystalpreview.util.CrystalPlacementHelper;
import com.xblq.crystalpreview.util.PlayerPrediction;
import java.awt.Color;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_638;

public class CrystalPreviewRenderer {
    private static final float EXPLOSION_RADIUS = 6.0f;

    public static void render(WorldRenderContext context, class_3965 hitResult, class_638 world, class_1657 player) {
        if (!CrystalPreviewMod.CONFIG.isEnabled() || hitResult == null) {
            return;
        }
        class_4587 matrices = context.matrixStack();
        class_4597 vertexConsumers = context.consumers();
        if (vertexConsumers == null) {
            return;
        }
        class_243 cameraPos = context.camera().method_19326();
        class_2338 blockPos = hitResult.method_17777();
        class_2338 crystalPos = blockPos.method_10084();
        boolean isValid = CrystalPlacementHelper.isValidCrystalPlacement((class_1937)world, blockPos);
        List<class_1657> nearbyPlayers = world.method_18456().stream().filter(p -> p.method_5649((double)crystalPos.method_10263() + 0.5, (double)crystalPos.method_10264(), (double)crystalPos.method_10260() + 0.5) <= 36.0).collect(Collectors.toList());
        boolean isOptimal = false;
        if (isValid && !nearbyPlayers.isEmpty()) {
            isOptimal = PlayerPrediction.isOptimalCrystalPlacement((class_1937)world, blockPos, nearbyPlayers, player);
        }
        matrices.method_22903();
        matrices.method_22904((double)blockPos.method_10263() - cameraPos.method_10216(), (double)blockPos.method_10264() - cameraPos.method_10214(), (double)blockPos.method_10260() - cameraPos.method_10215());
        Color color = !isValid ? CrystalPreviewMod.CONFIG.getInvalidColor() : (isOptimal ? CrystalPreviewMod.CONFIG.getOptimalColor() : CrystalPreviewMod.CONFIG.getValidColor());
        CrystalPreviewRenderer.drawPlacementBox(matrices, vertexConsumers, color, 1.0f, 2.0f);
        if (CrystalPreviewMod.CONFIG.showExplosionRadius() && isValid) {
            CrystalPreviewRenderer.drawExplosionRadius(matrices, vertexConsumers, color, 0.2f, 6.0f);
        }
        matrices.method_22909();
    }

    private static void drawPlacementBox(class_4587 matrices, class_4597 vertexConsumers, Color color, float alpha, float size) {
        class_238 box = new class_238(0.0, 0.0, 0.0, 1.0, 2.0, 1.0);
        class_4588 vertexConsumer = vertexConsumers.getBuffer(class_1921.method_23594());
        CrystalPreviewRenderer.drawBoxLines(matrices, vertexConsumer, box.field_1323, box.field_1322, box.field_1321, box.field_1320, box.field_1325, box.field_1324, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, alpha);
    }

    private static void drawExplosionRadius(class_4587 matrices, class_4597 vertexConsumers, Color color, float alpha, float radius) {
        class_4588 vertexConsumer = vertexConsumers.getBuffer(class_1921.method_23594());
        int segments = 24;
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        matrices.method_22903();
        matrices.method_22904(0.5, 1.0, 0.5);
        for (int i = 0; i < segments; ++i) {
            double angle1 = Math.PI * 2 * (double)i / (double)segments;
            double angle2 = Math.PI * 2 * (double)(i + 1) / (double)segments;
            double x1 = Math.cos(angle1) * (double)radius;
            double z1 = Math.sin(angle1) * (double)radius;
            double x2 = Math.cos(angle2) * (double)radius;
            double z2 = Math.sin(angle2) * (double)radius;
            vertexConsumer.method_22918(matrices.method_23760().method_23761(), (float)x1, 0.0f, (float)z1).method_22915(r, g, b, alpha).method_22914(1.0f, 0.0f, 0.0f);
            vertexConsumer.method_22918(matrices.method_23760().method_23761(), (float)x2, 0.0f, (float)z2).method_22915(r, g, b, alpha).method_22914(1.0f, 0.0f, 0.0f);
        }
        matrices.method_22909();
    }

    private static void drawBoxLines(class_4587 matrices, class_4588 vertexConsumer, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float red, float green, float blue, float alpha) {
        CrystalPreviewRenderer.drawLine(matrices, vertexConsumer, minX, minY, minZ, maxX, minY, minZ, red, green, blue, alpha);
        CrystalPreviewRenderer.drawLine(matrices, vertexConsumer, minX, minY, minZ, minX, minY, maxZ, red, green, blue, alpha);
        CrystalPreviewRenderer.drawLine(matrices, vertexConsumer, maxX, minY, minZ, maxX, minY, maxZ, red, green, blue, alpha);
        CrystalPreviewRenderer.drawLine(matrices, vertexConsumer, minX, minY, maxZ, maxX, minY, maxZ, red, green, blue, alpha);
        CrystalPreviewRenderer.drawLine(matrices, vertexConsumer, minX, maxY, minZ, maxX, maxY, minZ, red, green, blue, alpha);
        CrystalPreviewRenderer.drawLine(matrices, vertexConsumer, minX, maxY, minZ, minX, maxY, maxZ, red, green, blue, alpha);
        CrystalPreviewRenderer.drawLine(matrices, vertexConsumer, maxX, maxY, minZ, maxX, maxY, maxZ, red, green, blue, alpha);
        CrystalPreviewRenderer.drawLine(matrices, vertexConsumer, minX, maxY, maxZ, maxX, maxY, maxZ, red, green, blue, alpha);
        CrystalPreviewRenderer.drawLine(matrices, vertexConsumer, minX, minY, minZ, minX, maxY, minZ, red, green, blue, alpha);
        CrystalPreviewRenderer.drawLine(matrices, vertexConsumer, maxX, minY, minZ, maxX, maxY, minZ, red, green, blue, alpha);
        CrystalPreviewRenderer.drawLine(matrices, vertexConsumer, minX, minY, maxZ, minX, maxY, maxZ, red, green, blue, alpha);
        CrystalPreviewRenderer.drawLine(matrices, vertexConsumer, maxX, minY, maxZ, maxX, maxY, maxZ, red, green, blue, alpha);
    }

    private static void drawLine(class_4587 matrices, class_4588 vertexConsumer, double x1, double y1, double z1, double x2, double y2, double z2, float red, float green, float blue, float alpha) {
        vertexConsumer.method_22918(matrices.method_23760().method_23761(), (float)x1, (float)y1, (float)z1).method_22915(red, green, blue, alpha).method_22914(1.0f, 0.0f, 0.0f);
        vertexConsumer.method_22918(matrices.method_23760().method_23761(), (float)x2, (float)y2, (float)z2).method_22915(red, green, blue, alpha).method_22914(1.0f, 0.0f, 0.0f);
    }
}

