/*
 * Decompiled with CFR 0.152.
 */
package com.xblq.crystalpreview.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.xblq.crystalpreview.CrystalPreviewMod;
import java.awt.Color;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;

public class CrystalPreviewConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("crystal_preview.json");
    private boolean enabled = true;
    private boolean showExplosionRadius = true;
    private Color validColor = new Color(0, 255, 0, 120);
    private Color invalidColor = new Color(255, 0, 0, 120);
    private Color optimalColor = new Color(255, 255, 0, 120);
    private float predictDistance = 2.0f;

    public void load() {
        block8: {
            try {
                if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                    try (FileReader reader = new FileReader(CONFIG_PATH.toFile());){
                        ConfigData data = (ConfigData)GSON.fromJson((Reader)reader, ConfigData.class);
                        this.enabled = data.enabled;
                        this.showExplosionRadius = data.showExplosionRadius;
                        this.validColor = new Color(data.validColorRed, data.validColorGreen, data.validColorBlue, data.validColorAlpha);
                        this.invalidColor = new Color(data.invalidColorRed, data.invalidColorGreen, data.invalidColorBlue, data.invalidColorAlpha);
                        this.optimalColor = new Color(data.optimalColorRed, data.optimalColorGreen, data.optimalColorBlue, data.optimalColorAlpha);
                        this.predictDistance = data.predictDistance;
                        break block8;
                    }
                }
                this.save();
            }
            catch (IOException e) {
                CrystalPreviewMod.LOGGER.error("Failed to load config: " + e.getMessage());
            }
        }
    }

    public void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            ConfigData data = new ConfigData();
            data.enabled = this.enabled;
            data.showExplosionRadius = this.showExplosionRadius;
            data.validColorRed = this.validColor.getRed();
            data.validColorGreen = this.validColor.getGreen();
            data.validColorBlue = this.validColor.getBlue();
            data.validColorAlpha = this.validColor.getAlpha();
            data.invalidColorRed = this.invalidColor.getRed();
            data.invalidColorGreen = this.invalidColor.getGreen();
            data.invalidColorBlue = this.invalidColor.getBlue();
            data.invalidColorAlpha = this.invalidColor.getAlpha();
            data.optimalColorRed = this.optimalColor.getRed();
            data.optimalColorGreen = this.optimalColor.getGreen();
            data.optimalColorBlue = this.optimalColor.getBlue();
            data.optimalColorAlpha = this.optimalColor.getAlpha();
            data.predictDistance = this.predictDistance;
            try (FileWriter writer = new FileWriter(CONFIG_PATH.toFile());){
                GSON.toJson((Object)data, (Appendable)writer);
            }
        }
        catch (IOException e) {
            CrystalPreviewMod.LOGGER.error("Failed to save config: " + e.getMessage());
        }
    }

    public static void registerModMenu() {
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.save();
    }

    public boolean showExplosionRadius() {
        return this.showExplosionRadius;
    }

    public void setShowExplosionRadius(boolean showExplosionRadius) {
        this.showExplosionRadius = showExplosionRadius;
        this.save();
    }

    public Color getValidColor() {
        return this.validColor;
    }

    public void setValidColor(Color validColor) {
        this.validColor = validColor;
        this.save();
    }

    public Color getInvalidColor() {
        return this.invalidColor;
    }

    public void setInvalidColor(Color invalidColor) {
        this.invalidColor = invalidColor;
        this.save();
    }

    public Color getOptimalColor() {
        return this.optimalColor;
    }

    public void setOptimalColor(Color optimalColor) {
        this.optimalColor = optimalColor;
        this.save();
    }

    public float getPredictDistance() {
        return this.predictDistance;
    }

    public void setPredictDistance(float predictDistance) {
        this.predictDistance = predictDistance;
        this.save();
    }

    public void resetToDefaults() {
        this.enabled = true;
        this.showExplosionRadius = true;
        this.predictDistance = 2.0f;
        this.validColor = null;
        this.invalidColor = null;
        this.optimalColor = null;
        this.validColor = new Color(0, 255, 0, 120);
        this.invalidColor = new Color(255, 0, 0, 120);
        this.optimalColor = new Color(255, 255, 0, 120);
        this.save();
    }

    private static class ConfigData {
        boolean enabled = true;
        boolean showExplosionRadius = true;
        int validColorRed = 0;
        int validColorGreen = 255;
        int validColorBlue = 0;
        int validColorAlpha = 120;
        int invalidColorRed = 255;
        int invalidColorGreen = 0;
        int invalidColorBlue = 0;
        int invalidColorAlpha = 120;
        int optimalColorRed = 255;
        int optimalColorGreen = 255;
        int optimalColorBlue = 0;
        int optimalColorAlpha = 120;
        float predictDistance = 2.0f;

        private ConfigData() {
        }
    }
}

