/*
 * Decompiled with CFR 0.152.
 */
package com.xblq.crystalpreview.config;

import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import com.xblq.crystalpreview.CrystalPreviewMod;
import com.xblq.crystalpreview.config.CrystalPreviewConfig;
import java.awt.Color;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5676;

@Environment(value=EnvType.CLIENT)
public class ModMenuIntegration
implements ModMenuApi {
    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        return parent -> new ConfigScreen(parent);
    }

    private static class ConfigScreen
    extends class_437 {
        private final class_437 parent;
        private final CrystalPreviewConfig config;
        private static final int DEFAULT_GREEN = new Color(0, 255, 0, 100).getRGB();
        private static final int DEFAULT_RED = new Color(255, 0, 0, 100).getRGB();
        private static final int DEFAULT_YELLOW = new Color(255, 255, 0, 100).getRGB();

        protected ConfigScreen(class_437 parent) {
            super((class_2561)class_2561.method_43471((String)"crystalpreview.config.title"));
            this.parent = parent;
            this.config = CrystalPreviewMod.CONFIG;
        }

        protected void method_25426() {
            this.method_37063((class_364)class_5676.method_32613((boolean)this.config.isEnabled()).method_32617(this.field_22789 / 2 - 155, this.field_22790 / 6, 310, 20, (class_2561)class_2561.method_43471((String)"crystalpreview.config.enabled"), (button, enabled) -> {
                this.config.setEnabled((boolean)enabled);
                this.config.save();
            }));
            this.method_37063((class_364)class_5676.method_32613((boolean)this.config.showExplosionRadius()).method_32617(this.field_22789 / 2 - 155, this.field_22790 / 6 + 24, 310, 20, (class_2561)class_2561.method_43471((String)"crystalpreview.config.showRadius"), (button, show) -> {
                this.config.setShowExplosionRadius((boolean)show);
                this.config.save();
            }));
            this.method_37063((class_364)new class_357(this.field_22789 / 2 - 155, this.field_22790 / 6 + 48, 310, 20, (class_2561)class_2561.method_43469((String)"crystalpreview.config.predictDistance", (Object[])new Object[]{Float.valueOf(this.config.getPredictDistance())}), this.config.getPredictDistance() / 5.0f){

                protected void method_25346() {
                    this.method_25355((class_2561)class_2561.method_43469((String)"crystalpreview.config.predictDistance", (Object[])new Object[]{(int)(this.field_22753 * 5.0)}));
                }

                protected void method_25344() {
                    config.setPredictDistance((int)(this.field_22753 * 5.0));
                    config.save();
                }
            });
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"crystalpreview.config.resetDefaults"), button -> {
                this.config.resetToDefaults();
                this.config.save();
                this.method_25426();
            }).method_46434(this.field_22789 / 2 - 155, this.field_22790 / 6 + 72, 150, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Edit Valid Color"), button -> this.field_22787.method_1507((class_437)new ColorPickerScreen(this, "Valid (Green)", this.config.getValidColor(), this.config::setValidColor))).method_46434(this.field_22789 / 2 - 170, this.field_22790 / 6 + 130, 100, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Edit Invalid Color"), button -> this.field_22787.method_1507((class_437)new ColorPickerScreen(this, "Invalid (Red)", this.config.getInvalidColor(), this.config::setInvalidColor))).method_46434(this.field_22789 / 2 - 20, this.field_22790 / 6 + 130, 100, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Edit Optimal Color"), button -> this.field_22787.method_1507((class_437)new ColorPickerScreen(this, "Optimal (Yellow)", this.config.getOptimalColor(), this.config::setOptimalColor))).method_46434(this.field_22789 / 2 + 130, this.field_22790 / 6 + 130, 100, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.done"), button -> this.method_25419()).method_46434(this.field_22789 / 2 - 75, this.field_22790 / 6 + 160, 150, 20).method_46431());
        }

        public void method_25419() {
            this.field_22787.method_1507(this.parent);
        }

        public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
            context.method_25296(0, 0, this.field_22789, this.field_22790, -1072689136, -804253680);
            context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, 0xFFFFFF);
            int y = this.field_22790 / 6 + 100;
            context.method_25294(this.field_22789 / 2 - 170, y, this.field_22789 / 2 - 130, y + 20, this.config.getValidColor().getRGB());
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"Valid"), this.field_22789 / 2 - 150, y + 25, 0xFFFFFF);
            context.method_25294(this.field_22789 / 2 - 20, y, this.field_22789 / 2 + 20, y + 20, this.config.getInvalidColor().getRGB());
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"Invalid"), this.field_22789 / 2, y + 25, 0xFFFFFF);
            context.method_25294(this.field_22789 / 2 + 130, y, this.field_22789 / 2 + 170, y + 20, this.config.getOptimalColor().getRGB());
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"Optimal"), this.field_22789 / 2 + 150, y + 25, 0xFFFFFF);
            super.method_25394(context, mouseX, mouseY, delta);
        }
    }

    private static class ColorPickerScreen
    extends class_437 {
        private final class_437 parent;
        private final String colorType;
        private final Consumer<Color> colorSetter;
        private int red;
        private int green;
        private int blue;
        private int alpha;
        private class_357 redSlider;
        private class_357 greenSlider;
        private class_357 blueSlider;
        private class_357 alphaSlider;
        private Color initialColor;

        protected ColorPickerScreen(class_437 parent, String colorType, Color initialColor, Consumer<Color> colorSetter) {
            super((class_2561)class_2561.method_43470((String)("Edit " + colorType + " Color")));
            this.parent = parent;
            this.colorType = colorType;
            this.colorSetter = colorSetter;
            this.initialColor = initialColor;
            this.red = initialColor.getRed();
            this.green = initialColor.getGreen();
            this.blue = initialColor.getBlue();
            this.alpha = initialColor.getAlpha();
        }

        protected void method_25426() {
            int centerX = this.field_22789 / 2;
            int startY = this.field_22790 / 6;
            this.redSlider = (class_357)this.method_37063((class_364)new class_357(centerX - 155, startY + 30, 310, 20, (class_2561)class_2561.method_43470((String)("Red: " + this.red)), (float)this.red / 255.0f){

                protected void method_25346() {
                    this.method_25355((class_2561)class_2561.method_43470((String)("Red: " + (int)(this.field_22753 * 255.0))));
                }

                protected void method_25344() {
                    red = (int)(this.field_22753 * 255.0);
                    this.updateColor();
                }
            });
            this.greenSlider = (class_357)this.method_37063((class_364)new class_357(centerX - 155, startY + 55, 310, 20, (class_2561)class_2561.method_43470((String)("Green: " + this.green)), (float)this.green / 255.0f){

                protected void method_25346() {
                    this.method_25355((class_2561)class_2561.method_43470((String)("Green: " + (int)(this.field_22753 * 255.0))));
                }

                protected void method_25344() {
                    green = (int)(this.field_22753 * 255.0);
                    this.updateColor();
                }
            });
            this.blueSlider = (class_357)this.method_37063((class_364)new class_357(centerX - 155, startY + 80, 310, 20, (class_2561)class_2561.method_43470((String)("Blue: " + this.blue)), (float)this.blue / 255.0f){

                protected void method_25346() {
                    this.method_25355((class_2561)class_2561.method_43470((String)("Blue: " + (int)(this.field_22753 * 255.0))));
                }

                protected void method_25344() {
                    blue = (int)(this.field_22753 * 255.0);
                    this.updateColor();
                }
            });
            this.alphaSlider = (class_357)this.method_37063((class_364)new class_357(centerX - 155, startY + 105, 310, 20, (class_2561)class_2561.method_43470((String)("Transparency: " + this.alpha)), (float)this.alpha / 255.0f){

                protected void method_25346() {
                    this.method_25355((class_2561)class_2561.method_43470((String)("Transparency: " + (int)(this.field_22753 * 255.0))));
                }

                protected void method_25344() {
                    this.field_22765 = (int)(this.field_22753 * 255.0);
                    this.updateColor();
                }
            });
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Save"), button -> {
                this.colorSetter.accept(new Color(this.red, this.green, this.blue, this.alpha));
                this.field_22787.method_1507(this.parent);
            }).method_46434(centerX - 155, startY + 135, 150, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), button -> this.field_22787.method_1507(this.parent)).method_46434(centerX + 5, startY + 135, 150, 20).method_46431());
        }

        private void updateColor() {
        }

        public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
            context.method_25296(0, 0, this.field_22789, this.field_22790, -1072689136, -804253680);
            context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, 0xFFFFFF);
            String description = this.getColorDescription(this.colorType);
            int lineY = this.field_22790 / 6 + 165;
            int centerX = this.field_22789 / 2;
            for (String line : description.split("\n")) {
                context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)line), centerX, lineY, 0xAAAAAA);
                lineY += 12;
            }
            int previewY = this.field_22790 / 6 + 190;
            context.method_25294(this.field_22789 / 2 - 50, previewY, this.field_22789 / 2 + 50, previewY + 40, new Color(this.red, this.green, this.blue, this.alpha).getRGB());
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"Current Color Preview"), this.field_22789 / 2, previewY + 45, 0xFFFFFF);
            super.method_25394(context, mouseX, mouseY, delta);
        }

        private String getColorDescription(String colorType) {
            if (colorType.contains("Valid")) {
                return "Valid Placement Color (Green):\nShows where crystals can be successfully placed.\nThese blocks will accept crystal placement.";
            }
            if (colorType.contains("Invalid")) {
                return "Invalid Placement Color (Red):\nShows blocks where crystals cannot be placed.\nAttempting placement here will fail.";
            }
            if (colorType.contains("Optimal")) {
                return "Optimal Placement Color (Yellow):\nShows placement locations that will cause\nmaximum damage based on player positions and movement.";
            }
            return "";
        }
    }
}

