/*
 * Decompiled with CFR 0.152.
 */
package com.xblq.crystalpreview.util;

import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public class CrystalPlacementHelper {
    public static boolean isValidCrystalPlacement(class_1937 world, class_2338 blockPos) {
        boolean validBlock;
        if (world == null) {
            return false;
        }
        class_2680 blockState = world.method_8320(blockPos);
        class_2248 block = blockState.method_26204();
        boolean bl = validBlock = block == class_2246.field_10540 || block == class_2246.field_9987;
        if (!validBlock) {
            return false;
        }
        class_2338 above1 = blockPos.method_10084();
        class_2338 above2 = above1.method_10084();
        return world.method_8320(above1).method_26215() && world.method_8320(above2).method_26215();
    }

    public static float calculateCrystalDamage(class_1937 world, class_2338 crystalPos, class_2338 playerPos) {
        double playerZ;
        double distZ;
        double playerY;
        double distY;
        if (world == null) {
            return 0.0f;
        }
        double crystalX = (double)crystalPos.method_10263() + 0.5;
        double crystalY = (double)crystalPos.method_10264() + 1.0;
        double crystalZ = (double)crystalPos.method_10260() + 0.5;
        double playerX = (double)playerPos.method_10263() + 0.5;
        double distX = playerX - crystalX;
        double distance = Math.sqrt(distX * distX + (distY = (playerY = (double)playerPos.method_10264() + 1.6) - crystalY) * distY + (distZ = (playerZ = (double)playerPos.method_10260() + 0.5) - crystalZ) * distZ);
        if (distance > 12.0) {
            return 0.0f;
        }
        return (float)((12.0 - distance) / 12.0) * 20.0f;
    }

    public static boolean hasLineOfSight(class_1937 world, class_2338 from, class_2338 to) {
        if (world == null) {
            return false;
        }
        double dx = to.method_10263() - from.method_10263();
        double dy = to.method_10264() - from.method_10264();
        double dz = to.method_10260() - from.method_10260();
        double length = Math.sqrt(dx * dx + dy * dy + dz * dz);
        dx /= length;
        dy /= length;
        dz /= length;
        double currentX = (double)from.method_10263() + 0.5;
        double currentY = (double)from.method_10264() + 0.5;
        double currentZ = (double)from.method_10260() + 0.5;
        int i = 0;
        while ((double)i < length) {
            class_2338 currentBlock = new class_2338((int)Math.floor(currentX += dx), (int)Math.floor(currentY += dy), (int)Math.floor(currentZ += dz));
            if (!world.method_8320(currentBlock).method_26215()) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

