/*
 * Decompiled with CFR 0.152.
 */
package com.xblq.crystalpreview.util;

import com.xblq.crystalpreview.CrystalPreviewMod;
import com.xblq.crystalpreview.util.CrystalPlacementHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;

public class PlayerPrediction {
    public static class_2338 predictPlayerPosition(class_1657 player, float predictionTime) {
        if (player == null) {
            return player.method_24515();
        }
        class_243 velocity = player.method_18798();
        class_243 lookVec = player.method_5720();
        class_1937 world = player.method_5770();
        boolean isSprinting = player.method_5624();
        boolean isSneaking = player.method_5715();
        boolean isJumping = velocity.field_1351 > 0.1;
        double speedMultiplier = 1.0;
        if (isSprinting) {
            speedMultiplier = 1.3;
        }
        if (isSneaking) {
            speedMultiplier = 0.3;
        }
        double lookWeight = 0.4;
        double velocityWeight = 0.6;
        double predictedX = player.method_23317() + (velocity.field_1352 * velocityWeight + lookVec.field_1352 * lookWeight) * (double)predictionTime * speedMultiplier;
        double predictedZ = player.method_23321() + (velocity.field_1350 * velocityWeight + lookVec.field_1350 * lookWeight) * (double)predictionTime * speedMultiplier;
        double predictedY = player.method_23318();
        if (isJumping) {
            predictedY += Math.min(1.0, velocity.field_1351 * (double)predictionTime + 0.3);
        } else if (velocity.field_1351 < 0.0 && !player.method_24828()) {
            class_2338 checkPos = new class_2338((int)Math.floor(predictedX), (int)Math.floor(player.method_23318()), (int)Math.floor(predictedZ));
            for (int searchDepth = 0; checkPos.method_10264() > world.method_31607() && world.method_8320(checkPos).method_26215() && searchDepth < 10; ++searchDepth) {
                checkPos = checkPos.method_10074();
            }
            predictedY = (double)checkPos.method_10264() < player.method_23318() ? (double)checkPos.method_10264() + 1.0 : (predictedY += velocity.field_1351 * (double)predictionTime);
        } else if (player.method_24828()) {
            class_2338 forwardPos = new class_2338((int)Math.floor(predictedX), (int)Math.floor(player.method_23318()), (int)Math.floor(predictedZ));
            if (!world.method_8320(forwardPos).method_26215() && world.method_8320(forwardPos.method_10084()).method_26215()) {
                predictedY += 1.0;
            } else if (world.method_8320(forwardPos).method_26215() && !world.method_8320(forwardPos.method_10074()).method_26215()) {
                predictedY -= 1.0;
            }
        }
        double strafeVariation = 0.3;
        if (velocity.method_37267() > 0.15) {
            predictedX += (Math.random() - 0.5) * strafeVariation;
            predictedZ += (Math.random() - 0.5) * strafeVariation;
        }
        return new class_2338((int)Math.floor(predictedX), (int)Math.floor(predictedY), (int)Math.floor(predictedZ));
    }

    public static boolean isOptimalCrystalPlacement(class_1937 world, class_2338 blockPos, List<class_1657> nearbyPlayers, class_1657 placer) {
        if (world == null || nearbyPlayers.isEmpty()) {
            return false;
        }
        class_2338 crystalPos = blockPos.method_10084();
        float totalDamage = 0.0f;
        float selfDamage = 0.0f;
        float predictionTime = CrystalPreviewMod.CONFIG.getPredictDistance();
        for (class_1657 player : nearbyPlayers) {
            if (player.method_7337() || player.method_7325()) continue;
            class_2338 predictedPos = PlayerPrediction.predictPlayerPosition(player, predictionTime);
            float damage = CrystalPlacementHelper.calculateCrystalDamage(world, crystalPos, predictedPos);
            boolean canSee = CrystalPlacementHelper.hasLineOfSight(world, crystalPos, predictedPos);
            if (!canSee) continue;
            if (player == placer) {
                selfDamage = damage;
                continue;
            }
            totalDamage += damage;
        }
        return totalDamage > 10.0f && selfDamage < 8.0f;
    }

    public static Optional<class_2338> findOptimalCrystalPlacement(class_1937 world, class_2338 center, int radius, class_1657 target, class_1657 placer) {
        if (world == null || target == null) {
            return Optional.empty();
        }
        float predictionTime = CrystalPreviewMod.CONFIG.getPredictDistance();
        class_2338.class_2339 mutable = new class_2338.class_2339();
        class_2338 bestPos = null;
        float bestScore = 0.0f;
        class_2338 primaryPrediction = PlayerPrediction.predictPlayerPosition(target, predictionTime);
        class_2338 secondaryPrediction = PlayerPrediction.predictPlayerPosition(target, predictionTime * 1.5f);
        class_2338 placerPredictedPos = PlayerPrediction.predictPlayerPosition(placer, predictionTime * 0.5f);
        double targetDist = Math.sqrt(center.method_10262((class_2382)target.method_24515()));
        int maxRadius = Math.min(radius, 7);
        for (int dist = 1; dist <= maxRadius; ++dist) {
            for (int x = -dist; x <= dist; ++x) {
                for (int y = -3; y <= 3; ++y) {
                    for (int z = -dist; z <= dist; ++z) {
                        if (Math.abs(x) != dist && Math.abs(z) != dist && dist > 1) continue;
                        mutable.method_10103(center.method_10263() + x, center.method_10264() + y, center.method_10260() + z);
                        if (!CrystalPlacementHelper.isValidCrystalPlacement(world, (class_2338)mutable)) continue;
                        class_2338 crystalPos = mutable.method_10084();
                        float primaryDamage = CrystalPlacementHelper.calculateCrystalDamage(world, crystalPos, primaryPrediction);
                        float secondaryDamage = CrystalPlacementHelper.calculateCrystalDamage(world, crystalPos, secondaryPrediction);
                        float targetDamage = Math.max(primaryDamage, secondaryDamage);
                        float selfDamage = CrystalPlacementHelper.calculateCrystalDamage(world, crystalPos, placerPredictedPos);
                        boolean hasLOSToTarget = CrystalPlacementHelper.hasLineOfSight(world, crystalPos, primaryPrediction);
                        class_243 eyePos = placer.method_33571();
                        class_2338 eyeBlockPos = new class_2338((int)Math.floor(eyePos.field_1352), (int)Math.floor(eyePos.field_1351), (int)Math.floor(eyePos.field_1350));
                        boolean hasLOSFromPlacer = CrystalPlacementHelper.hasLineOfSight(world, eyeBlockPos, crystalPos);
                        if (!hasLOSFromPlacer) continue;
                        float damageRatio = selfDamage > 0.0f ? targetDamage / selfDamage : targetDamage;
                        float visibilityBonus = hasLOSToTarget ? 1.5f : 0.5f;
                        float distanceBonus = (float)(1.0 / (1.0 + mutable.method_10262((class_2382)target.method_24515()) * 0.01));
                        float score = (targetDamage - selfDamage * 1.2f) * visibilityBonus * distanceBonus;
                        if (!(targetDamage > 8.0f) || !(selfDamage < 8.0f) || !(score > bestScore)) continue;
                        bestScore = score;
                        bestPos = mutable.method_10062();
                        if (!(score > 25.0f) || !hasLOSToTarget || !(selfDamage < 4.0f)) continue;
                        return Optional.of(bestPos);
                    }
                }
            }
        }
        return Optional.ofNullable(bestPos);
    }
}

