/*
 * Decompiled with CFR 0.152.
 */
package eu.magkari.mc.modpackshippedservers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.magkari.mc.modpackshippedservers.SConfig;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_641;
import net.minecraft.class_642;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModpackShippedServers
implements ClientModInitializer {
    public static final String MOD_ID = "modpack-shipped-servers";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"modpack-shipped-servers");
    public static SConfig CONFIG;
    private static final Gson gson;

    public void onInitializeClient() {
        block15: {
            Path configPath = FabricLoader.getInstance().getConfigDir().resolve("shipped-servers.json");
            try {
                if (Files.notExists(configPath, new LinkOption[0])) {
                    SConfig defaultConfig = new SConfig();
                    String json = gson.toJson((Object)defaultConfig);
                    try (BufferedWriter out = Files.newBufferedWriter(configPath, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);){
                        out.write(json);
                    }
                    catch (IOException e) {
                        LOGGER.error("Error writing file!", (Throwable)e);
                    }
                    CONFIG = defaultConfig;
                    break block15;
                }
                String content = Files.readString(configPath, StandardCharsets.UTF_8);
                if (content.isBlank()) {
                    LOGGER.warn("Servers file was empty! Using default values.");
                    CONFIG = new SConfig();
                } else {
                    CONFIG = (SConfig)gson.fromJson(content, SConfig.class);
                    if (CONFIG == null) {
                        LOGGER.warn("Servers file had invalid JSON! Using default values.");
                        CONFIG = new SConfig();
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("There was an error creating/loading the servers file!", (Throwable)e);
                CONFIG = new SConfig();
                LOGGER.warn("Using default values.");
            }
        }
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> {
            class_641 serverList = new class_641(client);
            serverList.method_2981();
            if (serverList.method_2984() == 0) {
                CONFIG.getServers().forEach(config -> {
                    class_642 configuredServer = new class_642(config.name(), config.address(), false);
                    try {
                        configuredServer.method_2995(class_642.class_643.valueOf((String)config.resourcePackPolicy().toUpperCase()));
                    }
                    catch (IllegalArgumentException e) {
                        LOGGER.warn("Invalid resource pack policy '{}' for server '{}'. Defaulting to 'PROMPT'.", (Object)config.resourcePackPolicy(), (Object)config.name());
                        configuredServer.method_2995(class_642.class_643.field_3767);
                    }
                    serverList.method_2988(configuredServer, false);
                });
                serverList.method_2987();
            }
        });
    }

    static {
        gson = new GsonBuilder().setPrettyPrinting().create();
    }
}

