/*
 * Decompiled with CFR 0.152.
 */
package wd40.hooked.client.render;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10017;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4604;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_746;
import net.minecraft.class_897;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import wd40.hooked.client.render.FishingBobberEntityRenderState;
import wd40.hooked.entity.custom.FishingBobberEntity;
import wd40.hooked.item.custom.FishingRodItem;

@Environment(value=EnvType.CLIENT)
public class FishingBobberEntityRenderer
extends class_897<FishingBobberEntity, FishingBobberEntityRenderState> {
    private static final class_2960 TEXTURE = class_2960.method_60656((String)"textures/entity/fishing_hook.png");
    private static final class_1921 LAYER = class_1921.method_23576((class_2960)TEXTURE);
    private static final double FIRST_PERSON_FOV_FACTOR = 960.0;
    private static final Vector3f translate = new Vector3f();
    private static int counter = 0;

    public FishingBobberEntityRenderer(class_5617.class_5618 context) {
        super(context);
    }

    public boolean shouldRender(FishingBobberEntity fishingBobber, class_4604 frustum, double d, double e, double f) {
        return super.method_3933((class_1297)fishingBobber, frustum, d, e, f) && fishingBobber.getPlayerOwner() != null;
    }

    public void render(FishingBobberEntityRenderState renderState, class_4587 matrices, class_11659 orderedRenderCommandQueue, class_12075 cameraRenderState) {
        matrices.method_22903();
        matrices.method_22903();
        matrices.method_22905(0.5f, 0.5f, 0.5f);
        matrices.method_22907((Quaternionfc)cameraRenderState.field_63081);
        orderedRenderCommandQueue.method_73483(matrices, LAYER, (entry, vertexConsumer) -> {
            FishingBobberEntityRenderer.vertex(vertexConsumer, entry, renderState.field_61820, 0.0f, 0, 0, 1);
            FishingBobberEntityRenderer.vertex(vertexConsumer, entry, renderState.field_61820, 1.0f, 0, 1, 1);
            FishingBobberEntityRenderer.vertex(vertexConsumer, entry, renderState.field_61820, 1.0f, 1, 1, 0);
            FishingBobberEntityRenderer.vertex(vertexConsumer, entry, renderState.field_61820, 0.0f, 1, 0, 0);
        });
        matrices.method_22909();
        float f = (float)renderState.pos.field_1352;
        float g = (float)renderState.pos.field_1351;
        float h = (float)renderState.pos.field_1350;
        orderedRenderCommandQueue.method_73483(matrices, (class_1921)class_1921.field_21695, (entry, vertexConsumer) -> {
            int segments = 16;
            for (int j = 0; j < segments; ++j) {
                float k = FishingBobberEntityRenderer.percentage(j, segments);
                float l = FishingBobberEntityRenderer.percentage(j + 1, segments);
                FishingBobberEntityRenderer.renderFishingLine(f, g, h, vertexConsumer, entry, k, l);
                FishingBobberEntityRenderer.renderFishingLine(f, g, h, vertexConsumer, entry, l, k);
            }
        });
        matrices.method_22909();
        super.method_3936((class_10017)renderState, matrices, orderedRenderCommandQueue, cameraRenderState);
    }

    private static class_1306 getArmHoldingRod(class_1657 player) {
        return player.method_6047().method_7909() instanceof FishingRodItem ? player.method_6068() : player.method_6068().method_5928();
    }

    private class_243 getHandPos(class_1657 player, float f, float tickDelta) {
        int i;
        int n = i = FishingBobberEntityRenderer.getArmHoldingRod(player) == class_1306.field_6183 ? 1 : -1;
        if (this.field_4676.field_4692.method_31044().method_31034() && player == class_310.method_1551().field_1724) {
            double cameraHeight = this.field_4676.field_4686.method_19326().field_1351;
            class_243 playerPos = player.method_30950(tickDelta);
            class_243 cameraPos = new class_243(playerPos.field_1352, cameraHeight, playerPos.field_1350);
            double fovFactor = 960.0 / (double)((Integer)this.field_4676.field_4692.method_41808().method_41753()).intValue();
            class_243 vec3d = this.field_4676.field_4686.method_36425().method_36427((float)i * 0.525f, -0.1f).method_1021(fovFactor);
            return cameraPos.method_1019(vec3d);
        }
        class_243 cameraPos = player.method_5836(tickDelta);
        float g = player.field_6283 * ((float)Math.PI / 180);
        double d = class_3532.method_15374((float)g);
        double e = class_3532.method_15362((float)g);
        float h = player.method_55693();
        double j = (double)i * 0.35 * (double)h;
        double k = 0.8 * (double)h;
        float l = player.method_18276() ? -0.1875f : 0.0f;
        return cameraPos.method_1031(-e * j - d * k, (double)l - 0.45 * (double)h, -d * j + e * k);
    }

    private static float percentage(int value, int denominator) {
        return (float)value / (float)denominator;
    }

    private static void vertex(class_4588 buffer, class_4587.class_4665 matrix, int light, float x, int y, int u, int v) {
        buffer.method_56824(matrix, x - 0.5f, (float)y - 0.5f, 0.0f).method_39415(-1).method_22913((float)u, (float)v).method_22922(class_4608.field_21444).method_60803(light).method_60831(matrix, 0.0f, 1.0f, 0.0f);
    }

    private static void renderFishingLine(float x, float y, float z, class_4588 buffer, class_4587.class_4665 matrices, float segmentStart, float segmentEnd) {
        float f = x * segmentStart;
        float g = y * (segmentStart * segmentStart + segmentStart) * 0.5f + 0.25f;
        float h = z * segmentStart;
        float i = x * segmentEnd - f;
        float j = y * (segmentEnd * segmentEnd + segmentEnd) * 0.5f + 0.25f - g;
        float k = z * segmentEnd - h;
        float l = class_3532.method_15355((float)(i * i + j * j + k * k));
        buffer.method_22918(matrices.method_23761().translate((Vector3fc)FishingBobberEntityRenderer.getTranslate()), f, g, h).method_39415(-6250336).method_60831(matrices, i /= l, j /= l, k /= l);
    }

    private static Vector3f getTranslate() {
        if (counter == 17) {
            FishingBobberEntityRenderer.calculateTranslate();
            counter = 0;
        }
        ++counter;
        return translate;
    }

    private static void calculateTranslate() {
        class_746 player = class_310.method_1551().field_1724;
        if (class_310.method_1551().field_1773.method_19418().method_19333() || player == null) {
            FishingBobberEntityRenderer.translate.x = 0.0f;
            FishingBobberEntityRenderer.translate.y = 0.0f;
            FishingBobberEntityRenderer.translate.z = 0.0f;
            return;
        }
        float width = class_310.method_1551().method_22683().method_4480();
        float height = class_310.method_1551().method_22683().method_4507();
        float ratio = width / height;
        ratio -= 1.7777778f;
        ratio /= 68.0f;
        float fov = ((Integer)class_310.method_1551().field_1690.method_41808().method_41753()).floatValue();
        float h = class_3532.method_16439((float)FishingBobberEntityRenderer.getTickDelta(), (float)player.field_3914, (float)player.field_3916);
        float i = class_3532.method_16439((float)FishingBobberEntityRenderer.getTickDelta(), (float)player.field_3931, (float)player.field_3932);
        FishingBobberEntityRenderer.translate.x = (ratio /= (70.0f - fov) / 180.0f + 1.0f) + (player.method_5705(FishingBobberEntityRenderer.getTickDelta()) - i) * 1.1E-4f;
        FishingBobberEntityRenderer.translate.y = (player.method_5695(FishingBobberEntityRenderer.getTickDelta()) - h) * 1.0E-4f;
        FishingBobberEntityRenderer.translate.z = 0.0f;
        translate.rotateY(player.method_5705(FishingBobberEntityRenderer.getTickDelta()) / -180.0f * (float)Math.PI);
    }

    public FishingBobberEntityRenderState createRenderState() {
        return new FishingBobberEntityRenderState();
    }

    public void updateRenderState(FishingBobberEntity fishingBobber, FishingBobberEntityRenderState renderState, float tickDelta) {
        super.method_62354((class_1297)fishingBobber, (class_10017)renderState, tickDelta);
        class_1657 playerEntity = fishingBobber.getPlayerOwner();
        if (playerEntity == null) {
            renderState.pos = class_243.field_1353;
        } else {
            float g = playerEntity.method_6055(tickDelta);
            float h = class_3532.method_15374((float)(class_3532.method_15355((float)g) * (float)Math.PI));
            class_243 vec3d = this.getHandPos(playerEntity, h, tickDelta);
            class_243 vec3d2 = fishingBobber.method_30950(tickDelta).method_1031(0.0, 0.25, 0.0);
            renderState.pos = vec3d.method_1020(vec3d2);
        }
    }

    protected boolean canBeCulled(FishingBobberEntity fishingBobber) {
        return false;
    }

    private static float getTickDelta() {
        return class_310.method_1551().method_61966().method_60636();
    }
}

