/*
 * Decompiled with CFR 0.152.
 */
package wd40.hooked.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_10741;
import net.minecraft.class_1309;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import wd40.hooked.data.CatchRecord;
import wd40.hooked.data.PlayerFishData;

public class FishStateSaverAndLoader
extends class_18 {
    private final Map<UUID, PlayerFishData> players = new HashMap<UUID, PlayerFishData>();
    private static final Codec<FishStateSaverAndLoader> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, PlayerFishData.CODEC).fieldOf("players").forGetter(FishStateSaverAndLoader::getPlayersForCodec)).apply((Applicative)instance, FishStateSaverAndLoader::new));
    private static final class_10741<FishStateSaverAndLoader> type = new class_10741("hooked", FishStateSaverAndLoader::new, CODEC, null);

    private FishStateSaverAndLoader() {
    }

    private FishStateSaverAndLoader(Map<String, PlayerFishData> playersRaw) {
        playersRaw.forEach((uuidStr, data) -> this.players.put(UUID.fromString(uuidStr), (PlayerFishData)data));
    }

    private Map<String, PlayerFishData> getPlayersForCodec() {
        HashMap<String, PlayerFishData> raw = new HashMap<String, PlayerFishData>();
        this.players.forEach((uuid, data) -> raw.put(uuid.toString(), (PlayerFishData)data));
        return raw;
    }

    public static FishStateSaverAndLoader getServerState(MinecraftServer server) {
        class_3218 serverWorld = server.method_3847(class_1937.field_25179);
        assert (serverWorld != null);
        FishStateSaverAndLoader state = (FishStateSaverAndLoader)serverWorld.method_17983().method_17924(type);
        state.method_80();
        return state;
    }

    public static PlayerFishData getPlayerState(MinecraftServer server, class_1309 player) {
        FishStateSaverAndLoader serverState = FishStateSaverAndLoader.getServerState(server);
        PlayerFishData playerState = serverState.players.computeIfAbsent(player.method_5667(), uuid -> new PlayerFishData());
        return playerState;
    }

    public void addCatchRecord(UUID playerUuid, CatchRecord record) {
        PlayerFishData playerData = this.players.computeIfAbsent(playerUuid, uuid -> new PlayerFishData());
        playerData.addCatch(record);
        this.method_80();
    }

    public PlayerFishData getPlayerData(UUID playerUuid) {
        return this.players.get(playerUuid);
    }
}

