/*
 * Decompiled with CFR 0.152.
 */
package wd40.hooked.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import wd40.hooked.data.CatchRecord;
import wd40.hooked.util.FishRarity;

public class PlayerFishData {
    public final List<CatchRecord> catchHistory;
    public final Map<String, EnumMap<FishRarity, Integer>> fishCounts;
    public static final Codec<PlayerFishData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CatchRecord.CODEC.listOf().fieldOf("catchHistory").forGetter(d -> d.catchHistory), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.INT)).fieldOf("fishCounts").forGetter(d -> {
        HashMap raw = new HashMap();
        d.fishCounts.forEach((fishId, rarityMap) -> {
            HashMap counts = new HashMap();
            rarityMap.forEach((rarity, count) -> counts.put(rarity.name(), count));
            raw.put(fishId, counts);
        });
        return raw;
    })).apply((Applicative)instance, PlayerFishData::new));

    public PlayerFishData() {
        this.catchHistory = new ArrayList<CatchRecord>();
        this.fishCounts = new HashMap<String, EnumMap<FishRarity, Integer>>();
    }

    private PlayerFishData(List<CatchRecord> catchHistory, Map<String, Map<String, Integer>> fishCountsRaw) {
        this.catchHistory = new ArrayList<CatchRecord>(catchHistory);
        this.fishCounts = new HashMap<String, EnumMap<FishRarity, Integer>>();
        fishCountsRaw.forEach((fishId, counts) -> {
            EnumMap rarityMap = new EnumMap(FishRarity.class);
            counts.forEach((rarityStr, count) -> rarityMap.put(FishRarity.valueOf(rarityStr), count));
            this.fishCounts.put((String)fishId, rarityMap);
        });
    }

    public void addCatch(CatchRecord record) {
        this.catchHistory.add(record);
        this.fishCounts.computeIfAbsent(record.fishId(), k -> new EnumMap(FishRarity.class)).merge(record.rarity(), 1, Integer::sum);
    }

    public int getTotalCatches() {
        return this.catchHistory.size();
    }

    public int getCatchCount(String fishId, FishRarity rarity) {
        return this.fishCounts.getOrDefault(fishId, new EnumMap(FishRarity.class)).getOrDefault((Object)rarity, 0);
    }
}

