/*
 * Decompiled with CFR 0.152.
 */
package wd40.hooked.entity.custom;

import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import wd40.hooked.Hooked;
import wd40.hooked.entity.ModEntities;
import wd40.hooked.item.custom.FishingRodItem;
import wd40.hooked.util.FishingBobberTracker;
import wd40.hooked.util.FishingLootHelper;

public class FishingBobberEntity
extends class_1676 {
    private static final class_2940<Integer> HOOK_ENTITY_ID = class_2945.method_12791(FishingBobberEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> CAUGHT_FISH = class_2945.method_12791(FishingBobberEntity.class, (class_2941)class_2943.field_13323);
    private static final double THROW_OFFSET = 0.3;
    private static final float THROW_VELOCITY_MIN = -5.0f;
    private static final float THROW_VELOCITY_MAX = 5.0f;
    private static final double THROW_VELOCITY_BASE = 0.6;
    private static final double THROW_VELOCITY_VARIANCE_MEAN = 0.5;
    private static final double THROW_VELOCITY_VARIANCE_DEV = 0.0103365;
    private static final double WATER_ENTRY_VELOCITY_X = 0.3;
    private static final double WATER_ENTRY_VELOCITY_Y = 0.2;
    private static final double WATER_ENTRY_VELOCITY_Z = 0.3;
    private static final double BOBBING_HEIGHT_THRESHOLD = 0.01;
    private static final double BOBBING_HEIGHT_ADJUSTMENT = 0.1;
    private static final double BOBBING_VELOCITY_X = 0.9;
    private static final double BOBBING_VELOCITY_Y_MULTIPLIER = 0.2;
    private static final double BOBBING_VELOCITY_Z = 0.9;
    private static final double CAUGHT_FISH_PULL_STRENGTH = -0.1;
    private static final double GRAVITY = -0.03;
    private static final double VELOCITY_DAMPING = 0.92;
    private static final double HOOKED_ENTITY_BODY_HEIGHT = 0.8;
    private static final double PULL_ENTITY_STRENGTH = 0.1;
    private static final int MAX_REMOVAL_TICKS = 1200;
    private static final int MAX_OUT_OF_OPEN_WATER_TICKS = 10;
    private static final double MAX_FISHING_DISTANCE_SQ = 1024.0;
    private static final float CAUGHT_FISH_VELOCITY_Y = -0.4f;
    private static final float CAUGHT_FISH_VELOCITY_MIN = 0.6f;
    private static final float CAUGHT_FISH_VELOCITY_MAX = 1.0f;
    private static final int OPEN_WATER_CHECK_MIN_Y = -1;
    private static final int OPEN_WATER_CHECK_MAX_Y = 2;
    private static final int OPEN_WATER_CHECK_RADIUS = 2;
    private static final int DAMAGE_ENTITY_PULL = 3;
    private static final int DAMAGE_FISH_CAUGHT = 1;
    private static final float FISH_ANGLE_VARIANCE_MEAN = 0.0f;
    private static final float FISH_ANGLE_VARIANCE_DEV = 9.188f;
    private static final float FISH_TRAVEL_DISTANCE_MULTIPLIER = 0.1f;
    private static final float PARTICLE_OFFSET_Y_ABOVE_WATER = 1.0f;
    private static final float PARTICLE_OFFSET_Y_BELOW_WATER = -1.0f;
    private static final float PARTICLE_OFFSET_Y_BUBBLE = -0.1f;
    private static final float PARTICLE_VELOCITY_MULTIPLIER = 0.04f;
    private static final float PARTICLE_VELOCITY_Y = 0.01f;
    private static final float SPLASH_SOUND_VOLUME = 0.25f;
    private static final float SPLASH_SOUND_PITCH_BASE = 1.0f;
    private static final float SPLASH_SOUND_PITCH_VARIANCE = 0.4f;
    private static final float SPLASH_PARTICLE_Y_OFFSET = 0.5f;
    private static final float SPLASH_PARTICLE_COUNT_MULTIPLIER = 20.0f;
    private static final float SPLASH_PARTICLE_COUNT_BASE = 1.0f;
    private static final float SPLASH_PARTICLE_SPREAD = 0.2f;
    private static final float SPLASH_PARTICLE_RADIUS_MIN = 25.0f;
    private static final float SPLASH_PARTICLE_RADIUS_MAX = 60.0f;
    private static final float ANGLE_MIN = 0.0f;
    private static final float ANGLE_MAX = 360.0f;
    private static final int SPLASH_PARTICLE_MIN = 2;
    private static final int SPLASH_PARTICLE_EXTRA = 2;
    private static final float SPLASH_PARTICLE_SPEED = 0.1f;
    private final class_5819 velocityRandom = class_5819.method_43047();
    private boolean caughtFish;
    private int outOfOpenWaterTicks;
    private int removalTimer;
    private int hookCountdown;
    private int waitCountdown;
    private int fishTravelCountdown;
    private float fishAngle;
    private boolean inOpenWater = true;
    @Nullable
    private class_1297 hookedEntity;
    private State state = State.FLYING;
    private final int luckBonus;
    private final int waitTimeReductionTicks;
    private final long fishingStartTime;

    public FishingBobberEntity(class_1299<? extends FishingBobberEntity> entityType, class_1937 world, int luckBonus, int waitTimeReductionTicks) {
        super(entityType, world);
        this.luckBonus = Math.max(0, luckBonus);
        this.waitTimeReductionTicks = Math.max(0, waitTimeReductionTicks);
        this.fishingStartTime = System.currentTimeMillis();
    }

    public FishingBobberEntity(class_1299<? extends FishingBobberEntity> entityType, class_1937 world) {
        this(entityType, world, 0, 0);
    }

    public FishingBobberEntity(class_1657 thrower, class_1937 world, int luckBonus, int waitTimeReductionTicks) {
        this(ModEntities.FISHING_BOBBER, world, luckBonus, waitTimeReductionTicks);
        this.method_7432((class_1297)thrower);
        float f = thrower.method_36455();
        float g = thrower.method_36454();
        float h = class_3532.method_15362((float)(-g * ((float)Math.PI / 180) - (float)Math.PI));
        float i = class_3532.method_15374((float)(-g * ((float)Math.PI / 180) - (float)Math.PI));
        float j = -class_3532.method_15362((float)(-f * ((float)Math.PI / 180)));
        float k = class_3532.method_15374((float)(-f * ((float)Math.PI / 180)));
        double d = thrower.method_23317() - (double)i * 0.3;
        double e = thrower.method_23320();
        double l = thrower.method_23321() - (double)h * 0.3;
        this.method_5808(d, e, l, g, f);
        class_243 vec3d = new class_243((double)(-i), (double)class_3532.method_15363((float)(-(k / j)), (float)-5.0f, (float)5.0f), (double)(-h));
        double m = vec3d.method_1033();
        vec3d = vec3d.method_18805(0.6 / m + this.field_5974.method_43385(0.5, 0.0103365), 0.6 / m + this.field_5974.method_43385(0.5, 0.0103365), 0.6 / m + this.field_5974.method_43385(0.5, 0.0103365));
        this.method_18799(vec3d);
        this.method_36456((float)(class_3532.method_15349((double)vec3d.field_1352, (double)vec3d.field_1350) * 180.0 / 3.1415927410125732));
        this.method_36457((float)(class_3532.method_15349((double)vec3d.field_1351, (double)vec3d.method_37267()) * 180.0 / 3.1415927410125732));
        this.field_5982 = this.method_36454();
        this.field_6004 = this.method_36455();
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(HOOK_ENTITY_ID, (Object)0);
        builder.method_56912(CAUGHT_FISH, (Object)false);
    }

    public void method_5674(class_2940<?> data) {
        if (HOOK_ENTITY_ID.equals(data)) {
            int i = (Integer)this.method_5841().method_12789(HOOK_ENTITY_ID);
            class_1297 class_12972 = this.hookedEntity = i > 0 ? this.method_73183().method_8469(i - 1) : null;
        }
        if (CAUGHT_FISH.equals(data)) {
            this.caughtFish = (Boolean)this.method_5841().method_12789(CAUGHT_FISH);
            if (this.caughtFish) {
                this.method_18800(this.method_18798().field_1352, -0.4f * class_3532.method_15344((class_5819)this.velocityRandom, (float)0.6f, (float)1.0f), this.method_18798().field_1350);
            }
        }
        super.method_5674(data);
    }

    public void method_5773() {
        this.velocityRandom.method_43052(this.method_5667().getLeastSignificantBits() ^ this.method_73183().method_8510());
        super.method_5773();
        class_1657 playerEntity = this.getPlayerOwner();
        if (playerEntity == null) {
            this.method_31472();
        } else if (this.method_73183().method_8608() || !this.removeIfInvalid(playerEntity)) {
            boolean bl;
            if (this.method_24828()) {
                ++this.removalTimer;
                if (this.removalTimer >= 1200) {
                    this.method_31472();
                    return;
                }
            } else {
                this.removalTimer = 0;
            }
            float f = 0.0f;
            class_2338 blockPos = this.method_24515();
            class_3610 fluidState = this.method_73183().method_8316(blockPos);
            if (fluidState.method_15767(class_3486.field_15517)) {
                f = fluidState.method_15763((class_1922)this.method_73183(), blockPos);
            }
            boolean bl2 = bl = f > 0.0f;
            if (this.state == State.FLYING) {
                if (this.hookedEntity != null) {
                    this.method_18799(class_243.field_1353);
                    this.state = State.HOOKED_IN_ENTITY;
                    return;
                }
                if (bl) {
                    this.method_18799(this.method_18798().method_18805(0.3, 0.2, 0.3));
                    this.state = State.BOBBING;
                    return;
                }
                this.checkForCollision();
            } else {
                if (this.state == State.HOOKED_IN_ENTITY) {
                    if (this.hookedEntity != null) {
                        if (!this.hookedEntity.method_31481() && this.hookedEntity.method_73183().method_27983() == this.method_73183().method_27983()) {
                            this.method_5814(this.hookedEntity.method_23317(), this.hookedEntity.method_23323(0.8), this.hookedEntity.method_23321());
                        } else {
                            this.updateHookedEntityId(null);
                            this.state = State.FLYING;
                        }
                    }
                    return;
                }
                if (this.state == State.BOBBING) {
                    class_243 vec3d = this.method_18798();
                    double d = this.method_23318() + vec3d.field_1351 - (double)blockPos.method_10264() - (double)f;
                    if (Math.abs(d) < 0.01) {
                        d += Math.signum(d) * 0.1;
                    }
                    this.method_18800(vec3d.field_1352 * 0.9, vec3d.field_1351 - d * (double)this.field_5974.method_43057() * 0.2, vec3d.field_1350 * 0.9);
                    if (this.hookCountdown <= 0 && this.fishTravelCountdown <= 0) {
                        this.inOpenWater = true;
                    } else {
                        boolean bl3 = this.inOpenWater = this.inOpenWater && this.outOfOpenWaterTicks < 10 && this.isOpenOrWaterAround(blockPos);
                    }
                    if (bl) {
                        this.outOfOpenWaterTicks = Math.max(0, this.outOfOpenWaterTicks - 1);
                        if (this.caughtFish) {
                            this.method_18799(this.method_18798().method_1031(0.0, -0.1 * (double)this.velocityRandom.method_43057() * (double)this.velocityRandom.method_43057(), 0.0));
                        }
                        if (!this.method_73183().method_8608()) {
                            this.tickFishingLogic(blockPos);
                        }
                    } else {
                        this.outOfOpenWaterTicks = Math.min(10, this.outOfOpenWaterTicks + 1);
                    }
                }
            }
            if (!fluidState.method_15767(class_3486.field_15517) && !this.method_24828() && this.hookedEntity == null) {
                this.method_18799(this.method_18798().method_1031(0.0, -0.03, 0.0));
            }
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_61409();
            this.method_26962();
            if (this.state == State.FLYING && (this.method_24828() || this.field_5976)) {
                this.method_18799(class_243.field_1353);
            }
            this.method_18799(this.method_18798().method_1021(0.92));
            this.method_23311();
        }
    }

    private boolean removeIfInvalid(class_1657 player) {
        class_1799 itemStack = player.method_6047();
        class_1799 itemStack2 = player.method_6079();
        boolean bl = itemStack.method_7909() instanceof FishingRodItem;
        boolean bl2 = itemStack2.method_7909() instanceof FishingRodItem;
        if (!player.method_31481() && player.method_5805() && (bl || bl2) && this.method_5858((class_1297)player) <= 1024.0) {
            return false;
        }
        this.method_31472();
        return true;
    }

    private void checkForCollision() {
        class_239 hitResult = class_1675.method_49997((class_1297)this, this::method_26958);
        this.method_59860(hitResult);
    }

    protected boolean method_26958(class_1297 entity) {
        return super.method_26958(entity) || entity.method_5805() && entity instanceof class_1542;
    }

    private void updateHookedEntityId(@Nullable class_1297 entity) {
        this.hookedEntity = entity;
        this.method_5841().method_12778(HOOK_ENTITY_ID, (Object)(entity == null ? 0 : entity.method_5628() + 1));
    }

    private void tickFishingLogic(class_2338 pos) {
        int maxWaitTime;
        class_3218 serverWorld = (class_3218)this.method_73183();
        int ticksPerCycle = 1;
        class_2338 blockPos = pos.method_10084();
        float rainBonus = 0.25f;
        int rainSpeedMultiplier = 4;
        float shadeChance = 0.5f;
        int shadePenalty = 1;
        if (this.field_5974.method_43057() < rainBonus && this.method_73183().method_8520(blockPos)) {
            ticksPerCycle = rainSpeedMultiplier;
        }
        if (this.field_5974.method_43057() < shadeChance && !this.method_73183().method_8311(blockPos)) {
            ticksPerCycle -= shadePenalty;
        }
        int minHookTime = Hooked.isDevelopmentEnvironment() ? 72000 : 20;
        int maxHookTime = Hooked.isDevelopmentEnvironment() ? 144000 : 40;
        int minFishTravelTime = 20;
        int maxFishTravelTime = 80;
        int minWaitTime = Hooked.isDevelopmentEnvironment() ? 1 : 100;
        int n = maxWaitTime = Hooked.isDevelopmentEnvironment() ? 20 : 600;
        if (this.hookCountdown > 0) {
            --this.hookCountdown;
            if (this.hookCountdown <= 0) {
                this.waitCountdown = 0;
                this.fishTravelCountdown = 0;
                this.method_5841().method_12778(CAUGHT_FISH, (Object)false);
            }
        } else if (this.fishTravelCountdown > 0) {
            this.fishTravelCountdown -= ticksPerCycle;
            if (this.fishTravelCountdown > 0) {
                double j;
                double e;
                this.fishAngle += this.field_5974.method_62816(0.0f, 9.188f);
                float f = this.fishAngle * ((float)Math.PI / 180);
                float g = class_3532.method_15374((float)f);
                float h = class_3532.method_15362((float)f);
                double d = this.method_23317() + (double)(g * (float)this.fishTravelCountdown * 0.1f);
                class_2680 blockState = serverWorld.method_8320(class_2338.method_49637((double)d, (double)((e = (double)((float)class_3532.method_15357((double)this.method_23318()) + 1.0f)) + -1.0), (double)(j = this.method_23321() + (double)(h * (float)this.fishTravelCountdown * 0.1f))));
                if (blockState.method_27852(class_2246.field_10382)) {
                    float bubbleChance = 0.15f;
                    if (this.field_5974.method_43057() < bubbleChance) {
                        serverWorld.method_65096((class_2394)class_2398.field_11247, d, e + (double)-0.1f, j, 1, (double)g, (double)0.1f, (double)h, 0.0);
                    }
                    float k = g * 0.04f;
                    float l = h * 0.04f;
                    serverWorld.method_65096((class_2394)class_2398.field_11244, d, e, j, 0, (double)l, (double)0.01f, (double)(-k), 1.0);
                    serverWorld.method_65096((class_2394)class_2398.field_11244, d, e, j, 0, (double)(-l), (double)0.01f, (double)k, 1.0);
                }
            } else {
                this.method_5783(class_3417.field_14660, 0.25f, 1.0f + (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.4f);
                double m = this.method_23318() + 0.5;
                serverWorld.method_65096((class_2394)class_2398.field_11247, this.method_23317(), m, this.method_23321(), (int)(1.0f + this.method_17681() * 20.0f), (double)this.method_17681(), 0.0, (double)this.method_17681(), (double)0.2f);
                serverWorld.method_65096((class_2394)class_2398.field_11244, this.method_23317(), m, this.method_23321(), (int)(1.0f + this.method_17681() * 20.0f), (double)this.method_17681(), 0.0, (double)this.method_17681(), (double)0.2f);
                this.hookCountdown = class_3532.method_15395((class_5819)this.field_5974, (int)minHookTime, (int)maxHookTime);
                this.method_5841().method_12778(CAUGHT_FISH, (Object)true);
            }
        } else if (this.waitCountdown > 0) {
            float baseSplashChance;
            this.waitCountdown -= ticksPerCycle;
            float f = baseSplashChance = 0.15f;
            int nearBiteThreshold = 20;
            int midBiteThreshold = 40;
            int farBiteThreshold = 60;
            float nearBiteBonus = 0.05f;
            float midBiteBonus = 0.02f;
            float farBiteBonus = 0.01f;
            if (this.waitCountdown < nearBiteThreshold) {
                f += (float)(nearBiteThreshold - this.waitCountdown) * nearBiteBonus;
            } else if (this.waitCountdown < midBiteThreshold) {
                f += (float)(midBiteThreshold - this.waitCountdown) * midBiteBonus;
            } else if (this.waitCountdown < farBiteThreshold) {
                f += (float)(farBiteThreshold - this.waitCountdown) * farBiteBonus;
            }
            if (this.field_5974.method_43057() < f) {
                double j;
                double e;
                float g = class_3532.method_15344((class_5819)this.field_5974, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                float h = class_3532.method_15344((class_5819)this.field_5974, (float)25.0f, (float)60.0f);
                double d = this.method_23317() + (double)(class_3532.method_15374((float)g) * h * 0.1f);
                class_2680 blockState = serverWorld.method_8320(class_2338.method_49637((double)d, (double)((e = (double)((float)class_3532.method_15357((double)this.method_23318()) + 1.0f)) + -1.0), (double)(j = this.method_23321() + (double)(class_3532.method_15362((float)g) * h * 0.1f))));
                if (blockState.method_27852(class_2246.field_10382)) {
                    serverWorld.method_65096((class_2394)class_2398.field_11202, d, e, j, 2 + this.field_5974.method_43048(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                }
            }
            if (this.waitCountdown <= 0) {
                this.fishAngle = class_3532.method_15344((class_5819)this.field_5974, (float)0.0f, (float)360.0f);
                this.fishTravelCountdown = class_3532.method_15395((class_5819)this.field_5974, (int)minFishTravelTime, (int)maxFishTravelTime);
            }
        } else if (FishingLootHelper.canCatchFishInBiome(serverWorld, pos)) {
            this.waitCountdown = class_3532.method_15395((class_5819)this.field_5974, (int)minWaitTime, (int)maxWaitTime);
            this.waitCountdown -= this.waitTimeReductionTicks;
        }
    }

    private boolean isOpenOrWaterAround(class_2338 pos) {
        PositionType positionType = PositionType.INVALID;
        for (int i = -1; i <= 2; ++i) {
            PositionType positionType2 = this.getPositionType(pos.method_10069(-2, i, -2), pos.method_10069(2, i, 2));
            switch (positionType2.ordinal()) {
                case 0: {
                    if (positionType != PositionType.INVALID) break;
                    return false;
                }
                case 1: {
                    if (positionType != PositionType.ABOVE_WATER) break;
                    return false;
                }
                case 2: {
                    return false;
                }
            }
            positionType = positionType2;
        }
        return true;
    }

    private PositionType getPositionType(class_2338 start, class_2338 end) {
        return class_2338.method_20437((class_2338)start, (class_2338)end).map(this::getPositionType).reduce((positionType, positionType2) -> positionType == positionType2 ? positionType : PositionType.INVALID).orElse(PositionType.INVALID);
    }

    private PositionType getPositionType(class_2338 pos) {
        class_2680 blockState = this.method_73183().method_8320(pos);
        if (!blockState.method_26215() && !blockState.method_27852(class_2246.field_10588)) {
            class_3610 fluidState = blockState.method_26227();
            return fluidState.method_15767(class_3486.field_15517) && fluidState.method_15771() && blockState.method_26220((class_1922)this.method_73183(), pos).method_1110() ? PositionType.INSIDE_WATER : PositionType.INVALID;
        }
        return PositionType.ABOVE_WATER;
    }

    public int use(class_1799 usedItem) {
        class_1657 playerEntity = this.getPlayerOwner();
        if (!this.method_73183().method_8608() && playerEntity != null) {
            int damage = 0;
            if (this.hookedEntity != null) {
                this.pullHookedEntity(this.hookedEntity);
                damage = 3;
            } else if (this.hookCountdown > 0) {
                this.dropLoot(playerEntity);
                damage = 1;
            }
            this.method_31472();
            return damage;
        }
        return 0;
    }

    private void pullHookedEntity(class_1297 entity) {
        class_1657 player = this.getPlayerOwner();
        if (player == null) {
            return;
        }
        class_243 vec3d = new class_243(player.method_23317() - this.method_23317(), player.method_23318() - this.method_23318(), player.method_23321() - this.method_23321()).method_1021(0.1);
        entity.method_18799(entity.method_18798().method_1019(vec3d));
    }

    private void dropLoot(class_1657 player) {
        class_3218 serverWorld = (class_3218)this.method_73183();
        FishingLootHelper.dropLoot(player, serverWorld, this.method_23317(), this.method_23318(), this.method_23321(), this.method_24515(), this.getFishingDuration());
    }

    protected void method_24920(class_3965 blockHitResult) {
        super.method_24920(blockHitResult);
        this.method_18799(this.method_18798().method_1029().method_1021(blockHitResult.method_24801((class_1297)this)));
    }

    protected void method_7454(class_3966 entityHitResult) {
        super.method_7454(entityHitResult);
        if (!this.method_73183().method_8608()) {
            this.updateHookedEntityId(entityHitResult.method_17782());
        }
    }

    public void method_5650(class_1297.class_5529 reason) {
        class_1657 player = this.getPlayerOwner();
        if (player != null) {
            FishingBobberTracker.removeBobber(player.method_5667());
        }
        super.method_5650(reason);
    }

    public void method_36209() {
        class_1657 player = this.getPlayerOwner();
        if (player != null) {
            FishingBobberTracker.removeBobber(player.method_5667());
        }
        super.method_36209();
    }

    public void method_7432(@Nullable class_1297 owner) {
        super.method_7432(owner);
    }

    @Nullable
    public class_1657 getPlayerOwner() {
        class_1657 playerEntity;
        class_1297 entity = this.method_24921();
        return entity instanceof class_1657 ? (playerEntity = (class_1657)entity) : null;
    }

    @Nullable
    public class_1297 getHookedEntity() {
        return this.hookedEntity;
    }

    public long getFishingDuration() {
        return System.currentTimeMillis() - this.fishingStartTime;
    }

    public boolean method_5822(boolean allowVehicles) {
        return false;
    }

    public static enum State {
        FLYING,
        HOOKED_IN_ENTITY,
        BOBBING;

    }

    static enum PositionType {
        ABOVE_WATER,
        INSIDE_WATER,
        INVALID;

    }
}

