/*
 * Decompiled with CFR 0.152.
 */
package wd40.hooked.screen.fishingjournal;

import io.wispforest.owo.ui.base.BaseUIModelScreen;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import wd40.hooked.Hooked;
import wd40.hooked.data.CatchRecord;
import wd40.hooked.networking.JournalData;
import wd40.hooked.screen.fishingjournal.content.BookContent;
import wd40.hooked.screen.fishingjournal.content.BookEntry;
import wd40.hooked.screen.fishingjournal.entries.CollectionEntry;
import wd40.hooked.screen.fishingjournal.entries.HistoryScroll;
import wd40.hooked.screen.fishingjournal.pages.BasicInfoPage;
import wd40.hooked.screen.fishingjournal.pages.PlayerStatsPage;
import wd40.hooked.ui.component.DynamicTextureComponent;

@Environment(value=EnvType.CLIENT)
public class FishingJournalScreen
extends BaseUIModelScreen<FlowLayout> {
    private final JournalData journalData;
    private FlowLayout leftPanel;
    private FlowLayout rightPanel;
    private BookContent leftContent;
    private BookContent rightContent;
    private String selectedFish;
    private CatchRecord historyFish;

    public FishingJournalScreen(JournalData journalData) {
        super(FlowLayout.class, BaseUIModelScreen.DataSource.asset((class_2960)class_2960.method_60655((String)"hooked", (String)"fishing_journal/main")));
        this.journalData = journalData;
        if (!journalData.catchHistory().isEmpty()) {
            this.selectedFish = journalData.catchHistory().get(journalData.catchHistory().size() - 1).fishId();
        } else if (!journalData.caughtFishIds().isEmpty()) {
            this.selectedFish = journalData.caughtFishIds().iterator().next();
        }
    }

    public static void open(JournalData journalData) {
        class_310.method_1551().method_1507((class_437)new FishingJournalScreen(journalData));
    }

    protected void build(FlowLayout rootComponent) {
        Component historyButton;
        Component collectionButton;
        this.leftPanel = (FlowLayout)rootComponent.childById(FlowLayout.class, "left-panel");
        this.rightPanel = (FlowLayout)rootComponent.childById(FlowLayout.class, "right-panel");
        Component homeButton = rootComponent.childById(DynamicTextureComponent.class, "home-button");
        if (homeButton != null) {
            homeButton.mouseDown().subscribe((mouseX, mouseY) -> {
                this.showHomeSection();
                return true;
            });
        }
        if ((collectionButton = rootComponent.childById(DynamicTextureComponent.class, "collection-button")) != null) {
            collectionButton.mouseDown().subscribe((mouseX, mouseY) -> {
                this.showCollectionSection();
                return true;
            });
        }
        if ((historyButton = rootComponent.childById(DynamicTextureComponent.class, "history-button")) != null) {
            historyButton.mouseDown().subscribe((mouseX, mouseY) -> {
                this.showHistorySection();
                return true;
            });
        }
        this.showHomeSection();
    }

    public void setLeftContent(BookContent content) {
        if (this.leftContent != null) {
            this.leftContent.cleanup();
        }
        this.leftPanel.clearChildren();
        this.leftContent = content;
        if (content != null) {
            if (content instanceof BookEntry) {
                ((BookEntry)content).setPanelSide(BookEntry.PanelSide.LEFT);
            }
            FlowLayout contentRoot = content.render();
            this.leftPanel.child((Component)contentRoot);
        }
    }

    public void setRightContent(BookContent content) {
        if (this.rightContent != null) {
            this.rightContent.cleanup();
        }
        this.rightPanel.clearChildren();
        this.rightContent = content;
        if (content != null) {
            if (content instanceof BookEntry) {
                ((BookEntry)content).setPanelSide(BookEntry.PanelSide.RIGHT);
            }
            FlowLayout contentRoot = content.render();
            this.rightPanel.child((Component)contentRoot);
        }
    }

    private void showHomeSection() {
        Hooked.LOGGER.info("Showing Home section");
        PlayerStatsPage playerStats = new PlayerStatsPage(this.journalData);
        this.setLeftContent(playerStats);
        BasicInfoPage basicInfo = new BasicInfoPage(this::getSelectedFish, this.journalData);
        this.setRightContent(basicInfo);
    }

    private void showCollectionSection() {
        Hooked.LOGGER.info("Showing Collection section");
        BasicInfoPage basicInfo = new BasicInfoPage(this::getSelectedFish, this.journalData);
        this.setLeftContent(basicInfo);
        CollectionEntry collection = new CollectionEntry(this.journalData, this::onFishSelected);
        this.setRightContent(collection);
    }

    private void showHistorySection() {
        Hooked.LOGGER.info("Showing History section");
        BasicInfoPage basicInfo = new BasicInfoPage(this::getSelectedFish, this.journalData);
        this.setLeftContent(basicInfo);
        HistoryScroll historyScroll = new HistoryScroll(this.journalData, this::getSelectedFish, this::onFishSelected);
        this.setRightContent(historyScroll);
    }

    private void onFishSelected(String fishId) {
        Hooked.LOGGER.info("Fish selected from collection: {}", (Object)fishId);
        this.setSelectedFish(fishId);
    }

    public String getSelectedFish() {
        return this.selectedFish;
    }

    public void setSelectedFish(String fishId) {
        Hooked.LOGGER.info("Selected fish changed to: {}", (Object)fishId);
        this.selectedFish = fishId;
        if (this.leftContent != null) {
            this.leftContent.update();
        }
        if (this.rightContent != null) {
            this.rightContent.update();
        }
    }

    public CatchRecord getHistoryFish() {
        return this.historyFish;
    }

    public void setHistoryFish(CatchRecord record) {
        Hooked.LOGGER.info("History fish changed to: {}", (Object)(record != null ? record.fishId() : "null"));
        this.historyFish = record;
        if (this.leftContent != null) {
            this.leftContent.update();
        }
        if (this.rightContent != null) {
            this.rightContent.update();
        }
    }

    public JournalData getJournalData() {
        return this.journalData;
    }
}

