/*
 * Decompiled with CFR 0.152.
 */
package wd40.hooked.screen.fishingjournal.content;

import io.wispforest.owo.ui.base.BaseUIModelScreen;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.parsing.UIModel;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import wd40.hooked.screen.fishingjournal.content.BookContent;
import wd40.hooked.ui.component.DynamicTextureComponent;

@Environment(value=EnvType.CLIENT)
public abstract class BookEntry
implements BookContent {
    protected FlowLayout entryRoot;
    protected FlowLayout contentContainer;
    protected UIModel model;
    protected int currentPageIndex = 0;
    protected PanelSide panelSide = PanelSide.LEFT;
    private Component previousButton;
    private Component nextButton;

    public void setPanelSide(PanelSide side) {
        this.panelSide = side;
    }

    @Override
    public FlowLayout render() {
        this.model = BaseUIModelScreen.DataSource.asset((class_2960)class_2960.method_60655((String)"hooked", (String)"fishing_journal/templates/entry")).get();
        this.entryRoot = (FlowLayout)this.model.expandTemplate(FlowLayout.class, "entry", Map.of());
        this.contentContainer = (FlowLayout)this.entryRoot.childById(FlowLayout.class, "content-container");
        this.previousButton = this.entryRoot.childById(DynamicTextureComponent.class, "previous-button-normal");
        this.nextButton = this.entryRoot.childById(DynamicTextureComponent.class, "next-button-normal");
        Component previousButtonHover = this.entryRoot.childById(DynamicTextureComponent.class, "previous-button-hover");
        Component nextButtonHover = this.entryRoot.childById(DynamicTextureComponent.class, "next-button-hover");
        previousButtonHover.positioning(Positioning.absolute((int)-1000, (int)-1000));
        nextButtonHover.positioning(Positioning.absolute((int)-1000, (int)-1000));
        this.previousButton.mouseDown().subscribe((mouseX, mouseY) -> {
            if (this.currentPageIndex > 0) {
                --this.currentPageIndex;
                this.refreshPage();
            }
            return true;
        });
        this.nextButton.mouseDown().subscribe((mouseX, mouseY) -> {
            if (this.currentPageIndex < this.getPageCount() - 1) {
                ++this.currentPageIndex;
                this.refreshPage();
            }
            return true;
        });
        this.previousButton.mouseEnter().subscribe(() -> previousButtonHover.positioning((Positioning)this.previousButton.positioning().get()));
        this.previousButton.mouseLeave().subscribe(() -> previousButtonHover.positioning(Positioning.absolute((int)-1000, (int)-1000)));
        this.nextButton.mouseEnter().subscribe(() -> nextButtonHover.positioning((Positioning)this.nextButton.positioning().get()));
        this.nextButton.mouseLeave().subscribe(() -> nextButtonHover.positioning(Positioning.absolute((int)-1000, (int)-1000)));
        FlowLayout navigationBar = (FlowLayout)this.entryRoot.childById(FlowLayout.class, "navigation-bar");
        if (navigationBar != null) {
            if (this.panelSide == PanelSide.LEFT) {
                navigationBar.horizontalAlignment(HorizontalAlignment.LEFT);
            } else {
                navigationBar.horizontalAlignment(HorizontalAlignment.RIGHT);
            }
        }
        this.refreshPage();
        return this.entryRoot;
    }

    private void refreshPage() {
        this.contentContainer.clearChildren();
        this.buildPage(this.currentPageIndex, this.contentContainer);
    }

    protected abstract int getPageCount();

    protected abstract void buildPage(int var1, FlowLayout var2);

    @Override
    public void update() {
        if (this.entryRoot != null) {
            this.refreshPage();
        }
    }

    @Override
    public void cleanup() {
    }

    public FlowLayout getRoot() {
        return this.entryRoot;
    }

    public int getCurrentPageIndex() {
        return this.currentPageIndex;
    }

    public void setCurrentPageIndex(int pageIndex) {
        if (pageIndex >= 0 && pageIndex < this.getPageCount()) {
            this.currentPageIndex = pageIndex;
            if (this.entryRoot != null) {
                this.refreshPage();
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum PanelSide {
        LEFT,
        RIGHT;

    }
}

