/*
 * Decompiled with CFR 0.152.
 */
package wd40.hooked.screen.fishingjournal.entries;

import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.ItemComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.GridLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Sizing;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import wd40.hooked.Hooked;
import wd40.hooked.item.ModItems;
import wd40.hooked.networking.JournalData;
import wd40.hooked.screen.fishingjournal.content.BookEntry;
import wd40.hooked.util.FishData;
import wd40.hooked.util.FishDictionary;

@Environment(value=EnvType.CLIENT)
public class CollectionEntry
extends BookEntry {
    private static final int COLUMNS = 6;
    private static final int ROWS_PER_PAGE = 8;
    private static final int FISH_PER_PAGE = 48;
    private static final int SLOT_MARGIN = 2;
    private final JournalData journalData;
    private final Consumer<String> onFishClicked;
    private final List<FishData> allFish;

    public CollectionEntry(JournalData journalData, Consumer<String> onFishClicked) {
        this.journalData = journalData;
        this.onFishClicked = onFishClicked;
        this.allFish = new ArrayList<FishData>(FishDictionary.getAll().values());
        Hooked.LOGGER.info("CollectionEntry created with {} fish, {} pages", (Object)this.allFish.size(), (Object)this.getPageCount());
    }

    @Override
    protected int getPageCount() {
        int pageCount = (int)Math.ceil((double)this.allFish.size() / 48.0);
        return Math.max(1, pageCount);
    }

    @Override
    protected void buildPage(int pageIndex, FlowLayout container) {
        Hooked.LOGGER.info("Building collection page {} of {}", (Object)(pageIndex + 1), (Object)this.getPageCount());
        container.clearChildren();
        FlowLayout searchBarPlaceholder = Containers.verticalFlow((Sizing)Sizing.fixed((int)140), (Sizing)Sizing.fixed((int)20));
        searchBarPlaceholder.id("search-bar-placeholder");
        container.child((Component)searchBarPlaceholder);
        GridLayout fishGrid = Containers.grid((Sizing)Sizing.fixed((int)140), (Sizing)Sizing.fixed((int)140), (int)8, (int)6);
        int startIndex = pageIndex * 48;
        int endIndex = Math.min(startIndex + 48, this.allFish.size());
        for (int i = startIndex; i < endIndex; ++i) {
            FishData fishData = this.allFish.get(i);
            int gridIndex = i - startIndex;
            int col = gridIndex % 6;
            int row = gridIndex / 6;
            FlowLayout slotContainer = this.createFishSlot(fishData);
            fishGrid.child((Component)slotContainer, col, row);
        }
        container.child((Component)fishGrid);
    }

    private FlowLayout createFishSlot(FishData fishData) {
        FlowLayout slotContainer = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        slotContainer.margins(Insets.of((int)2));
        String fishId = fishData.getId();
        boolean hasCaught = this.journalData.caughtFishIds().contains(fishId);
        if (!hasCaught) {
            class_2960 blackTexture = class_2960.method_60655((String)"hooked", (String)("textures/item/fish/black/" + fishId + ".png"));
            Component textureComponent = Components.texture((class_2960)blackTexture, (int)0, (int)0, (int)16, (int)16, (int)16, (int)16).sizing(Sizing.fixed((int)16));
            slotContainer.child(textureComponent);
        } else {
            class_1792 fishItem = ModItems.getFishItem(fishId);
            if (fishItem != null) {
                ItemComponent itemComponent = Components.item((class_1799)new class_1799((class_1935)fishItem));
                itemComponent.mouseDown().subscribe((click, doubled) -> {
                    Hooked.LOGGER.info("Fish clicked: {}", (Object)fishId);
                    if (this.onFishClicked != null) {
                        this.onFishClicked.accept(fishId);
                    }
                    return true;
                });
                slotContainer.child((Component)itemComponent);
            }
        }
        return slotContainer;
    }
}

