/*
 * Decompiled with CFR 0.152.
 */
package wd40.hooked.screen.fishingjournal.entries;

import io.wispforest.owo.ui.base.BaseUIModelScreen;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.parsing.UIModel;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import wd40.hooked.Hooked;
import wd40.hooked.data.CatchRecord;
import wd40.hooked.networking.JournalData;
import wd40.hooked.screen.fishingjournal.content.BookContent;
import wd40.hooked.util.FishData;
import wd40.hooked.util.FishDictionary;

@Environment(value=EnvType.CLIENT)
public class HistoryScroll
implements BookContent {
    private final JournalData journalData;
    private final Supplier<String> selectedFishSupplier;
    private final Consumer<String> onFishClicked;
    private FlowLayout scrollRoot;
    private ScrollContainer scrollContainer;
    private FlowLayout listContainer;
    private UIModel model;

    public HistoryScroll(JournalData journalData, Supplier<String> selectedFishSupplier, Consumer<String> onFishClicked) {
        this.journalData = journalData;
        this.selectedFishSupplier = selectedFishSupplier;
        this.onFishClicked = onFishClicked;
    }

    @Override
    public FlowLayout render() {
        this.model = BaseUIModelScreen.DataSource.asset((class_2960)class_2960.method_60655((String)"hooked", (String)"fishing_journal/templates/scroll")).get();
        this.scrollRoot = (FlowLayout)this.model.expandTemplate(FlowLayout.class, "scroll", Map.of());
        this.scrollContainer = (ScrollContainer)this.scrollRoot.childById(ScrollContainer.class, "scroll-container");
        this.listContainer = (FlowLayout)this.scrollRoot.childById(FlowLayout.class, "list-container");
        if (this.listContainer == null) {
            Hooked.LOGGER.error("Could not find list-container in scroll template");
            return this.scrollRoot;
        }
        this.buildCatchList();
        return this.scrollRoot;
    }

    private void buildCatchList() {
        this.listContainer.clearChildren();
        List<CatchRecord> catchHistory = this.journalData.catchHistory();
        if (catchHistory.isEmpty()) {
            LabelComponent emptyLabel = Components.label((class_2561)class_2561.method_43470((String)"No catches yet!"));
            emptyLabel.margins(Insets.of((int)4));
            this.listContainer.child((Component)emptyLabel);
            return;
        }
        for (CatchRecord record : catchHistory) {
            FlowLayout catchRow = this.createCatchRow(record);
            this.listContainer.child((Component)catchRow);
        }
        Hooked.LOGGER.info("HistoryScroll built with {} catches", (Object)catchHistory.size());
    }

    private FlowLayout createCatchRow(CatchRecord record) {
        FlowLayout rowContainer = Containers.horizontalFlow((Sizing)Sizing.fixed((int)110), (Sizing)Sizing.content());
        rowContainer.margins(Insets.of((int)2));
        rowContainer.padding(Insets.of((int)2));
        FishData fishData = FishDictionary.get(record.fishId());
        String fishName = fishData != null ? fishData.getTranslationKey() : record.fishId();
        FlowLayout leftColumn = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        class_5250 rarityText = class_2561.method_43471((String)record.rarity().getTranslationKey()).method_27694(style -> style.method_10977(record.rarity().getColor()));
        class_5250 fishNameText = (fishData != null ? class_2561.method_43471((String)fishName) : class_2561.method_43470((String)record.fishId())).method_27694(style -> style.method_36139(0));
        FlowLayout nameRow = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        LabelComponent nameLabel = Components.label((class_2561)fishNameText);
        nameLabel.margins(Insets.of((int)0, (int)2, (int)0, (int)0));
        nameRow.child((Component)nameLabel);
        FlowLayout spacer = Containers.horizontalFlow((Sizing)Sizing.fill((int)1), (Sizing)Sizing.content());
        nameRow.child((Component)spacer);
        LabelComponent rarityLabel = Components.label((class_2561)rarityText);
        nameRow.child((Component)rarityLabel);
        leftColumn.child((Component)nameRow);
        LabelComponent biomeLabel = Components.label((class_2561)class_2561.method_43470((String)this.formatBiome(record.biome())).method_27694(style -> style.method_36139(0xAAAAFF)));
        biomeLabel.margins(Insets.of((int)2, (int)2, (int)0, (int)0));
        rowContainer.child((Component)leftColumn);
        rowContainer.child((Component)biomeLabel);
        rowContainer.mouseDown().subscribe((mouseX, mouseY) -> {
            Hooked.LOGGER.info("Catch record clicked: {}", (Object)record.fishId());
            if (this.onFishClicked != null) {
                this.onFishClicked.accept(record.fishId());
            }
            return true;
        });
        rowContainer.surface(Surface.flat((int)0x1F1F1F));
        return rowContainer;
    }

    private String formatDate(long irlTime) {
        if (irlTime == 0L) {
            return "Unknown";
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yy HH:mm");
            return sdf.format(new Date(irlTime));
        }
        catch (Exception e) {
            Hooked.LOGGER.warn("Failed to format date: {}", (Object)irlTime);
            return "Invalid";
        }
    }

    private String formatBiome(String biome) {
        if (biome == null || biome.isEmpty()) {
            return "Unknown";
        }
        Object name = biome.contains(":") ? biome.split(":")[1] : biome;
        if (((String)(name = ((String)name).replace("_", " "))).length() > 0) {
            name = ((String)name).substring(0, 1).toUpperCase() + ((String)name).substring(1);
        }
        return name;
    }

    @Override
    public void update() {
    }

    @Override
    public void cleanup() {
    }
}

