/*
 * Decompiled with CFR 0.152.
 */
package wd40.hooked.screen.fishingjournal.pages;

import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Sizing;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import wd40.hooked.Hooked;
import wd40.hooked.data.CatchRecord;
import wd40.hooked.networking.JournalData;
import wd40.hooked.screen.fishingjournal.content.BookPage;
import wd40.hooked.util.FishData;
import wd40.hooked.util.FishDictionary;

@Environment(value=EnvType.CLIENT)
public class BasicInfoPage
extends BookPage {
    private final Supplier<String> fishIdSupplier;
    private final JournalData journalData;

    public BasicInfoPage(Supplier<String> fishIdSupplier, JournalData journalData) {
        super("fishing_journal/pages/content/basic_info");
        this.fishIdSupplier = fishIdSupplier;
        this.journalData = journalData;
    }

    @Override
    protected void buildContent() {
        FlowLayout fishImageContainer = (FlowLayout)this.contentRoot.childById(FlowLayout.class, "fish-image");
        LabelComponent fishNameLabel = (LabelComponent)this.contentRoot.childById(LabelComponent.class, "fish-name");
        LabelComponent totalCaughtLabel = (LabelComponent)this.contentRoot.childById(LabelComponent.class, "total-caught");
        LabelComponent totalTimeLabel = (LabelComponent)this.contentRoot.childById(LabelComponent.class, "total-time-fishing");
        if (fishImageContainer == null || fishNameLabel == null || totalCaughtLabel == null || totalTimeLabel == null) {
            Hooked.LOGGER.error("Could not find required components in basic_info content XML");
            return;
        }
        String fishId = this.fishIdSupplier.get();
        FishData fishData = FishDictionary.get(fishId);
        if (fishData == null) {
            Hooked.LOGGER.warn("Fish data not found for: {}", (Object)fishId);
            fishNameLabel.text((class_2561)class_2561.method_43470((String)"Unknown Fish"));
            totalCaughtLabel.text((class_2561)class_2561.method_43470((String)"Caught: 0"));
            totalTimeLabel.text((class_2561)class_2561.method_43470((String)"Time: 0s"));
            return;
        }
        long totalCaught = this.journalData.catchHistory().stream().filter(record -> record.fishId().equals(fishId)).count();
        long totalMillis = this.journalData.catchHistory().stream().filter(record -> record.fishId().equals(fishId)).mapToLong(CatchRecord::fishingDuration).sum();
        String totalTimeFormatted = this.formatTime(totalMillis);
        fishImageContainer.clearChildren();
        class_2960 fishTexture = class_2960.method_60655((String)"hooked", (String)("textures/item/fish/" + fishId + ".png"));
        Component fishImage = Components.texture((class_2960)fishTexture, (int)0, (int)0, (int)16, (int)16, (int)16, (int)16).sizing(Sizing.fixed((int)32));
        fishImageContainer.child(fishImage);
        fishNameLabel.text((class_2561)class_2561.method_43471((String)fishData.getTranslationKey()));
        totalCaughtLabel.text((class_2561)class_2561.method_43470((String)("Caught: " + totalCaught)));
        totalTimeLabel.text((class_2561)class_2561.method_43470((String)("Time: " + totalTimeFormatted)));
        Hooked.LOGGER.info("BasicInfoPage built for {} - {} caught, {} time", new Object[]{fishId, totalCaught, totalTimeFormatted});
    }

    private String formatTime(long millis) {
        if (millis == 0L) {
            return "0s";
        }
        long seconds = millis / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        if (hours > 0L) {
            return hours + "h " + minutes % 60L + "m";
        }
        if (minutes > 0L) {
            return minutes + "m";
        }
        return seconds + "s";
    }
}

