/*
 * Decompiled with CFR 0.152.
 */
package wd40.hooked.screen.fishingjournal.pages;

import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Sizing;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import wd40.hooked.Hooked;
import wd40.hooked.data.CatchRecord;
import wd40.hooked.networking.JournalData;
import wd40.hooked.screen.fishingjournal.content.BookPage;
import wd40.hooked.util.FishData;
import wd40.hooked.util.FishDictionary;

@Environment(value=EnvType.CLIENT)
public class PlayerStatsPage
extends BookPage {
    private final JournalData journalData;

    public PlayerStatsPage(JournalData journalData) {
        super("fishing_journal/pages/content/player_stats");
        this.journalData = journalData;
    }

    @Override
    protected void buildContent() {
        FishData fishData;
        FlowLayout fishImageContainer = (FlowLayout)this.contentRoot.childById(FlowLayout.class, "favorite-fish-image");
        LabelComponent totalCatchesLabel = (LabelComponent)this.contentRoot.childById(LabelComponent.class, "total-catches");
        LabelComponent totalTimeLabel = (LabelComponent)this.contentRoot.childById(LabelComponent.class, "total-time");
        LabelComponent mostCommonLabel = (LabelComponent)this.contentRoot.childById(LabelComponent.class, "most-common-fish");
        if (fishImageContainer == null || totalCatchesLabel == null || totalTimeLabel == null || mostCommonLabel == null) {
            Hooked.LOGGER.error("Could not find required components in player_stats content XML");
            return;
        }
        int totalCatches = this.journalData.catchHistory().size();
        long totalMillis = this.journalData.catchHistory().stream().mapToLong(CatchRecord::fishingDuration).sum();
        String totalTimeFormatted = this.formatTime(totalMillis);
        String mostCommonFishId = this.findMostCommonFish();
        String mostCommonFishName = "None";
        if (mostCommonFishId != null && (fishData = FishDictionary.get(mostCommonFishId)) != null) {
            mostCommonFishName = fishData.getId();
        }
        fishImageContainer.clearChildren();
        if (mostCommonFishId != null) {
            class_2960 fishTexture = class_2960.method_60655((String)"hooked", (String)("textures/item/fish/" + mostCommonFishId + ".png"));
            Component fishImage = Components.texture((class_2960)fishTexture, (int)0, (int)0, (int)16, (int)16, (int)16, (int)16).sizing(Sizing.fixed((int)32));
            fishImageContainer.child(fishImage);
        }
        totalCatchesLabel.text((class_2561)class_2561.method_43470((String)("Total Catches: " + totalCatches)));
        totalTimeLabel.text((class_2561)class_2561.method_43470((String)("Total Time: " + totalTimeFormatted)));
        mostCommonLabel.text((class_2561)class_2561.method_43470((String)("Most Caught: " + mostCommonFishName)));
        Hooked.LOGGER.info("PlayerStatsPage built - {} catches, {} time", (Object)totalCatches, (Object)totalTimeFormatted);
    }

    private String findMostCommonFish() {
        if (this.journalData.catchHistory().isEmpty()) {
            return null;
        }
        Map<String, Long> fishCounts = this.journalData.catchHistory().stream().collect(Collectors.groupingBy(CatchRecord::fishId, Collectors.counting()));
        return fishCounts.entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElse(null);
    }

    private String formatTime(long millis) {
        if (millis == 0L) {
            return "0s";
        }
        long seconds = millis / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        if (hours > 0L) {
            return hours + "h " + minutes % 60L + "m";
        }
        if (minutes > 0L) {
            return minutes + "m";
        }
        return seconds + "s";
    }
}

