/*
 * Decompiled with CFR 0.152.
 */
package wd40.hooked.ui;

import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UVMappingRegistry {
    private static final Map<String, UVMapping> MAPPINGS = new HashMap<String, UVMapping>();

    public static void register(String key, int u, int v, int width, int height) {
        MAPPINGS.put(key, new UVMapping(u, v, width, height));
    }

    public static UVMapping get(String key) {
        UVMapping mapping = MAPPINGS.get(key);
        if (mapping == null) {
            throw new IllegalArgumentException("UV mapping not found for key: " + key + ". Available keys: " + String.valueOf(MAPPINGS.keySet()));
        }
        return mapping;
    }

    public static boolean has(String key) {
        return MAPPINGS.containsKey(key);
    }

    static {
        UVMappingRegistry.register("flag-red", 0, 0, 48, 20);
        UVMappingRegistry.register("flag-blue", 0, 21, 48, 20);
        UVMappingRegistry.register("flag-green", 0, 42, 48, 20);
        UVMappingRegistry.register("arrow-left-white", 49, 0, 11, 10);
        UVMappingRegistry.register("arrow-right-white", 61, 0, 11, 10);
        UVMappingRegistry.register("arrow-left-orange", 49, 11, 11, 10);
        UVMappingRegistry.register("arrow-right-orange", 61, 11, 11, 10);
    }

    @Environment(value=EnvType.CLIENT)
    public record UVMapping(int u, int v, int width, int height) {
    }
}

