/*
 * Decompiled with CFR 0.152.
 */
package wd40.hooked.ui.component;

import io.wispforest.owo.ui.base.BaseComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.TextureComponent;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Size;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.parsing.UIParsing;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import wd40.hooked.ui.UVMappingRegistry;

@Environment(value=EnvType.CLIENT)
public class DynamicTextureComponent
extends BaseComponent {
    private final class_2960 texture;
    private final int textureWidth;
    private final int textureHeight;
    private String uvKey;
    private TextureComponent internalTexture;

    protected DynamicTextureComponent(class_2960 texture, String uvKey, int textureWidth, int textureHeight) {
        this.texture = texture;
        this.uvKey = uvKey;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.updateInternalTexture();
    }

    public DynamicTextureComponent setUvKey(String uvKey) {
        if (!this.uvKey.equals(uvKey)) {
            this.uvKey = uvKey;
            this.updateInternalTexture();
        }
        return this;
    }

    public String getUvKey() {
        return this.uvKey;
    }

    private void updateInternalTexture() {
        UVMappingRegistry.UVMapping uv = UVMappingRegistry.get(this.uvKey);
        this.internalTexture = Components.texture((class_2960)this.texture, (int)uv.u(), (int)uv.v(), (int)uv.width(), (int)uv.height(), (int)this.textureWidth, (int)this.textureHeight);
        if (this.width > 0 && this.height > 0) {
            this.internalTexture.inflate(Size.of((int)this.width, (int)this.height));
        }
        if (this.x != 0 || this.y != 0) {
            this.internalTexture.updateX(this.x);
            this.internalTexture.updateY(this.y);
        }
    }

    protected int determineHorizontalContentSize(Sizing sizing) {
        return this.internalTexture.width();
    }

    protected int determineVerticalContentSize(Sizing sizing) {
        return this.internalTexture.height();
    }

    public void inflate(Size space) {
        super.inflate(space);
        if (this.internalTexture != null) {
            this.internalTexture.inflate(space);
        }
    }

    public void updateX(int x) {
        super.updateX(x);
        if (this.internalTexture != null) {
            this.internalTexture.updateX(x);
        }
    }

    public void updateY(int y) {
        super.updateY(y);
        if (this.internalTexture != null) {
            this.internalTexture.updateY(y);
        }
    }

    public void update(float delta, int mouseX, int mouseY) {
        super.update(delta, mouseX, mouseY);
        if (this.internalTexture != null) {
            this.internalTexture.update(delta, mouseX, mouseY);
        }
    }

    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        if (this.internalTexture != null) {
            this.internalTexture.draw(context, mouseX, mouseY, partialTicks, delta);
        }
    }

    public static DynamicTextureComponent parse(Element element) {
        UIParsing.expectAttributes((Element)element, (String[])new String[]{"texture", "uv-key"});
        class_2960 texture = UIParsing.parseIdentifier((Node)element.getAttributeNode("texture"));
        String uvKey = element.getAttribute("uv-key");
        int textureWidth = 256;
        int textureHeight = 256;
        if (element.hasAttribute("texture-width")) {
            textureWidth = UIParsing.parseSignedInt((Node)element.getAttributeNode("texture-width"));
        }
        if (element.hasAttribute("texture-height")) {
            textureHeight = UIParsing.parseSignedInt((Node)element.getAttributeNode("texture-height"));
        }
        return new DynamicTextureComponent(texture, uvKey, textureWidth, textureHeight);
    }
}

