/*
 * Decompiled with CFR 0.152.
 */
package wd40.hooked.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class FishData {
    private final String id;
    private final float averageSize;
    private final int hunger;
    private final float saturation;
    private final List<SpawnCondition> spawnConditions;

    public FishData(String id, float averageSize, int hunger, float saturation, List<SpawnCondition> spawnConditions) {
        this.id = id;
        this.averageSize = averageSize;
        this.hunger = hunger;
        this.saturation = saturation;
        this.spawnConditions = spawnConditions;
    }

    public String getId() {
        return this.id;
    }

    public float getAverageSize() {
        return this.averageSize;
    }

    public int getHunger() {
        return this.hunger;
    }

    public float getSaturation() {
        return this.saturation;
    }

    public List<SpawnCondition> getSpawnConditions() {
        return this.spawnConditions;
    }

    public String getTranslationKey() {
        return "item.hooked." + this.id;
    }

    public static FishData fromMap(Map<String, Object> map) {
        String id = (String)map.get("id");
        Object avgSizeObj = map.get("averageSize");
        float averageSize = avgSizeObj instanceof Number ? ((Number)avgSizeObj).floatValue() : 0.0f;
        Object hungerObj = map.get("hunger");
        int hunger = hungerObj instanceof Number ? ((Number)hungerObj).intValue() : 0;
        Object saturationObj = map.get("saturation");
        float saturation = saturationObj instanceof Number ? ((Number)saturationObj).floatValue() : 0.0f;
        ArrayList<SpawnCondition> spawnConditions = new ArrayList<SpawnCondition>();
        Object spawnConditionsObj = map.get("spawnConditions");
        if (spawnConditionsObj instanceof List) {
            List conditionsList = (List)spawnConditionsObj;
            for (Map conditionMap : conditionsList) {
                List biomes = (List)conditionMap.get("biomes");
                List weather = (List)conditionMap.get("weather");
                Object dayWeightObj = conditionMap.get("dayWeight");
                float dayWeight = dayWeightObj instanceof Number ? ((Number)dayWeightObj).floatValue() : 0.0f;
                Object nightWeightObj = conditionMap.get("nightWeight");
                float nightWeight = nightWeightObj instanceof Number ? ((Number)nightWeightObj).floatValue() : 0.0f;
                Object minYObj = conditionMap.get("minY");
                Integer minY = minYObj instanceof Number ? Integer.valueOf(((Number)minYObj).intValue()) : null;
                Object maxYObj = conditionMap.get("maxY");
                Integer maxY = maxYObj instanceof Number ? Integer.valueOf(((Number)maxYObj).intValue()) : null;
                spawnConditions.add(new SpawnCondition(biomes, weather, dayWeight, nightWeight, minY, maxY));
            }
        }
        return new FishData(id, averageSize, hunger, saturation, spawnConditions);
    }

    public static class SpawnCondition {
        private final List<String> biomes;
        private final List<String> weather;
        private final float dayWeight;
        private final float nightWeight;
        private final Integer minY;
        private final Integer maxY;

        public SpawnCondition(List<String> biomes, List<String> weather, float dayWeight, float nightWeight) {
            this(biomes, weather, dayWeight, nightWeight, null, null);
        }

        public SpawnCondition(List<String> biomes, List<String> weather, float dayWeight, float nightWeight, Integer minY, Integer maxY) {
            this.biomes = biomes;
            this.weather = weather;
            this.dayWeight = dayWeight;
            this.nightWeight = nightWeight;
            this.minY = minY;
            this.maxY = maxY;
        }

        public List<String> getBiomes() {
            return this.biomes;
        }

        public List<String> getWeather() {
            return this.weather;
        }

        public float getDayWeight() {
            return this.dayWeight;
        }

        public float getNightWeight() {
            return this.nightWeight;
        }

        public Integer getMinY() {
            return this.minY;
        }

        public Integer getMaxY() {
            return this.maxY;
        }

        public float getWeight(long time) {
            return time % 24000L < 12000L ? this.dayWeight : this.nightWeight;
        }

        public boolean matches(String biome, long time, String weather) {
            return this.matches(biome, time, weather, null);
        }

        public boolean matches(String biome, long time, String weather, Integer yLevel) {
            boolean biomeMatch = this.biomes == null || this.biomes.isEmpty() || this.biomes.contains(biome);
            boolean weatherMatch = this.weather == null || this.weather.isEmpty() || this.weather.contains(weather);
            boolean yLevelMatch = !(this.minY != null && yLevel != null && yLevel < this.minY || this.maxY != null && yLevel != null && yLevel > this.maxY);
            boolean hasWeight = this.getWeight(time) > 0.0f;
            return biomeMatch && weatherMatch && yLevelMatch && hasWeight;
        }

        public boolean matches(class_6880<class_1959> biomeEntry, long time, String weather) {
            return this.matches(biomeEntry, time, weather, null);
        }

        public boolean matches(class_6880<class_1959> biomeEntry, long time, String weather, Integer yLevel) {
            boolean biomeMatch;
            boolean bl = biomeMatch = this.biomes == null || this.biomes.isEmpty();
            if (!biomeMatch && this.biomes != null) {
                for (String biomeStr : this.biomes) {
                    if (biomeStr.startsWith("#")) {
                        class_6862 tagKey;
                        String tagId = biomeStr.substring(1);
                        class_2960 tagIdentifier = class_2960.method_12829((String)tagId);
                        if (tagIdentifier == null || !biomeEntry.method_40220(tagKey = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)tagIdentifier))) continue;
                        biomeMatch = true;
                        break;
                    }
                    String biomeName = ((class_5321)biomeEntry.method_40230().get()).method_29177().toString();
                    if (!biomeStr.equals(biomeName)) continue;
                    biomeMatch = true;
                    break;
                }
            }
            boolean weatherMatch = this.weather == null || this.weather.isEmpty() || this.weather.contains(weather);
            boolean yLevelMatch = !(this.minY != null && yLevel != null && yLevel < this.minY || this.maxY != null && yLevel != null && yLevel > this.maxY);
            boolean hasWeight = this.getWeight(time) > 0.0f;
            return biomeMatch && weatherMatch && yLevelMatch && hasWeight;
        }
    }
}

