/*
 * Decompiled with CFR 0.152.
 */
package wd40.hooked.util;

import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.yaml.snakeyaml.Yaml;
import wd40.hooked.Hooked;
import wd40.hooked.util.FishData;

public class FishDictionary {
    private static final Map<String, FishData> FISH_REGISTRY = new HashMap<String, FishData>();
    private static final Yaml YAML = new Yaml();
    private static boolean initialized = false;

    public static void initialize() {
        if (!initialized) {
            FishDictionary.loadFishDataFromResources();
            initialized = true;
        }
    }

    private static void loadFishDataFromResources() {
        FISH_REGISTRY.clear();
        try {
            Path fishPath;
            URI uri = FishDictionary.class.getResource("/data/hooked/fish").toURI();
            if (uri.getScheme().equals("jar")) {
                FileSystem fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
                fishPath = fileSystem.getPath("/data/hooked/fish", new String[0]);
            } else {
                fishPath = Paths.get(uri);
            }
            try (Stream<Path> paths = Files.walk(fishPath, 1, new FileVisitOption[0]);){
                paths.filter(path -> path.toString().endsWith(".yaml")).forEach(path -> {
                    String fileName = path.getFileName().toString();
                    String resourcePath = "/data/hooked/fish/" + fileName;
                    try (InputStream stream = FishDictionary.class.getResourceAsStream(resourcePath);){
                        if (stream == null) {
                            Hooked.LOGGER.error("Could not find resource: {}", (Object)resourcePath);
                            return;
                        }
                        Map fishDataMap = (Map)YAML.load(stream);
                        FishData fishData = FishData.fromMap(fishDataMap);
                        FISH_REGISTRY.put(fishData.getId(), fishData);
                        Hooked.LOGGER.info("Loaded fish: {}", (Object)fishData.getId());
                    }
                    catch (Exception e) {
                        Hooked.LOGGER.error("Failed to load fish data from {}", (Object)resourcePath, (Object)e);
                    }
                });
            }
            Hooked.LOGGER.info("Loaded {} fish species", (Object)FISH_REGISTRY.size());
        }
        catch (Exception e) {
            Hooked.LOGGER.error("Failed to load fish data", (Throwable)e);
        }
    }

    public static FishData get(String id) {
        return FISH_REGISTRY.get(id);
    }

    public static boolean exists(String id) {
        return FISH_REGISTRY.containsKey(id);
    }

    public static Map<String, FishData> getAll() {
        return new HashMap<String, FishData>(FISH_REGISTRY);
    }

    static {
        FishDictionary.loadFishDataFromResources();
    }
}

