/*
 * Decompiled with CFR 0.152.
 */
package wd40.hooked.util;

import io.wispforest.endec.Endec;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public enum FishRarity {
    AVERAGE(1.0f, 10, class_124.field_1080),
    SMALL(0.8f, 30, class_124.field_1060),
    LARGE(1.2f, 30, class_124.field_1064),
    MINI(0.6f, 100, class_124.field_1078),
    HUGE(1.4f, 100, class_124.field_1076),
    TINY(0.3f, 300, class_124.field_1068),
    MASSIVE(1.7f, 300, class_124.field_1065),
    LEGENDARY(2.1f, 1000, class_124.field_1054),
    MYTHICAL(2.6f, 3000, class_124.field_1061),
    MICRO(0.15f, 10000, class_124.field_1080),
    COLOSSAL(3.2f, 10000, class_124.field_1079),
    NANO(0.1f, 30000, class_124.field_1063),
    LEVIATHAN(4.0f, 30000, class_124.field_1062),
    ATOMIC(0.05f, 100000, class_124.field_1074),
    PRIMORDIAL(5.0f, 100000, class_124.field_1075),
    SUBATOMIC(0.02f, 300000, class_124.field_1063),
    ELDER_GOD(6.0f, 300000, class_124.field_1076);

    private final float sizeMultiplier;
    private final int oneInX;
    private final class_124 color;
    public static final Endec<FishRarity> ENDEC;
    private static final String RARITY_KEY = "rarity";

    private FishRarity(float sizeMultiplier, int oneInX, class_124 color) {
        this.sizeMultiplier = sizeMultiplier;
        this.oneInX = oneInX;
        this.color = color;
    }

    public float getSizeMultiplier() {
        return this.sizeMultiplier;
    }

    public int getOneInX() {
        return this.oneInX;
    }

    public float getWeight() {
        return 1.0f / (float)this.oneInX;
    }

    public class_124 getColor() {
        return this.color;
    }

    public String getTranslationKey() {
        return "rarity.hooked." + this.name().toLowerCase();
    }

    public String getRarityDescription() {
        return "1 in " + String.format("%,d", this.oneInX);
    }

    public String getArticle() {
        char firstChar = this.name().charAt(0);
        return firstChar == 'A' || firstChar == 'E' || firstChar == 'I' || firstChar == 'O' || firstChar == 'U' ? "an" : "a";
    }

    public static FishRarity getRarity(class_1799 stack) {
        class_2487 nbt = ((class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
        if (!nbt.method_10545(RARITY_KEY)) {
            return AVERAGE;
        }
        try {
            return nbt.method_10558(RARITY_KEY).map(FishRarity::valueOf).orElse(AVERAGE);
        }
        catch (IllegalArgumentException e) {
            return AVERAGE;
        }
    }

    public static void setRarity(class_1799 stack, FishRarity rarity) {
        class_2487 nbt = ((class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
        nbt.method_10582(RARITY_KEY, rarity.name());
        stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)nbt));
    }

    static {
        ENDEC = Endec.STRING.xmap(FishRarity::valueOf, Enum::name);
    }
}

