/*
 * Decompiled with CFR 0.152.
 */
package wd40.hooked.util;

import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import wd40.hooked.Hooked;
import wd40.hooked.component.ModComponents;
import wd40.hooked.data.CatchRecord;
import wd40.hooked.data.FishStateSaverAndLoader;
import wd40.hooked.data.PlayerFishData;
import wd40.hooked.item.ModItems;
import wd40.hooked.util.FishData;
import wd40.hooked.util.FishDictionary;
import wd40.hooked.util.FishQuirk;
import wd40.hooked.util.FishRarity;

public class FishingLootHelper {
    public static void dropLoot(class_1657 player, class_3218 world, double x, double y, double z, class_2338 pos, long fishingDuration) {
        class_6880 biomeEntry = world.method_23753(pos);
        String biome = ((class_5321)biomeEntry.method_40230().get()).method_29177().toString();
        long time = world.method_8532() % 24000L;
        String weather = world.method_8419() ? (world.method_8546() ? "thunder" : "rain") : "clear";
        FishData selectedFish = FishingLootHelper.selectFish(world, (class_6880<class_1959>)biomeEntry, time, weather, pos);
        if (selectedFish == null) {
            Hooked.LOGGER.warn("No fish found for conditions: biome={}, time={}, weather={}", new Object[]{biome, time, weather});
            return;
        }
        FishRarity rarity = FishingLootHelper.selectRandomRarity(world, player);
        class_1792 fishItem = ModItems.getFishItem(selectedFish.getId());
        if (fishItem == null) {
            Hooked.LOGGER.error("Fish item not found for: {}", (Object)selectedFish.getId());
            return;
        }
        class_1799 loot = new class_1799((class_1935)fishItem);
        FishRarity.setRarity(loot, rarity);
        loot.method_57379(ModComponents.CAUGHT_BY, (Object)player.method_5477().getString());
        if (world.method_8409().method_43048(1000000) == 0) {
            FishQuirk[] quirks = FishQuirk.values();
            FishQuirk randomQuirk = quirks[world.method_8409().method_43048(quirks.length)];
            loot.method_57379(ModComponents.QUIRK, (Object)randomQuirk.name());
        }
        player.method_7353((class_2561)class_2561.method_43470((String)("You caught " + rarity.getArticle() + " ")).method_10852((class_2561)class_2561.method_43471((String)rarity.getTranslationKey()).method_27692(rarity.getColor())).method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)selectedFish.getTranslationKey())).method_27693("!"), true);
        int xpAmount = rarity.ordinal() * rarity.ordinal();
        player.method_7255(xpAmount);
        if (rarity.ordinal() >= FishRarity.MYTHICAL.ordinal()) {
            world.method_8396(null, player.method_24515(), class_3417.field_15195, class_3419.field_15248, 1.0f, 1.0f);
            class_5250 broadcastMessage = class_2561.method_43470((String)player.method_5477().getString()).method_27693(" caught " + rarity.getArticle() + " ").method_10852((class_2561)class_2561.method_43471((String)rarity.getTranslationKey()).method_27692(rarity.getColor())).method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)selectedFish.getTranslationKey())).method_27693("!");
            world.method_8503().method_3760().method_43514((class_2561)broadcastMessage, false);
        }
        FishingLootHelper.recordCatch(player, world, selectedFish.getId(), rarity, pos, fishingDuration);
        class_1542 itemEntity = new class_1542((class_1937)world, x, y, z, loot);
        double velocityX = player.method_23317() - x;
        double velocityY = player.method_23318() - y;
        double velocityZ = player.method_23321() - z;
        double distance = Math.sqrt(velocityX * velocityX + velocityY * velocityY + velocityZ * velocityZ);
        double speed = 0.1;
        itemEntity.method_18800(velocityX * speed, velocityY * speed + Math.sqrt(distance) * 0.08, velocityZ * speed);
        world.method_8649((class_1297)itemEntity);
        player.method_73183().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15093, class_3419.field_15254, 1.0f, 0.4f / (world.method_8409().method_43057() * 0.4f + 0.8f));
    }

    public static void recordCatch(class_1657 player, class_3218 world, String fishId, FishRarity rarity, class_2338 pos, long fishingDuration) {
        String biome = ((class_5321)world.method_23753(pos).method_40230().get()).method_29177().toString();
        String weather = world.method_8419() ? (world.method_8546() ? "thunder" : "rain") : "clear";
        int moonPhase = world.method_30273();
        int lightLevel = world.method_22339(pos);
        int waterDepth = FishingLootHelper.calculateWaterDepth(world, pos);
        int skyLight = world.method_8314(class_1944.field_9284, pos);
        CatchRecord record = new CatchRecord(fishId, rarity, System.currentTimeMillis(), world.method_8532(), biome, fishingDuration, pos.method_10263(), pos.method_10264(), pos.method_10260(), weather, moonPhase, lightLevel, waterDepth, skyLight);
        Hooked.LOGGER.info("=== CATCH RECORDED ===");
        Hooked.LOGGER.info("Player: {}", (Object)player.method_5477().getString());
        Hooked.LOGGER.info("Fish ID: {}", (Object)fishId);
        Hooked.LOGGER.info("Rarity: {}", (Object)rarity);
        long gameTime = world.method_8532();
        long dayNumber = gameTime / 24000L;
        long timeOfDay = gameTime % 24000L;
        String dayOrNight = timeOfDay >= 12600L && timeOfDay <= 23400L ? "Night" : "Day";
        Hooked.LOGGER.info("IRL Time: {}", (Object)System.currentTimeMillis());
        Hooked.LOGGER.info("Game Time: {} ticks | Day {} | Time: {} ({}) ", new Object[]{gameTime, dayNumber, timeOfDay, dayOrNight});
        Hooked.LOGGER.info("Biome: {}", (Object)biome);
        Hooked.LOGGER.info("Fishing Duration: {}ms", (Object)fishingDuration);
        Hooked.LOGGER.info("Position: ({}, {}, {})", new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260()});
        Hooked.LOGGER.info("Weather: {}", (Object)weather);
        Hooked.LOGGER.info("Moon Phase: {}", (Object)moonPhase);
        Hooked.LOGGER.info("Light Level: {}", (Object)lightLevel);
        Hooked.LOGGER.info("Water Depth: {}", (Object)waterDepth);
        Hooked.LOGGER.info("Sky Light: {}", (Object)skyLight);
        Hooked.LOGGER.info("======================");
        FishStateSaverAndLoader stateSaver = FishStateSaverAndLoader.getServerState(world.method_8503());
        stateSaver.addCatchRecord(player.method_5667(), record);
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            PlayerFishData playerData = stateSaver.getPlayerData(player.method_5667());
            if (playerData != null) {
                int uniqueTypes = playerData.fishCounts.size();
                int totalCatches = playerData.getTotalCatches();
                Hooked.UNIQUE_FISH_TYPES_CRITERION.trigger(serverPlayer, uniqueTypes);
                Hooked.TOTAL_FISH_CAUGHT_CRITERION.trigger(serverPlayer, totalCatches);
                Hooked.FISH_RARITY_CRITERION.trigger(serverPlayer, rarity);
            }
        }
    }

    private static int calculateWaterDepth(class_3218 world, class_2338 pos) {
        int depth;
        class_2338.class_2339 mutablePos = pos.method_25503();
        for (depth = 0; world.method_8320((class_2338)mutablePos).method_26227().method_15771() && depth < 256; ++depth) {
            mutablePos.method_10098(class_2350.field_11033);
        }
        return depth;
    }

    private static FishRarity selectRandomRarity(class_3218 world, class_1657 player) {
        boolean hasBait = player.method_6079().method_7909() == ModItems.FISHING_BAIT || player.method_6047().method_7909() == ModItems.FISHING_BAIT;
        boolean hasMasterBait = player.method_6079().method_7909() == ModItems.MASTER_BAIT || player.method_6047().method_7909() == ModItems.MASTER_BAIT;
        FishRarity[] rarities = FishRarity.values();
        for (int i = rarities.length - 1; i >= 0; --i) {
            FishRarity rarity = rarities[i];
            int oneInX = rarity.getOneInX();
            if (world.method_8409().method_43048(oneInX) != 0) continue;
            return rarity;
        }
        return FishRarity.AVERAGE;
    }

    public static boolean canCatchFishInBiome(class_3218 world, class_2338 pos) {
        class_6880 biomeEntry = world.method_23753(pos);
        long time = world.method_8532() % 24000L;
        String weather = world.method_8419() ? (world.method_8546() ? "thunder" : "rain") : "clear";
        int yLevel = pos.method_10264();
        for (FishData fish : FishDictionary.getAll().values()) {
            for (FishData.SpawnCondition condition : fish.getSpawnConditions()) {
                if (!condition.matches((class_6880<class_1959>)biomeEntry, time, weather, (Integer)yLevel)) continue;
                return true;
            }
        }
        return false;
    }

    private static FishData selectFish(class_3218 world, class_6880<class_1959> biomeEntry, long time, String weather, class_2338 pos) {
        ArrayList<FishData> validFish = new ArrayList<FishData>();
        ArrayList<Float> weights = new ArrayList<Float>();
        int yLevel = pos.method_10264();
        block0: for (FishData fishData : FishDictionary.getAll().values()) {
            for (FishData.SpawnCondition condition : fishData.getSpawnConditions()) {
                if (!condition.matches(biomeEntry, time, weather, (Integer)yLevel)) continue;
                validFish.add(fishData);
                weights.add(Float.valueOf(condition.getWeight(time)));
                continue block0;
            }
        }
        if (validFish.isEmpty()) {
            return null;
        }
        float totalWeight = 0.0f;
        Iterator iterator = weights.iterator();
        while (iterator.hasNext()) {
            float weight = ((Float)iterator.next()).floatValue();
            totalWeight += weight;
        }
        float f = world.method_8409().method_43057() * totalWeight;
        float cumulativeWeight = 0.0f;
        for (int i = 0; i < validFish.size(); ++i) {
            if (!(f <= (cumulativeWeight += ((Float)weights.get(i)).floatValue()))) continue;
            return (FishData)validFish.get(i);
        }
        return (FishData)validFish.get(validFish.size() - 1);
    }
}

