from PIL import Image
import os
import glob

# Get the directory where this script is located
script_dir = os.path.dirname(os.path.abspath(__file__))
os.chdir(script_dir)

# Create the black folder if it doesn't exist
os.makedirs('black', exist_ok=True)

# Get all PNG images from the current folder (excluding the black folder)
fish_files = [os.path.basename(f) for f in glob.glob('*.png')]

# Process each fish image
for filename in fish_files:
    # Open the image and convert to RGBA
    img = Image.open(filename).convert('RGBA')

    # Get the image data
    data = list(img.getdata())

    # Create new data with black pixels but preserve alpha channel
    new_data = []
    for pixel in data:
        if len(pixel) == 4:
            # Keep alpha channel, make RGB black
            new_data.append((0, 0, 0, pixel[3]))
        else:
            # Fully opaque black
            new_data.append((0, 0, 0, 255))

    # Put the new data back
    img.putdata(new_data)

    # Save to black folder
    img.save(f'black/{filename}')
    print(f'Created black/{filename}')

print('Done! Created black versions of all fish images.')
