/*
 * Decompiled with CFR 0.152.
 */
package Snattuw.antiblindness.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_124;
import net.minecraft.class_1294;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;

@Environment(value=EnvType.CLIENT)
public class AntiblindnessClient
implements ClientModInitializer {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = Path.of("config/antiblindness_config.json", new String[0]);
    private static boolean isEnabled = true;
    private static final class_304 toggleKey = new class_304("Toggle blindness", 66, class_304.class_11900.method_74698((class_2960)class_2960.method_60654((String)"AntiBlindness")));

    public static boolean isEnabled() {
        return isEnabled;
    }

    public static boolean enable(boolean ena) {
        isEnabled = ena;
        return AntiblindnessClient.isEnabled();
    }

    private static void saveConfig() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            Config config = new Config();
            config.isEnabled = isEnabled;
            Files.writeString(CONFIG_PATH, (CharSequence)GSON.toJson((Object)config), new OpenOption[0]);
        }
        catch (IOException e) {
            System.err.println("Failed to save AntiBlindness config: " + e.getMessage());
        }
    }

    private static void loadConfig() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                String content = Files.readString(CONFIG_PATH);
                Config config = (Config)GSON.fromJson(content, Config.class);
                isEnabled = config.isEnabled;
            }
            catch (IOException e) {
                System.err.println("Failed to load AntiBlindness config: " + e.getMessage());
            }
        }
    }

    public void onInitializeClient() {
        AntiblindnessClient.loadConfig();
        KeyBindingHelper.registerKeyBinding((class_304)toggleKey);
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1724 == null) {
                return;
            }
            while (toggleKey.method_1436()) {
                isEnabled = !isEnabled;
                AntiblindnessClient.saveConfig();
                client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"Anti Blindness & Darkness: ").method_10852((class_2561)class_2561.method_43470((String)(isEnabled ? "ENABLED" : "DISABLED")).method_27694(style -> style.method_10977(isEnabled ? class_124.field_1060 : class_124.field_1061))), true);
            }
            if (isEnabled) {
                if (client.field_1724.method_6059(class_1294.field_5919)) {
                    client.field_1724.method_6016(class_1294.field_5919);
                }
                if (client.field_1724.method_6059(class_1294.field_38092)) {
                    client.field_1724.method_6016(class_1294.field_38092);
                }
            }
        });
    }

    @Environment(value=EnvType.CLIENT)
    static class Config {
        public boolean isEnabled = true;

        Config() {
        }
    }
}

