/*
 * Decompiled with CFR 0.152.
 */
package net.jakeccz.hrp.action;

import io.papermc.paper.entity.LookAnchor;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.jakeccz.hrp.util.HardcoreRevivePluginConfig;
import net.kyori.adventure.text.Component;
import org.bukkit.EntityEffect;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ReviveManager {
    public static void tryRevivePlayer(World world, Location pos, Player deadPlayer, Player alivePlayer) {
        Map<Location, Set<Material>> result = ReviveManager.searchAround(world, pos, ReviveManager.getRitualPattern(world));
        if (result != null) {
            if (deadPlayer != null && deadPlayer.getGameMode() == GameMode.SPECTATOR) {
                if (deadPlayer.isOnline()) {
                    world.strikeLightning(new Location(world, (double)((float)pos.getBlockX() + 0.5f), (double)(pos.getBlockY() - 1), (double)((float)pos.getBlockZ() - 0.5f)));
                    ReviveManager.spawnPlayer(world, pos, result, deadPlayer, alivePlayer);
                } else {
                    ReviveManager.spawnError("It appears that this player is absent to this world", world, pos, alivePlayer);
                }
            } else if (deadPlayer != null && deadPlayer == alivePlayer) {
                ReviveManager.spawnError("Oh! That's you!", world, pos, alivePlayer);
            } else if (deadPlayer != null && deadPlayer.getGameMode() != GameMode.SPECTATOR) {
                ReviveManager.spawnError("It appears that this player is still alive", world, pos, alivePlayer);
            } else {
                ReviveManager.spawnError("It appears that this player is absent to this world", world, pos, alivePlayer);
            }
        } else {
            Map<Location, Set<Material>> incompleteResult = ReviveManager.searchAround(world, pos, ReviveManager.getFailedRitualPattern(world));
            if (incompleteResult != null) {
                ReviveManager.spawnError("Something is missing...", world, pos, alivePlayer);
            }
        }
    }

    private static void spawnPlayer(World world, Location pos, Map<Location, Set<Material>> patternResult, Player deadPlayer, Player alivePlayer) {
        ReviveManager.breakRitualPatternBlocks(world, pos, patternResult);
        deadPlayer.teleport(new Location(world, (double)pos.getBlockX() + 0.5, (double)pos.getBlockY() - 0.95, (double)pos.getBlockZ() + 0.5));
        deadPlayer.lookAt((Entity)alivePlayer, LookAnchor.FEET, LookAnchor.FEET);
        deadPlayer.setGameMode(GameMode.SURVIVAL);
        int durationTicks = 100;
        deadPlayer.clearActivePotionEffects();
        deadPlayer.addPotionEffect(new PotionEffect(PotionEffectType.RESISTANCE, durationTicks, 70, false, false));
        deadPlayer.addPotionEffect(new PotionEffect(PotionEffectType.GLOWING, durationTicks, 1));
        deadPlayer.sendEntityEffect(EntityEffect.TOTEM_RESURRECT, (Entity)deadPlayer);
    }

    private static void spawnError(String errorMessage, World world, Location pos, Player alivePlayer) {
        alivePlayer.sendActionBar((Component)Component.text((String)errorMessage));
        world.playSound(pos, Sound.BLOCK_FIRE_EXTINGUISH, SoundCategory.BLOCKS, 0.4f, 20.0f);
        world.spawnParticle(Particle.SMOKE, new Location(world, (double)pos.getBlockX() + 0.5, (double)pos.getBlockY() + 0.5, (double)pos.getBlockZ() + 0.5), 1);
    }

    private static Map<Location, Set<Material>> searchAround(World world, Location pos, Map<Location, Set<Material>> blockOffsetMap) {
        for (Map.Entry<Location, Set<Material>> offset : blockOffsetMap.entrySet()) {
            Location offsetKey = offset.getKey();
            Location offsetPos = new Location(world, (double)(pos.getBlockX() + offsetKey.getBlockX()), (double)(pos.getBlockY() + offsetKey.getBlockY()), (double)(pos.getBlockZ() + offsetKey.getBlockZ()));
            Stream blockTag = offset.getValue().stream();
            if (offsetPos.getY() <= (double)world.getMinHeight()) {
                return null;
            }
            Block block = world.getBlockAt(offsetPos.toBlockLocation());
            if (!blockTag.noneMatch(blockType -> blockType == block.getType())) continue;
            return null;
        }
        return blockOffsetMap;
    }

    private static void breakRitualPatternBlocks(World world, Location pos, Map<Location, Set<Material>> patternResult) {
        int deadzoneY = HardcoreRevivePluginConfig.ConfigRule.getOrDefault("keep-structure-base", false) != false ? 1 : 0;
        for (Map.Entry<Location, Set<Material>> offset : patternResult.entrySet()) {
            Location offsetKey = offset.getKey();
            Location offsetPos = new Location(world, (double)(pos.getBlockX() + offsetKey.getBlockX()), (double)(pos.getBlockY() + offsetKey.getBlockY() + deadzoneY), (double)(pos.getBlockZ() + offsetKey.getBlockZ()));
            if (!(offsetPos.getY() > (double)world.getMinHeight()) || offsetPos.getBlockY() > pos.getBlockY()) continue;
            Block block = world.getBlockAt(offsetPos);
            block.setType(Material.AIR);
        }
        world.playSound(pos, Sound.BLOCK_STONE_BREAK, 0.4f, 1.0f);
    }

    private static Map<Location, Set<Material>> getRitualPattern(World world) {
        HashMap<Location, Set<Material>> patternMap = new HashMap<Location, Set<Material>>();
        patternMap.put(new Location(world, 0.0, 0.0, 0.0), Set.of(Material.PLAYER_HEAD));
        patternMap.put(new Location(world, 0.0, -1.0, 0.0), HardcoreRevivePluginConfig.BlockTag.getOrDefault("fence-blocktag", Set.of()));
        patternMap.put(new Location(world, -1.0, -1.0, -1.0), HardcoreRevivePluginConfig.BlockTag.getOrDefault("flower-blocktag", Set.of()));
        patternMap.put(new Location(world, -1.0, -1.0, 1.0), HardcoreRevivePluginConfig.BlockTag.getOrDefault("flower-blocktag", Set.of()));
        patternMap.put(new Location(world, 1.0, -1.0, -1.0), HardcoreRevivePluginConfig.BlockTag.getOrDefault("flower-blocktag", Set.of()));
        patternMap.put(new Location(world, 1.0, -1.0, 1.0), HardcoreRevivePluginConfig.BlockTag.getOrDefault("flower-blocktag", Set.of()));
        patternMap.put(new Location(world, 0.0, -2.0, 0.0), HardcoreRevivePluginConfig.BlockTag.getOrDefault("ore-blocktag", Set.of()));
        patternMap.put(new Location(world, 0.0, -2.0, 1.0), HardcoreRevivePluginConfig.BlockTag.getOrDefault("stair-blocktag", Set.of()));
        patternMap.put(new Location(world, 0.0, -2.0, -1.0), HardcoreRevivePluginConfig.BlockTag.getOrDefault("stair-blocktag", Set.of()));
        patternMap.put(new Location(world, 1.0, -2.0, 0.0), HardcoreRevivePluginConfig.BlockTag.getOrDefault("stair-blocktag", Set.of()));
        patternMap.put(new Location(world, -1.0, -2.0, 0.0), HardcoreRevivePluginConfig.BlockTag.getOrDefault("stair-blocktag", Set.of()));
        patternMap.put(new Location(world, -1.0, -2.0, -1.0), HardcoreRevivePluginConfig.BlockTag.getOrDefault("soul-sand-blocktag", Set.of()));
        patternMap.put(new Location(world, -1.0, -2.0, 1.0), HardcoreRevivePluginConfig.BlockTag.getOrDefault("soul-sand-blocktag", Set.of()));
        patternMap.put(new Location(world, 1.0, -2.0, -1.0), HardcoreRevivePluginConfig.BlockTag.getOrDefault("soul-sand-blocktag", Set.of()));
        patternMap.put(new Location(world, 1.0, -2.0, 1.0), HardcoreRevivePluginConfig.BlockTag.getOrDefault("soul-sand-blocktag", Set.of()));
        return patternMap;
    }

    private static Map<Location, Set<Material>> getFailedRitualPattern(World world) {
        HashMap<Location, Set<Material>> patternMap = new HashMap<Location, Set<Material>>();
        patternMap.put(new Location(world, 0.0, 0.0, 0.0), Set.of(Material.PLAYER_HEAD));
        patternMap.put(new Location(world, 0.0, -1.0, 0.0), HardcoreRevivePluginConfig.BlockTag.get("fence-blocktag"));
        patternMap.put(new Location(world, 0.0, -2.0, 0.0), HardcoreRevivePluginConfig.BlockTag.getOrDefault("ore-blocktag", Set.of()));
        patternMap.put(new Location(world, 0.0, -2.0, 1.0), HardcoreRevivePluginConfig.BlockTag.getOrDefault("stair-blocktag", Set.of()));
        patternMap.put(new Location(world, 0.0, -2.0, -1.0), HardcoreRevivePluginConfig.BlockTag.getOrDefault("stair-blocktag", Set.of()));
        patternMap.put(new Location(world, 1.0, -2.0, 0.0), HardcoreRevivePluginConfig.BlockTag.getOrDefault("stair-blocktag", Set.of()));
        patternMap.put(new Location(world, -1.0, -2.0, 0.0), HardcoreRevivePluginConfig.BlockTag.getOrDefault("stair-blocktag", Set.of()));
        patternMap.put(new Location(world, -1.0, -2.0, -1.0), HardcoreRevivePluginConfig.BlockTag.getOrDefault("soul-sand-blocktag", Set.of()));
        patternMap.put(new Location(world, -1.0, -2.0, 1.0), HardcoreRevivePluginConfig.BlockTag.getOrDefault("soul-sand-blocktag", Set.of()));
        patternMap.put(new Location(world, 1.0, -2.0, -1.0), HardcoreRevivePluginConfig.BlockTag.getOrDefault("soul-sand-blocktag", Set.of()));
        patternMap.put(new Location(world, 1.0, -2.0, 1.0), HardcoreRevivePluginConfig.BlockTag.getOrDefault("soul-sand-blocktag", Set.of()));
        return patternMap;
    }
}

