/*
 * Decompiled with CFR 0.152.
 */
package net.jakeccz.hrp.commands;

import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jakeccz.hrp.util.HardcoreRevivePluginConfig;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.Nullable;

public class HardcoreConfigCMD
implements BasicCommand {
    private static final Map<String, String> cmdKeywords = Map.ofEntries(Map.entry("structure", "STRUCTURE"), Map.entry("1", "STRUCTURE"), Map.entry("s", "STRUCTURE"), Map.entry("struc", "STRUCTURE"), Map.entry("struct", "STRUCTURE"), Map.entry("gamerule", "GAMERULE"), Map.entry("gamerules", "GAMERULE"), Map.entry("2", "GAMERULE"), Map.entry("g", "GAMERULE"), Map.entry("gr", "GAMERULE"), Map.entry("gmr", "GAMERULE"), Map.entry("reload", "RELOAD"), Map.entry("r", "RELOAD"), Map.entry("0", "RELOAD"));
    private static final Collection<String> LIST_CONFIGOPTIONS = List.of("STRUCTURE", "GAMERULE");
    private static final Collection<String> LIST_EDITOPTIONS = List.of("add", "remove", "reset");
    private static final Collection<String> LIST_BOOLEAN = List.of("true", "false");
    private static final Collection<String> LIST_BLOCKIDS = Arrays.stream(Material.values()).filter(Material::isBlock).map(Enum::name).toList();

    public void execute(CommandSourceStack source, String[] args) {
        String opt1;
        Object outputText = "";
        boolean result = false;
        CommandSender cmdSender = source.getSender();
        String plOpt1 = args.length == 0 ? "" : args[0];
        switch (opt1 = cmdKeywords.getOrDefault(plOpt1.toLowerCase(), "\u0000")) {
            case "STRUCTURE": {
                switch (args.length) {
                    case 0: 
                    case 1: {
                        cmdSender.sendRichMessage("<red>Command Failed: /hardcoreconfig <a1> >><<</red>", new TagResolver[]{Placeholder.unparsed((String)"a1", (String)args[0])});
                        return;
                    }
                    case 3: {
                        if (Objects.equals(args[2], "reset")) break;
                    }
                    case 2: {
                        if (HardcoreRevivePluginConfig.BlockTag.containsKey(args[1])) {
                            cmdSender.sendRichMessage("<gray>Contents inside of <aqua><a1></aqua>: <a2></gray>", new TagResolver[]{Placeholder.unparsed((String)"a1", (String)(HardcoreRevivePluginConfig.BlockTag.containsKey(args[1]) ? args[1] : "")), Placeholder.unparsed((String)"a2", (String)HardcoreRevivePluginConfig.BlockTag.getOrDefault(args[1], Set.of()).stream().map(Enum::name).toList().toString())});
                        } else {
                            cmdSender.sendRichMessage("<red>Command Failed: /hardcoreconfig <a1> >><failure><<</red>", new TagResolver[]{Placeholder.unparsed((String)"a1", (String)args[0]), Placeholder.unparsed((String)"failure", (String)args[1])});
                        }
                        return;
                    }
                }
                String who = args.length > 3 ? args[3].toUpperCase() : "\u0000";
                String what = args[2];
                String where = args[1];
                switch (what) {
                    case "add": {
                        if (Objects.equals(who, "ALL")) {
                            Set<Material> whoSet = Arrays.stream(Material.values()).filter(Material::isBlock).collect(Collectors.toSet());
                            result = HardcoreRevivePluginConfig.setBlockTag(where, whoSet);
                            outputText = "Added everything to " + where;
                            break;
                        }
                        Material whoMat = Material.getMaterial((String)who);
                        if (whoMat == null) {
                            cmdSender.sendRichMessage("<red>Command Failed: Invalid BlockMaterial entered</red>");
                            return;
                        }
                        Set<Material> whoSet = Stream.concat(HardcoreRevivePluginConfig.BlockTag.getOrDefault(where, Set.of()).stream(), Stream.of(whoMat)).collect(Collectors.toSet());
                        result = HardcoreRevivePluginConfig.setBlockTag(where, whoSet);
                        outputText = "Added " + whoMat.name() + " to " + where;
                        break;
                    }
                    case "remove": {
                        if (Objects.equals(who, "ALL")) {
                            Set<Material> whoSet = Set.of();
                            result = HardcoreRevivePluginConfig.setBlockTag(where, whoSet);
                            outputText = "Removed everything from " + where;
                            break;
                        }
                        Material whoMat = Material.getMaterial((String)who);
                        if (whoMat == null) {
                            cmdSender.sendRichMessage("<red>Command Failed: Invalid BlockMaterial entered</red>");
                            return;
                        }
                        Set<Material> whoSet = HardcoreRevivePluginConfig.BlockTag.getOrDefault(where, Set.of());
                        whoSet.remove(whoMat);
                        result = HardcoreRevivePluginConfig.setBlockTag(where, whoSet);
                        outputText = "Removed " + whoMat.name() + " from " + where;
                        break;
                    }
                    case "reset": {
                        result = HardcoreRevivePluginConfig.resetBlockTag(where);
                        outputText = "Reset values in " + where;
                    }
                }
                break;
            }
            case "GAMERULE": {
                switch (args.length) {
                    case 0: 
                    case 1: {
                        cmdSender.sendRichMessage("<red>Command Failed: /hardcoreconfig <a1> >><<</red>", new TagResolver[]{Placeholder.unparsed((String)"a1", (String)args[0])});
                        return;
                    }
                    case 2: {
                        if (HardcoreRevivePluginConfig.ConfigRule.containsKey(args[1])) {
                            cmdSender.sendRichMessage("<gray><aqua><a1>:</aqua> <a2></gray>", new TagResolver[]{Placeholder.unparsed((String)"a1", (String)args[1]), Placeholder.unparsed((String)"a2", (String)HardcoreRevivePluginConfig.ConfigRule.get(args[1]).toString())});
                        } else {
                            cmdSender.sendRichMessage("<red>Command Failed: /hardcoreconfig <a1> >><failure><<</red>", new TagResolver[]{Placeholder.unparsed((String)"a1", (String)args[0]), Placeholder.unparsed((String)"failure", (String)args[1])});
                        }
                        return;
                    }
                }
                String who = args[2];
                String where = args[1];
                result = HardcoreRevivePluginConfig.setConfigRule(where, Boolean.parseBoolean(who));
                outputText = "Set " + where + " to " + who;
                break;
            }
            case "RELOAD": {
                HardcoreRevivePluginConfig.init();
                break;
            }
            default: {
                cmdSender.sendRichMessage("<red>Command Failed: /hardcoreconfig >><failure><<</red>", new TagResolver[]{Placeholder.unparsed((String)"failure", (String)plOpt1)});
                return;
            }
        }
        if (!result) {
            cmdSender.sendRichMessage("<red>Command Failed: Something went wrong, check the console for more details</red>", new TagResolver[]{Placeholder.unparsed((String)"failure", (String)plOpt1)});
            return;
        }
        cmdSender.sendRichMessage("<green>Command Success: <success><green>", new TagResolver[]{Placeholder.unparsed((String)"success", (String)outputText)});
    }

    public @Nullable String permission() {
        return "hardcorerevive.commands";
    }

    @NotNull
    public Collection<String> suggest(@NotNull CommandSourceStack commandSourceStack, String[] args) {
        String plOpt1 = args.length == 0 ? "" : args[0];
        String opt1 = cmdKeywords.getOrDefault(plOpt1.toLowerCase(), "\u0000");
        switch (args.length) {
            case 1: {
                return LIST_CONFIGOPTIONS;
            }
            case 2: {
                if (Objects.equals(opt1, "STRUCTURE")) {
                    return HardcoreRevivePluginConfig.BlockTag.keySet();
                }
                if (Objects.equals(opt1, "GAMERULE")) {
                    return HardcoreRevivePluginConfig.ConfigRule.keySet();
                }
            }
            case 3: {
                if (Objects.equals(opt1, "STRUCTURE")) {
                    return LIST_EDITOPTIONS;
                }
                if (Objects.equals(opt1, "GAMERULE")) {
                    return LIST_BOOLEAN;
                }
            }
            case 4: {
                if (Objects.equals(opt1, "STRUCTURE")) {
                    String opt2 = args[2];
                    String opt3 = args[3];
                    if (Objects.equals(opt2, "add")) {
                        return LIST_BLOCKIDS;
                    }
                    if (Objects.equals(opt2, "remove")) {
                        return HardcoreRevivePluginConfig.BlockTag.getOrDefault(args[1], Set.of()).stream().map(Enum::name).toList();
                    }
                }
                return super.suggest(commandSourceStack, args);
            }
        }
        return super.suggest(commandSourceStack, args);
    }
}

