/*
 * Decompiled with CFR 0.152.
 */
package net.jakeccz.hrp.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.jakeccz.hrp.HardcoreRevivePlugin;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.configuration.file.FileConfiguration;

public class HardcoreRevivePluginConfig {
    private static final Map<String, Set<Material>> defaultBlockTag = Map.ofEntries(Map.entry("soul-sand-blocktag", Tag.WITHER_SUMMON_BASE_BLOCKS.getValues()), Map.entry("flower-blocktag", Tag.FLOWERS.getValues()), Map.entry("ore-blocktag", Tag.BEACON_BASE_BLOCKS.getValues()), Map.entry("fence-blocktag", Tag.FENCES.getValues()), Map.entry("stair-blocktag", Tag.STAIRS.getValues()));
    private static final Map<String, Boolean> defaultConfigRule = Map.ofEntries(Map.entry("lose-inventory", false), Map.entry("restrict-menu-access", true), Map.entry("creative-players-drop-heads", false), Map.entry("leave-structure-base", true), Map.entry("head-effects", true));
    public static Map<String, Set<Material>> BlockTag = new HashMap<String, Set<Material>>(Map.ofEntries(Map.entry("soul-sand-blocktag", Tag.WITHER_SUMMON_BASE_BLOCKS.getValues()), Map.entry("flower-blocktag", Tag.FLOWERS.getValues()), Map.entry("ore-blocktag", Tag.BEACON_BASE_BLOCKS.getValues()), Map.entry("fence-blocktag", Tag.FENCES.getValues()), Map.entry("stair-blocktag", Tag.STAIRS.getValues())));
    public static Map<String, Boolean> ConfigRule = new HashMap<String, Boolean>(Map.ofEntries(Map.entry("lose-inventory", false), Map.entry("restrict-menu-access", true), Map.entry("creative-players-drop-heads", false), Map.entry("keep-structure-base", true), Map.entry("head-effects", true), Map.entry("head-burns-in-lava", true)));

    public static void init() {
        HardcoreRevivePlugin.get().saveDefaultConfig();
        HardcoreRevivePlugin.get().reloadConfig();
        FileConfiguration fileConfiguration = HardcoreRevivePlugin.get().getConfig();
        BlockTag.forEach((key, value) -> BlockTag.put((String)key, fileConfiguration.getStringList(key).stream().map(Material::getMaterial).collect(Collectors.toSet())));
        ConfigRule.forEach((key, value) -> ConfigRule.put((String)key, fileConfiguration.getBoolean(key, value.booleanValue())));
    }

    public static boolean resetBlockTag(String where) {
        if (!defaultBlockTag.containsKey(where)) {
            return false;
        }
        return HardcoreRevivePluginConfig.setBlockTag(where, defaultBlockTag.get(where));
    }

    public static boolean setBlockTag(String where, Set<Material> who) {
        try {
            HardcoreRevivePlugin instance = HardcoreRevivePlugin.get();
            instance.getConfig().set(where, who.stream().map(Enum::name).toList());
            instance.saveConfig();
            instance.reloadConfig();
            BlockTag.put(where, who);
        }
        catch (Exception e) {
            HardcoreRevivePlugin.LOGGER.error(e.getMessage());
            return false;
        }
        return true;
    }

    public static boolean setConfigRule(String where, boolean who) {
        try {
            HardcoreRevivePlugin instance = HardcoreRevivePlugin.get();
            instance.getConfig().set(where, (Object)who);
            instance.saveConfig();
            instance.reloadConfig();
            ConfigRule.put(where, who);
        }
        catch (Exception e) {
            HardcoreRevivePlugin.LOGGER.error(e.getMessage());
            return false;
        }
        return true;
    }
}

