/*
 * Decompiled with CFR 0.152.
 */
package net.jakeccz.hrp.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.URL;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;

public class HardcoreRevivePluginUtil {
    public static final String LORE_TEXT = "Used to revive this player";
    public static final List<String> LORE = List.of(ChatColor.translateAlternateColorCodes((char)'&', (String)"Used to revive this player"));
    public static final String DEATH_COORDS_TEXT = "Death Coordinates: [{y} {x} {z}]\nDimension: {dTypeName}";

    private static void nonNullable(Object o, String name) {
        if (o == null) {
            throw new NullPointerException(name + " should not be null!");
        }
    }

    public static ItemStack createSkullWithName(String name) {
        ItemStack skullHead = new ItemStack(Material.PLAYER_HEAD);
        HardcoreRevivePluginUtil.nonNullable(skullHead, "item");
        HardcoreRevivePluginUtil.nonNullable(name, "name");
        SkullMeta meta = (SkullMeta)skullHead.getItemMeta();
        meta.setOwningPlayer(Bukkit.getOfflinePlayer((String)name));
        meta.setLore(LORE);
        skullHead.setItemMeta((ItemMeta)meta);
        return skullHead;
    }

    public static ItemStack createSkullWithBase64(String base64, UUID uuid) {
        ItemStack skullHead = new ItemStack(Material.PLAYER_HEAD);
        HardcoreRevivePluginUtil.nonNullable(skullHead, "item");
        HardcoreRevivePluginUtil.nonNullable(base64, "base64");
        ItemMeta var4 = skullHead.getItemMeta();
        if (var4 instanceof SkullMeta) {
            SkullMeta meta = (SkullMeta)var4;
            try {
                String json = new String(Base64.getDecoder().decode(base64));
                JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
                String textureUrl = jsonObject.getAsJsonObject("textures").getAsJsonObject("SKIN").get("url").getAsString();
                PlayerProfile profile = Bukkit.createPlayerProfile((UUID)uuid);
                PlayerTextures textures = profile.getTextures();
                textures.setSkin(new URL(textureUrl));
                profile.setTextures(textures);
                meta.setOwnerProfile(profile);
                meta.setLore(LORE);
                skullHead.setItemMeta((ItemMeta)meta);
            }
            catch (Exception var9) {
                Exception e = var9;
                e.printStackTrace();
            }
            return skullHead;
        }
        return null;
    }
}

