/*
 * Decompiled with CFR 0.152.
 */
package com.calculatorsteam.dynamicpack;

import com.calculatorsteam.dynamicpack.DynamicPackMod;
import com.calculatorsteam.dynamicpack.pack.DynamicResourcePack;
import com.calculatorsteam.dynamicpack.util.JsonUtil;
import com.calculatorsteam.dynamicpack.util.PackUtil;
import com.calculatorsteam.dynamicpack.util.PathUtil;
import com.calculatorsteam.dynamicpack.util.exception.FailedOpenPackFileSystemException;
import com.calculatorsteam.dynamicpack.util.log.Out;
import com.google.gson.JsonObject;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\bJ\r\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\n\u0010\bJ\u001f\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0015R\u0016\u0010\u0017\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0018R \u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00120\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00120\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006!"}, d2={"Lcom/calculatorsteam/dynamicpack/PacksContainer;", "", "Ljava/io/File;", "directoryToCheck", "<init>", "(Ljava/io/File;)V", "", "lockRescan", "()V", "unlockRescan", "rescan", "location", "Ljava/nio/file/Path;", "clientFile", "processPack", "(Ljava/io/File;Ljava/nio/file/Path;)V", "", "filename", "Lcom/calculatorsteam/dynamicpack/pack/DynamicResourcePack;", "getByFileName", "(Ljava/lang/String;)Lcom/calculatorsteam/dynamicpack/pack/DynamicResourcePack;", "Ljava/io/File;", "", "rescanPacksBlocked", "Z", "isPacksScanning", "", "packs", "Ljava/util/Map;", "", "getPacksArray", "()[Lcom/calculatorsteam/dynamicpack/pack/DynamicResourcePack;", "packsArray", "dynamicpack"})
@SourceDebugExtension(value={"SMAP\nPacksContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PacksContainer.kt\ncom/calculatorsteam/dynamicpack/PacksContainer\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,103:1\n13805#2,2:104\n1869#3,2:106\n37#4,2:108\n*S KotlinDebug\n*F\n+ 1 PacksContainer.kt\ncom/calculatorsteam/dynamicpack/PacksContainer\n*L\n46#1:104,2\n73#1:106,2\n100#1:108,2\n*E\n"})
public final class PacksContainer {
    @NotNull
    private final File directoryToCheck;
    private boolean rescanPacksBlocked;
    private boolean isPacksScanning;
    @NotNull
    private final Map<String, DynamicResourcePack> packs;

    public PacksContainer(@NotNull File directoryToCheck) {
        Intrinsics.checkNotNullParameter((Object)directoryToCheck, (String)"directoryToCheck");
        this.directoryToCheck = directoryToCheck;
        this.packs = new LinkedHashMap();
    }

    public final void lockRescan() {
        this.rescanPacksBlocked = true;
    }

    public final void unlockRescan() {
        this.rescanPacksBlocked = false;
    }

    public final void rescan() {
        if (this.isPacksScanning) {
            Out.INSTANCE.warn("Already in scanning!");
            return;
        }
        if (this.rescanPacksBlocked) {
            Out.INSTANCE.warn("Rescan blocked! maybe currently syncing");
            return;
        }
        this.isPacksScanning = true;
        List forDelete = CollectionsKt.toMutableList((Collection)this.packs.keySet());
        File[] fileArray = PathUtil.listFiles(this.directoryToCheck);
        if (fileArray != null) {
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                DynamicResourcePack currentDynamicPack;
                File element$iv;
                File packFile = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                DynamicResourcePack dynamicResourcePack = currentDynamicPack = DynamicPackMod.Companion.getDynamicPackByMinecraftName("file/" + packFile.getName());
                boolean bl2 = dynamicResourcePack != null ? dynamicResourcePack.isSyncing() : false;
                if (bl2) {
                    Out.INSTANCE.warn("WARNING: Found a pack that is now synchronizing. skipping this pack");
                    continue;
                }
                try {
                    PackUtil.openPackFileSystem$default(packFile, null, arg_0 -> PacksContainer.rescan$lambda$0$0(packFile, this, forDelete, arg_0), 2, null);
                    continue;
                }
                catch (Exception e) {
                    if (e instanceof FailedOpenPackFileSystemException) {
                        Out.INSTANCE.warn("Error while processing pack " + packFile.getName() + ": " + e.getMessage());
                        continue;
                    }
                    Out.error("Error while processing pack: " + packFile.getName(), e);
                }
            }
        }
        Iterable $this$forEach$iv = forDelete;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String s = (String)element$iv;
            boolean bl = false;
            Out.println("Pack " + s + " no longer exist or no longer support DynamicPack!");
            this.packs.remove(s);
        }
        this.isPacksScanning = false;
    }

    private final void processPack(File location, Path clientFile) throws Exception {
        DynamicResourcePack dynamicResourcePack;
        JsonObject json = JsonUtil.readJson(clientFile);
        int formatVersion = JsonUtil.optInt$default(json, "formatVersion", 0, 2, null);
        DynamicResourcePack oldestPack = this.packs.get(location.getName());
        if (formatVersion == 1) {
            DynamicResourcePack $this$processPack_u24lambda_u240 = dynamicResourcePack = new DynamicResourcePack(location, json);
            boolean bl = false;
            if (oldestPack != null) {
                $this$processPack_u24lambda_u240.flashback(oldestPack);
            }
        } else {
            throw new RuntimeException("Unsupported formatVersion for pack " + location.getName() + ": " + formatVersion);
        }
        DynamicResourcePack pack = dynamicResourcePack;
        this.packs.put(location.getName(), pack);
    }

    @NotNull
    public final DynamicResourcePack[] getPacksArray() {
        Collection<DynamicResourcePack> $this$toTypedArray$iv = this.packs.values();
        boolean $i$f$toTypedArray = false;
        Collection<DynamicResourcePack> thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new DynamicResourcePack[0]);
    }

    @Nullable
    public final DynamicResourcePack getByFileName(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        return this.packs.get(filename);
    }

    private static final Unit rescan$lambda$0$0(File $packFile, PacksContainer this$0, List $forDelete, Path packPath) {
        Intrinsics.checkNotNullParameter((Object)packPath, (String)"packPath");
        Path clientFile = packPath.resolve("dynamicmcpack.json");
        if (Files.exists(clientFile, new LinkOption[0])) {
            Out.println("+ Pack " + $packFile.getName() + " supported by mod!");
            Intrinsics.checkNotNull((Object)clientFile);
            this$0.processPack($packFile, clientFile);
            $forDelete.remove($packFile.getName());
        } else {
            Out.println("- Pack " + $packFile.getName() + " not supported by mod.");
        }
        return Unit.INSTANCE;
    }
}

