/*
 * Decompiled with CFR 0.152.
 */
package com.calculatorsteam.dynamicpack.client;

import com.calculatorsteam.dynamicpack.DynamicPackMod;
import com.calculatorsteam.dynamicpack.client.config.Config;
import com.calculatorsteam.dynamicpack.sync.SyncBuilder;
import com.calculatorsteam.dynamicpack.sync.SyncProgress;
import com.calculatorsteam.dynamicpack.sync.SyncingTask;
import com.calculatorsteam.dynamicpack.util.log.LoopLog;
import com.calculatorsteam.dynamicpack.util.log.NetworkStat;
import com.calculatorsteam.dynamicpack.util.log.Out;
import com.calculatorsteam.dynamicpack.util.status.StatusChecker;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0006\n\u0002\b\u0005\u0018\u0000 12\u00020\u0001:\u00011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u000f\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\f\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\u000bJ\r\u0010\r\u001a\u00020\u0004\u00a2\u0006\u0004\b\r\u0010\u0003J\r\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000e\u0010\u0003J\r\u0010\u000f\u001a\u00020\t\u00a2\u0006\u0004\b\u000f\u0010\u000bJ\r\u0010\u0010\u001a\u00020\t\u00a2\u0006\u0004\b\u0010\u0010\u000bJ\u000f\u0010\u0011\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0003R\u0016\u0010\u0013\u001a\u00020\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\u00020\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0014R$\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\t8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u000bR$\u0010\u001b\u001a\u0004\u0018\u00010\u001a8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0017\u0010\"\u001a\u00020!8\u0006\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%R\u0011\u0010(\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0011\u0010*\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b)\u0010'R\u0011\u0010,\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b+\u0010'R\u0011\u00100\u001a\u00020-8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\u00a8\u00062"}, d2={"Lcom/calculatorsteam/dynamicpack/client/GameStartSyncing;", "Ljava/lang/Thread;", "<init>", "()V", "", "run", "Lcom/calculatorsteam/dynamicpack/sync/SyncProgress;", "createSyncProgress", "()Lcom/calculatorsteam/dynamicpack/sync/SyncProgress;", "", "isLockSupported", "()Z", "lockedTick", "endGameLocking", "startGameLocking", "isLockStarted", "isLocked", "unlock", "", "updateStartTime", "J", "lockStartTime", "value", "lockResourcesLoading", "Z", "getLockResourcesLoading", "Lcom/calculatorsteam/dynamicpack/sync/SyncBuilder;", "syncBuilder", "Lcom/calculatorsteam/dynamicpack/sync/SyncBuilder;", "getSyncBuilder", "()Lcom/calculatorsteam/dynamicpack/sync/SyncBuilder;", "setSyncBuilder", "(Lcom/calculatorsteam/dynamicpack/sync/SyncBuilder;)V", "Lcom/calculatorsteam/dynamicpack/util/log/LoopLog;", "etaLoopLog", "Lcom/calculatorsteam/dynamicpack/util/log/LoopLog;", "getEtaLoopLog", "()Lcom/calculatorsteam/dynamicpack/util/log/LoopLog;", "getLockTime", "()J", "lockTime", "getUpdateTime", "updateTime", "getUntilForceUnlock", "untilForceUnlock", "", "getPercentage", "()D", "percentage", "Companion", "dynamicpack"})
public final class GameStartSyncing
extends Thread {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long updateStartTime;
    private long lockStartTime;
    private boolean lockResourcesLoading = true;
    @Nullable
    private SyncBuilder syncBuilder;
    @NotNull
    private final LoopLog etaLoopLog = new LoopLog(DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS), null);
    private static final int MAX_LOCK_MS = 15000;

    public GameStartSyncing() {
        super("GameStartSyncingThread");
        if (!Config.Companion.getInstance().isAutoUpdateAtLaunch()) {
            Out.INSTANCE.warn("Auto-update at launch disabled by config.");
            this.unlock();
        }
    }

    public final boolean getLockResourcesLoading() {
        return this.lockResourcesLoading;
    }

    @Nullable
    public final SyncBuilder getSyncBuilder() {
        return this.syncBuilder;
    }

    public final void setSyncBuilder(@Nullable SyncBuilder syncBuilder2) {
        this.syncBuilder = syncBuilder2;
    }

    @NotNull
    public final LoopLog getEtaLoopLog() {
        return this.etaLoopLog;
    }

    @Override
    public void run() {
        if (!Config.Companion.getInstance().isAutoUpdateAtLaunch()) {
            Out.INSTANCE.warn("Thread launched with isAutoUpdateAtLaunch=false; return");
            return;
        }
        this.updateStartTime = System.currentTimeMillis();
        Out.INSTANCE.debug("[GameStartSyncing] thread started");
        SyncingTask.launchTaskAsSyncing((Function0<Unit>)((Function0)() -> GameStartSyncing.run$lambda$0(this)));
    }

    private final SyncProgress createSyncProgress() {
        return new SyncProgress(this){
            final /* synthetic */ GameStartSyncing this$0;
            {
                this.this$0 = $receiver;
            }

            public void setPhase(String phase) {
                Intrinsics.checkNotNullParameter((Object)phase, (String)"phase");
                Out.INSTANCE.debug("Phase: " + phase);
                SyncingTask.log(phase);
            }

            public void downloading(String name, float percentage) {
                block3: {
                    long l;
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    SyncBuilder syncBuilder2 = this.this$0.getSyncBuilder();
                    if (syncBuilder2 == null) break block3;
                    SyncBuilder syncBuilder3 = syncBuilder2;
                    GameStartSyncing gameStartSyncing = this.this$0;
                    SyncBuilder builder = syncBuilder3;
                    boolean bl = false;
                    long remainsBytes = builder.getUpdateSize() - builder.getDownloadedSize();
                    long it = l = NetworkStat.INSTANCE.remainingETA(remainsBytes);
                    boolean bl2 = false;
                    SyncingTask.eta = it;
                    long eta = l;
                    if (gameStartSyncing.getEtaLoopLog().tick()) {
                        Out.INSTANCE.debug("(" + SyncingTask.currentPackName + ") ETA=" + eta + "s");
                    }
                    if (gameStartSyncing.getUpdateTime() > 3000L && gameStartSyncing.isLocked()) {
                        boolean shouldUnlock;
                        boolean bl3 = shouldUnlock = (float)(eta * (long)1000) > (float)gameStartSyncing.getUntilForceUnlock() / 1.5f;
                        if (shouldUnlock) {
                            Out.INSTANCE.debug("[GameStartSyncing] ETA " + eta + "s. Unlocking main thread...");
                            GameStartSyncing.access$unlock(gameStartSyncing);
                        }
                    }
                }
            }

            public void deleted(Path name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Out.INSTANCE.debug("Deleted: " + name);
                SyncingTask.log("Delete: " + name.getFileName());
            }
        };
    }

    public final boolean isLockSupported() {
        return true;
    }

    public final boolean lockedTick() {
        if (this.getLockTime() > 15000L) {
            Out.INSTANCE.warn("Main thread unlocked forcibly because lock time >= 15s");
            return false;
        }
        return true;
    }

    public final long getLockTime() {
        return System.currentTimeMillis() - this.lockStartTime;
    }

    public final long getUpdateTime() {
        return System.currentTimeMillis() - this.updateStartTime;
    }

    public final long getUntilForceUnlock() {
        return (long)15000 - this.getLockTime();
    }

    public final void endGameLocking() {
        Out.println("Main thread locked for " + this.getLockTime() / (long)1000 + " seconds");
    }

    public final void startGameLocking() {
        Out.println("Main thread locked by DynamicPack for updating resource packs...");
        this.lockStartTime = System.currentTimeMillis();
    }

    public final boolean isLockStarted() {
        return this.lockStartTime != 0L;
    }

    public final boolean isLocked() {
        return this.isLockStarted() && this.lockResourcesLoading;
    }

    private final void unlock() {
        this.lockResourcesLoading = false;
    }

    public final double getPercentage() {
        double d;
        SyncBuilder syncBuilder2 = this.syncBuilder;
        if (syncBuilder2 != null) {
            SyncBuilder b = syncBuilder2;
            boolean bl = false;
            d = b.getDownloadedSize() > 0L ? (double)b.getDownloadedSize() / (double)b.getUpdateSize() * 100.0 : 0.0;
        } else {
            d = 0.0;
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit run$lambda$0(GameStartSyncing this$0) {
        try {
            SyncBuilder syncBuilder2;
            StatusChecker.check();
            SyncBuilder builder = syncBuilder2 = SyncingTask.rootSyncBuilder();
            boolean bl = false;
            this$0.syncBuilder = builder;
            builder.init(false);
            if (builder.isUpdateAvailable()) {
                boolean reloadRequired = builder.doUpdate(this$0.createSyncProgress());
                if (!this$0.lockResourcesLoading && reloadRequired) {
                    DynamicPackMod.Companion.getInstance().needResourcesReload();
                }
            }
            SyncingTask.currentRootSyncBuilder = syncBuilder2;
        }
        catch (Exception e) {
            Out.error("Error while GameStartSyncing...", e);
        }
        finally {
            this$0.unlock();
            SyncingTask.currentRootSyncBuilder = null;
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$unlock(GameStartSyncing $this) {
        $this.unlock();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/calculatorsteam/dynamicpack/client/GameStartSyncing$Companion;", "", "<init>", "()V", "", "MAX_LOCK_MS", "I", "dynamicpack"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

