/*
 * Decompiled with CFR 0.152.
 */
package com.calculatorsteam.dynamicpack.pack.dynamicrepo;

import com.calculatorsteam.dynamicpack.InputValidator;
import com.calculatorsteam.dynamicpack.pack.DynamicResourcePack;
import com.calculatorsteam.dynamicpack.pack.dynamicrepo.BaseContent;
import com.calculatorsteam.dynamicpack.pack.dynamicrepo.BaseEnum;
import com.calculatorsteam.dynamicpack.pack.dynamicrepo.DynamicRepoRemote;
import com.calculatorsteam.dynamicpack.util.JsonUtil;
import com.calculatorsteam.dynamicpack.util.enums.OverrideType;
import com.calculatorsteam.dynamicpack.util.log.Out;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\r\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0019\u0010\u0011\u001a\u00020\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0012J!\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0012J\u001d\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0013\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u001f\u00a2\u0006\u0004\b!\u0010\"J%\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00150%2\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010*\u001a\u00020)2\u0006\u0010(\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b*\u0010+J\u001d\u0010-\u001a\u00020\b2\u0006\u0010#\u001a\u00020 2\u0006\u0010,\u001a\u00020)\u00a2\u0006\u0004\b-\u0010.J\u001d\u0010-\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010,\u001a\u00020)\u00a2\u0006\u0004\b-\u0010/J\u0013\u00101\u001a\b\u0012\u0004\u0012\u0002000\u001f\u00a2\u0006\u0004\b1\u00102R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u00103R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u00104R \u00106\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001b058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b6\u00107R\u0014\u00108\u001a\u00020\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b8\u00109R\u0014\u0010:\u001a\u00020\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b:\u00109\u00a8\u0006;"}, d2={"Lcom/calculatorsteam/dynamicpack/pack/dynamicrepo/DynamicRepoPreferences;", "", "Lcom/calculatorsteam/dynamicpack/pack/DynamicResourcePack;", "pack", "Lcom/calculatorsteam/dynamicpack/pack/dynamicrepo/DynamicRepoRemote;", "remote", "<init>", "(Lcom/calculatorsteam/dynamicpack/pack/DynamicResourcePack;Lcom/calculatorsteam/dynamicpack/pack/dynamicrepo/DynamicRepoRemote;)V", "", "recalculateContentOverrideFromJson", "()V", "Lcom/google/gson/JsonObject;", "repoJson", "notifyNewRemoteJson", "(Lcom/google/gson/JsonObject;)V", "Lcom/google/gson/JsonArray;", "guis", "updateKnownGuis", "(Lcom/google/gson/JsonArray;)V", "validateGuis", "contents", "", "findId", "getContentJsonById", "(Lcom/google/gson/JsonArray;Ljava/lang/String;)Lcom/google/gson/JsonObject;", "updateKnownContents", "id", "", "def", "isContentActive", "(Ljava/lang/String;Z)Z", "", "Lcom/calculatorsteam/dynamicpack/pack/dynamicrepo/BaseContent;", "getKnownContents", "()[Lcom/calculatorsteam/dynamicpack/pack/dynamicrepo/BaseContent;", "content", "key", "", "parseContentList", "(Lcom/google/gson/JsonObject;Ljava/lang/String;)Ljava/util/Set;", "contentId", "Lcom/calculatorsteam/dynamicpack/util/enums/OverrideType;", "getCurrentOverrideStatus", "(Ljava/lang/String;)Lcom/calculatorsteam/dynamicpack/util/enums/OverrideType;", "overrideType", "setContentOverride", "(Lcom/calculatorsteam/dynamicpack/pack/dynamicrepo/BaseContent;Lcom/calculatorsteam/dynamicpack/util/enums/OverrideType;)V", "(Ljava/lang/String;Lcom/calculatorsteam/dynamicpack/util/enums/OverrideType;)V", "Lcom/calculatorsteam/dynamicpack/pack/dynamicrepo/BaseEnum;", "getKnownEnums", "()[Lcom/calculatorsteam/dynamicpack/pack/dynamicrepo/BaseEnum;", "Lcom/calculatorsteam/dynamicpack/pack/DynamicResourcePack;", "Lcom/calculatorsteam/dynamicpack/pack/dynamicrepo/DynamicRepoRemote;", "", "contentOverrides", "Ljava/util/Map;", "cachedRemoteJson", "Lcom/google/gson/JsonObject;", "cachedCurrentJson", "dynamicpack"})
@SourceDebugExtension(value={"SMAP\nDynamicRepoPreferences.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DynamicRepoPreferences.kt\ncom/calculatorsteam/dynamicpack/pack/dynamicrepo/DynamicRepoPreferences\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,232:1\n1869#2,2:233\n1869#2:235\n1869#2:236\n1870#2:238\n1870#2:239\n295#2,2:240\n1869#2,2:242\n1869#2,2:244\n1869#2,2:248\n1869#2,2:250\n1#3:237\n37#4,2:246\n37#4,2:252\n*S KotlinDebug\n*F\n+ 1 DynamicRepoPreferences.kt\ncom/calculatorsteam/dynamicpack/pack/dynamicrepo/DynamicRepoPreferences\n*L\n37#1:233,2\n74#1:235\n83#1:236\n83#1:238\n74#1:239\n101#1:240,2\n117#1:242,2\n144#1:244,2\n170#1:248,2\n218#1:250,2\n156#1:246,2\n224#1:252,2\n*E\n"})
public final class DynamicRepoPreferences {
    @NotNull
    private final DynamicResourcePack pack;
    @NotNull
    private final DynamicRepoRemote remote;
    @NotNull
    private final Map<String, Boolean> contentOverrides;
    @NotNull
    private final JsonObject cachedRemoteJson;
    @NotNull
    private final JsonObject cachedCurrentJson;

    public DynamicRepoPreferences(@NotNull DynamicResourcePack pack, @NotNull DynamicRepoRemote remote) {
        Intrinsics.checkNotNullParameter((Object)pack, (String)"pack");
        Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
        this.pack = pack;
        this.remote = remote;
        this.contentOverrides = new LinkedHashMap();
        this.cachedRemoteJson = this.remote.getCachedRemote();
        this.cachedCurrentJson = this.remote.getCachedCurrent();
        this.recalculateContentOverrideFromJson();
    }

    private final void recalculateContentOverrideFromJson() {
        this.contentOverrides.clear();
        if (this.cachedRemoteJson.has("content_override")) {
            JsonObject j = this.cachedRemoteJson.getAsJsonObject("content_override");
            Set set = j.keySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"keySet(...)");
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String key = (String)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)j);
                Intrinsics.checkNotNull((Object)key);
                this.contentOverrides.put(key, JsonUtil.getBoolean(j, key));
            }
            if (j.size() == 0) {
                this.cachedCurrentJson.remove("content_override");
            }
        }
    }

    public final void notifyNewRemoteJson(@NotNull JsonObject repoJson) {
        JsonArray guis;
        JsonArray contents;
        Intrinsics.checkNotNullParameter((Object)repoJson, (String)"repoJson");
        JsonArray jsonArray = JsonUtil.getJsonArray(repoJson, "contents");
        if (jsonArray == null) {
            jsonArray = contents = new JsonArray();
        }
        if ((guis = JsonUtil.getJsonArray(repoJson, "gui")) == null) {
            Out.INSTANCE.debug("Repo not using 'gui' features.");
        }
        this.updateKnownContents(contents);
        this.updateKnownGuis(guis);
    }

    private final void updateKnownGuis(JsonArray guis) {
        if (guis != null) {
            this.validateGuis(guis);
            this.cachedCurrentJson.add("known_guis", (JsonElement)guis);
        } else {
            this.cachedCurrentJson.remove("known_guis");
        }
    }

    private final void validateGuis(JsonArray guis) {
        Iterator iterator = guis.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            JsonElement _gui = (JsonElement)iterator2.next();
            JsonObject gui = _gui.getAsJsonObject();
            Intrinsics.checkNotNull((Object)gui);
            String type = JsonUtil.getString(gui, "type");
            String id = JsonUtil.getString(gui, "id");
            InputValidator.throwIsContentIdInvalid(id);
            InputValidator.throwIsContentIdInvalid(type);
            if (!StringsKt.equals((String)type, (String)"enum", (boolean)true)) continue;
            JsonObject enums = gui.getAsJsonObject("enum");
            Set set = enums.keySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"keySet(...)");
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String key = (String)element$iv;
                boolean bl = false;
                InputValidator.throwIsContentIdInvalid(key);
                JsonObject anEnum = enums.getAsJsonObject(key);
                Intrinsics.checkNotNull((Object)anEnum);
                if (!InputValidator.isDynamicPackNameValid(JsonUtil.getString(anEnum, "name"))) {
                    throw new RuntimeException("Name of enum element invalid :( enumKey=" + key);
                }
                JsonObject contents = anEnum.getAsJsonObject("contents");
                Set set2 = contents.keySet();
                Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"keySet(...)");
                Iterable $this$forEach$iv2 = set2;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    String contentId = (String)element$iv2;
                    boolean bl2 = false;
                    contents.get(contentId).getAsBoolean();
                    BaseContent[] baseContentArray = this.getKnownContents();
                    Intrinsics.checkNotNull((Object)contentId);
                    BaseContent found = BaseContent.Companion.findById(baseContentArray, contentId);
                    if (found == null) {
                        boolean bl3 = false;
                        String string = "Content from enum not found :(";
                        throw new IllegalArgumentException(string.toString());
                    }
                    if (!found.getRequired()) continue;
                    throw new RuntimeException("Override 'required':true content in enum not allowed!");
                }
            }
        }
    }

    private final JsonObject getContentJsonById(JsonArray contents, String findId) {
        Object v1;
        block1: {
            Out.INSTANCE.debug("getContentJsonById findId=" + findId);
            Iterable $this$firstOrNull$iv = (Iterable)contents;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                JsonElement it = (JsonElement)element$iv;
                boolean bl = false;
                JsonObject jsonObject = it.getAsJsonObject();
                Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"getAsJsonObject(...)");
                if (!StringsKt.equals((String)JsonUtil.getString(jsonObject, "id"), (String)findId, (boolean)true)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        JsonElement jsonElement = v1;
        return jsonElement != null ? jsonElement.getAsJsonObject() : null;
    }

    private final void updateKnownContents(JsonArray contents) {
        JsonObject knownContents = new JsonObject();
        Iterator iterator = contents.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            JsonObject jsonObject;
            JsonElement contentElem = (JsonElement)iterator2.next();
            JsonObject jsonObject2 = contentElem.getAsJsonObject();
            Intrinsics.checkNotNull((Object)jsonObject2);
            String id = JsonUtil.getString(jsonObject2, "id");
            boolean required = JsonUtil.optBoolean(jsonObject2, "required", false);
            if (required) {
                this.setContentOverride(id, OverrideType.NOT_SET);
            }
            Set<String> excludeContent = this.parseContentList(jsonObject2, "exclude_content");
            Iterable $this$forEach$iv = excludeContent;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JsonObject cont;
                String s = (String)element$iv;
                boolean bl = false;
                if (this.getContentJsonById(contents, s) == null) {
                    throw new RuntimeException("exclude_content contains id not found content :(");
                }
                if (!JsonUtil.optBoolean(cont, "required", false)) continue;
                throw new RuntimeException("Exclude required content not allowed!");
            }
            if (excludeContent.contains(id)) {
                throw new RuntimeException("Self id in exclude list. Not allowed!");
            }
            JsonObject $this$updateKnownContents_u24lambda_u241 = jsonObject = jsonObject2.deepCopy();
            boolean bl = false;
            $this$updateKnownContents_u24lambda_u241.remove("id");
            JsonObject newJsonObject = jsonObject;
            knownContents.add(id, (JsonElement)newJsonObject);
        }
        this.cachedCurrentJson.add("known_contents", (JsonElement)knownContents);
    }

    public final boolean isContentActive(@NotNull String id, boolean def) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Boolean bl = this.contentOverrides.get(id);
        return bl != null ? bl : def;
    }

    @NotNull
    public final BaseContent[] getKnownContents() {
        BaseContent[] baseContentArray;
        try {
            BaseContent[] baseContentArray2;
            if (this.cachedCurrentJson.has("known_contents")) {
                JsonObject known = this.cachedCurrentJson.getAsJsonObject("known_contents");
                List list = new ArrayList();
                Set set = known.keySet();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"keySet(...)");
                Iterable $this$forEach$iv = set;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    OverrideType overrideType;
                    String contentId = (String)element$iv;
                    boolean bl = false;
                    JsonObject content = known.getAsJsonObject(contentId);
                    Intrinsics.checkNotNull((Object)content);
                    boolean required = JsonUtil.optBoolean(content, "required", false);
                    boolean defaultValue = JsonUtil.optBoolean(content, "default_active", true);
                    boolean hidden = JsonUtil.optBoolean(content, "hidden", false);
                    String name = JsonUtil.optString(content, "name", null);
                    if (required) {
                        overrideType = OverrideType.TRUE;
                    } else {
                        Intrinsics.checkNotNull((Object)contentId);
                        overrideType = this.getCurrentOverrideStatus(contentId);
                    }
                    OverrideType resultOverride = overrideType;
                    Set<String> exclude = this.parseContentList(content, "exclude_content");
                    Collection collection = list;
                    Intrinsics.checkNotNull((Object)contentId);
                    collection.add(new BaseContent(this.remote, contentId, required, resultOverride, name, defaultValue, hidden, exclude));
                }
                Collection $this$toTypedArray$iv = list;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                baseContentArray2 = thisCollection$iv.toArray(new BaseContent[0]);
            } else {
                baseContentArray2 = new BaseContent[]{};
            }
            baseContentArray = baseContentArray2;
        }
        catch (Exception e) {
            this.pack.setLatestException(e);
            Out.error("Error while getKnownContents()", e);
            baseContentArray = new BaseContent[]{};
        }
        return baseContentArray;
    }

    private final Set<String> parseContentList(JsonObject content, String key) {
        Set set = new LinkedHashSet();
        if (content.has(key)) {
            JsonElement element = content.get(key);
            if (element.isJsonArray()) {
                JsonArray jsonArray = element.getAsJsonArray();
                Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"getAsJsonArray(...)");
                Iterable $this$forEach$iv = (Iterable)jsonArray;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    JsonElement jsonElement = (JsonElement)element$iv;
                    boolean bl = false;
                    String str = jsonElement.getAsString();
                    Intrinsics.checkNotNull((Object)str);
                    if (set.add(str)) continue;
                    throw new RuntimeException(key + ": duplicated!");
                }
            } else if (element.isJsonPrimitive()) {
                String string = element.getAsString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
                set.add(string);
            }
        }
        return set;
    }

    private final OverrideType getCurrentOverrideStatus(String contentId) {
        Object object;
        block3: {
            block2: {
                object = this.contentOverrides.get(contentId);
                if (object == null) break block2;
                boolean it = object;
                boolean bl = false;
                OverrideType overrideType = OverrideType.Companion.ofBoolean(it);
                object = overrideType;
                if (overrideType != null) break block3;
            }
            object = OverrideType.NOT_SET;
        }
        return object;
    }

    public final void setContentOverride(@NotNull BaseContent content, @NotNull OverrideType overrideType) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)((Object)overrideType), (String)"overrideType");
        OverrideType effective = content.getRequired() ? OverrideType.NOT_SET : overrideType;
        this.setContentOverride(content.getId(), effective);
    }

    public final void setContentOverride(@NotNull String id, @NotNull OverrideType overrideType) {
        JsonObject override;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)((Object)overrideType), (String)"overrideType");
        Out.INSTANCE.debug("setContentOverride: " + id + ": " + overrideType);
        Object object = this.cachedRemoteJson.has("content_override") ? this.cachedRemoteJson.getAsJsonObject("content_override") : (override = overrideType != OverrideType.NOT_SET ? new JsonObject() : null);
        if (override != null) {
            if (overrideType == OverrideType.NOT_SET) {
                override.remove(id);
            } else {
                override.addProperty(id, Boolean.valueOf(overrideType.asBoolean()));
            }
            if (override.keySet().isEmpty()) {
                this.cachedRemoteJson.remove("content_override");
            } else if (!this.cachedRemoteJson.has("content_override")) {
                this.cachedRemoteJson.add("content_override", (JsonElement)override);
            }
        }
        this.recalculateContentOverrideFromJson();
    }

    @NotNull
    public final BaseEnum[] getKnownEnums() {
        BaseEnum[] baseEnumArray;
        try {
            BaseEnum[] baseEnumArray2;
            if (this.cachedCurrentJson.has("known_guis")) {
                JsonArray known = this.cachedCurrentJson.getAsJsonArray("known_guis");
                List enums = new ArrayList();
                Intrinsics.checkNotNull((Object)known);
                Iterable $this$forEach$iv = (Iterable)known;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    JsonElement elem = (JsonElement)element$iv;
                    boolean bl = false;
                    JsonObject jsonEnum = elem.getAsJsonObject();
                    Intrinsics.checkNotNull((Object)jsonEnum);
                    if (!StringsKt.equals((String)JsonUtil.getString(jsonEnum, "type"), (String)"enum", (boolean)true)) continue;
                    ((Collection)enums).add(BaseEnum.Companion.ofJson(jsonEnum));
                }
                Collection $this$toTypedArray$iv = enums;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                baseEnumArray2 = thisCollection$iv.toArray(new BaseEnum[0]);
            } else {
                baseEnumArray2 = new BaseEnum[]{};
            }
            baseEnumArray = baseEnumArray2;
        }
        catch (Exception e) {
            this.pack.setLatestException(e);
            Out.error("Error while getKnownEnums()", e);
            baseEnumArray = new BaseEnum[]{};
        }
        return baseEnumArray;
    }
}

