/*
 * Decompiled with CFR 0.152.
 */
package com.calculatorsteam.dynamicpack.pack.dynamicrepo;

import com.calculatorsteam.dynamicpack.Constants;
import com.calculatorsteam.dynamicpack.InputValidator;
import com.calculatorsteam.dynamicpack.pack.DynamicResourcePack;
import com.calculatorsteam.dynamicpack.pack.dynamicrepo.DynamicFile;
import com.calculatorsteam.dynamicpack.pack.dynamicrepo.DynamicRepoRemote;
import com.calculatorsteam.dynamicpack.sync.SyncBuilder;
import com.calculatorsteam.dynamicpack.sync.SyncProgress;
import com.calculatorsteam.dynamicpack.util.Hashes;
import com.calculatorsteam.dynamicpack.util.JsonUtil;
import com.calculatorsteam.dynamicpack.util.LockUtils;
import com.calculatorsteam.dynamicpack.util.PackUtil;
import com.calculatorsteam.dynamicpack.util.PathUtil;
import com.calculatorsteam.dynamicpack.util.Urls;
import com.calculatorsteam.dynamicpack.util.UrlsController;
import com.calculatorsteam.dynamicpack.util.log.NetworkStat;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u000f\u0018\u0000 W2\u00020\u0001:\u0001WB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001f\u0010\u001d\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ'\u0010\"\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\"\u0010#J\u000f\u0010%\u001a\u00020$H\u0002\u00a2\u0006\u0004\b%\u0010&J\u001f\u0010*\u001a\u00020'2\u0006\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020'H\u0002\u00a2\u0006\u0004\b*\u0010+J\u0015\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00170,H\u0002\u00a2\u0006\u0004\b-\u0010.J\r\u0010/\u001a\u00020\b\u00a2\u0006\u0004\b/\u00100J\u0017\u00103\u001a\u00020\n2\u0006\u00102\u001a\u000201H\u0002\u00a2\u0006\u0004\b3\u00104J\u0017\u00106\u001a\u00020\n2\u0006\u00105\u001a\u00020'H\u0002\u00a2\u0006\u0004\b6\u00107J\u001f\u0010:\u001a\u00020\n2\u0006\u00105\u001a\u00020'2\u0006\u00109\u001a\u000208H\u0002\u00a2\u0006\u0004\b:\u0010;J\u0017\u0010<\u001a\u00020\n2\u0006\u00105\u001a\u00020'H\u0002\u00a2\u0006\u0004\b<\u00107J\u0017\u0010=\u001a\u00020\n2\u0006\u00105\u001a\u00020'H\u0002\u00a2\u0006\u0004\b=\u00107R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010>R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010?R\u001a\u0010A\u001a\b\u0012\u0004\u0012\u00020'0@8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bA\u0010BR\u0016\u0010C\u001a\u00020\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bC\u0010DR \u0010F\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020 0E8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bF\u0010GR\u0016\u0010H\u001a\u00020\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bH\u0010DR\u0016\u0010J\u001a\u00020I8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bJ\u0010KR\u0016\u0010L\u001a\u00020I8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bL\u0010KR\u0016\u0010M\u001a\u00020\u00178\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\bM\u0010NR\u0016\u0010O\u001a\u00020\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bO\u0010DR\u0016\u0010P\u001a\u00020\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bP\u0010DR\u0014\u0010S\u001a\u00020I8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bQ\u0010RR\u0014\u0010T\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bT\u00100R\u0014\u0010V\u001a\u00020I8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bU\u0010R\u00a8\u0006X"}, d2={"Lcom/calculatorsteam/dynamicpack/pack/dynamicrepo/DynamicRepoSyncBuilder;", "Lcom/calculatorsteam/dynamicpack/sync/SyncBuilder;", "Lcom/calculatorsteam/dynamicpack/pack/DynamicResourcePack;", "pack", "Lcom/calculatorsteam/dynamicpack/pack/dynamicrepo/DynamicRepoRemote;", "remote", "<init>", "(Lcom/calculatorsteam/dynamicpack/pack/DynamicResourcePack;Lcom/calculatorsteam/dynamicpack/pack/dynamicrepo/DynamicRepoRemote;)V", "", "ignoreCaches", "", "init", "(Z)V", "Lcom/google/gson/JsonArray;", "contents", "checkContents", "(Lcom/google/gson/JsonArray;)V", "Lcom/calculatorsteam/dynamicpack/sync/SyncProgress;", "progress", "doUpdate", "(Lcom/calculatorsteam/dynamicpack/sync/SyncProgress;)Z", "interrupt", "()V", "Lcom/google/gson/JsonObject;", "jsonContent", "processContentInit", "(Lcom/google/gson/JsonObject;)V", "Ljava/nio/file/Path;", "packFs", "internalProcessDynamicFiles", "(Lcom/calculatorsteam/dynamicpack/sync/SyncProgress;Ljava/nio/file/Path;)V", "rootPath", "Lcom/calculatorsteam/dynamicpack/pack/dynamicrepo/DynamicFile;", "dynamicFile", "downloadFile", "(Ljava/nio/file/Path;Lcom/calculatorsteam/dynamicpack/pack/dynamicrepo/DynamicFile;Lcom/calculatorsteam/dynamicpack/sync/SyncProgress;)V", "Ljava/util/concurrent/ExecutorService;", "getExecutor", "()Ljava/util/concurrent/ExecutorService;", "", "remoteParent", "path", "getUrlFromPathAndCheck", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "", "calcActiveContents", "()Ljava/util/List;", "isReloadRequired", "()Z", "", "obj", "markReloadRequired", "(Ljava/lang/Object;)V", "s", "debug", "(Ljava/lang/String;)V", "", "e", "error", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "warn", "println", "Lcom/calculatorsteam/dynamicpack/pack/DynamicResourcePack;", "Lcom/calculatorsteam/dynamicpack/pack/dynamicrepo/DynamicRepoRemote;", "", "oldestFilesList", "Ljava/util/Set;", "doNotDeleteOldestFiles", "Z", "", "dynamicFiles", "Ljava/util/Map;", "updateAvailable", "", "_updateSize", "J", "_downloadedSize", "repoJson", "Lcom/google/gson/JsonObject;", "reloadRequired", "interrupted", "getDownloadedSize", "()J", "downloadedSize", "isUpdateAvailable", "getUpdateSize", "updateSize", "Companion", "dynamicpack"})
@SourceDebugExtension(value={"SMAP\nDynamicRepoSyncBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DynamicRepoSyncBuilder.kt\ncom/calculatorsteam/dynamicpack/pack/dynamicrepo/DynamicRepoSyncBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,378:1\n1869#2,2:379\n1869#2,2:381\n1563#2:383\n1634#2,3:384\n1617#2,9:389\n1869#2:398\n1870#2:400\n1626#2:401\n1869#2,2:402\n37#3,2:387\n1#4:399\n*S KotlinDebug\n*F\n+ 1 DynamicRepoSyncBuilder.kt\ncom/calculatorsteam/dynamicpack/pack/dynamicrepo/DynamicRepoSyncBuilder\n*L\n84#1:379,2\n114#1:381,2\n247#1:383\n247#1:384,3\n258#1:389,9\n258#1:398\n258#1:400\n258#1:401\n262#1:402,2\n257#1:387,2\n258#1:399\n*E\n"})
public final class DynamicRepoSyncBuilder
implements SyncBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DynamicResourcePack pack;
    @NotNull
    private final DynamicRepoRemote remote;
    @NotNull
    private final Set<String> oldestFilesList;
    private boolean doNotDeleteOldestFiles;
    @NotNull
    private final Map<String, DynamicFile> dynamicFiles;
    private boolean updateAvailable;
    private long _updateSize;
    private long _downloadedSize;
    private JsonObject repoJson;
    private boolean reloadRequired;
    private boolean interrupted;
    private static int DOWNLOAD_THREADS_COUNT = 8;
    private static int executorCounter;

    public DynamicRepoSyncBuilder(@NotNull DynamicResourcePack pack, @NotNull DynamicRepoRemote remote) {
        Intrinsics.checkNotNullParameter((Object)pack, (String)"pack");
        Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
        this.pack = pack;
        this.remote = remote;
        this.oldestFilesList = new LinkedHashSet();
        this.dynamicFiles = new LinkedHashMap();
    }

    @Override
    public void init(boolean ignoreCaches) {
        block14: {
            String remoteName;
            long minBuild;
            long formatVersion;
            String string;
            block16: {
                block15: {
                    boolean bl = this.updateAvailable = ignoreCaches || this.remote.checkUpdateAvailable();
                    if (!this.updateAvailable) break block14;
                    String string2 = Urls.parseTextContent(this.remote.getPackUrl(), Constants.INSTANCE.getMOD_FILES_LIMIT(), new UrlsController(this){
                        final /* synthetic */ DynamicRepoSyncBuilder this$0;
                        {
                            this.this$0 = $receiver;
                        }

                        public boolean isInterrupted() {
                            return DynamicRepoSyncBuilder.access$getInterrupted$p(this.this$0);
                        }
                    });
                    if (string2 == null) break block15;
                    string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                    if (string != null) break block16;
                }
                throw new RuntimeException("Empty repo response");
            }
            String packUrlContent2 = string;
            this.repoJson = JsonUtil.fromString(packUrlContent2);
            JsonObject jsonObject = this.repoJson;
            if (jsonObject == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"repoJson");
                jsonObject = null;
            }
            if ((formatVersion = jsonObject.get("formatVersion").getAsLong()) != 1L) {
                throw new RuntimeException("Incompatible formatVersion: " + formatVersion);
            }
            JsonObject jsonObject2 = this.repoJson;
            if (jsonObject2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"repoJson");
                jsonObject2 = null;
            }
            if ((minBuild = JsonUtil.optLong(jsonObject2, "minimal_mod_build", 51L)) > 51L) {
                throw new RuntimeException("Incompatible DynamicPack Mod version: required " + minBuild + ", current=51");
            }
            JsonObject jsonObject3 = this.repoJson;
            if (jsonObject3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"repoJson");
                jsonObject3 = null;
            }
            if (!InputValidator.isDynamicPackNameValid(remoteName = JsonUtil.getString(jsonObject3, "name"))) {
                throw new RuntimeException("Remote name not valid");
            }
            PackUtil.openPackFileSystem$default(this.pack.getLocation(), null, arg_0 -> DynamicRepoSyncBuilder.init$lambda$0(this, arg_0), 2, null);
            try {
                JsonObject jsonObject4 = this.repoJson;
                if (jsonObject4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"repoJson");
                    jsonObject4 = null;
                }
                JsonArray jsonArray = jsonObject4.getAsJsonArray("contents");
                Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"getAsJsonArray(...)");
                this.checkContents(jsonArray);
                JsonObject jsonObject5 = this.repoJson;
                if (jsonObject5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"repoJson");
                    jsonObject5 = null;
                }
                this.remote.notifyNewRemoteJson(jsonObject5);
                Iterable $this$forEach$iv = this.calcActiveContents();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    JsonObject it = (JsonObject)element$iv;
                    boolean bl = false;
                    this.processContentInit(it);
                }
            }
            catch (Exception e) {
                this.doNotDeleteOldestFiles = true;
                throw e;
            }
        }
    }

    private final void checkContents(JsonArray contents) {
        Set ids = new LinkedHashSet();
        Iterator iterator = contents.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            JsonElement elem = (JsonElement)iterator2.next();
            JsonObject obj = elem.getAsJsonObject();
            Intrinsics.checkNotNull((Object)obj);
            String id = JsonUtil.getString(obj, "id");
            InputValidator.throwIsContentIdInvalid(id);
            if (ids.add(id)) continue;
            throw new RuntimeException("Duplicate content found: " + id);
        }
    }

    @Override
    public long getDownloadedSize() {
        return this._downloadedSize;
    }

    @Override
    public boolean doUpdate(@NotNull SyncProgress progress) {
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        progress.setPhase("Opening a pack file-system");
        PackUtil.openPackFileSystem(this.pack.getLocation(), LockUtils.createFileFinalizer(this.pack.getLocation()), (Function1<? super Path, Unit>)((Function1)arg_0 -> DynamicRepoSyncBuilder.doUpdate$lambda$0(this, progress, arg_0)));
        progress.setPhase("Success");
        return this.reloadRequired;
    }

    @Override
    public void interrupt() {
        this.interrupted = true;
    }

    @Override
    public boolean isUpdateAvailable() {
        return this.updateAvailable;
    }

    @Override
    public long getUpdateSize() {
        return this._updateSize;
    }

    private final void processContentInit(JsonObject jsonContent) {
        String content;
        String string;
        String id = JsonUtil.getString(jsonContent, "id");
        InputValidator.throwIsContentIdInvalid(id);
        Object url = JsonUtil.getString(jsonContent, "url");
        Object urlCompressed = JsonUtil.optString(jsonContent, "url_compressed", null);
        boolean compressSupported = urlCompressed != null;
        Companion.checkPathSafety((String)url);
        String hash = JsonUtil.getString(jsonContent, "hash");
        url = this.remote.getUrl() + "/" + (String)url;
        if (compressSupported) {
            Companion.checkPathSafety((String)urlCompressed);
            urlCompressed = this.remote.getUrl() + "/" + (String)urlCompressed;
        }
        if (compressSupported) {
            String string2 = urlCompressed;
            Intrinsics.checkNotNull((Object)string2);
            string = Urls.parseTextGZippedContent(string2, Constants.INSTANCE.getGZIP_LIMIT(), null);
        } else {
            string = Urls.parseTextContent((String)url, Constants.INSTANCE.getMOD_FILES_LIMIT(), null);
        }
        if (string == null) {
            throw new RuntimeException("Can't load content " + (String)url);
        }
        String string3 = content = string;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string3.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        String receivedHash = Hashes.sha1sum(byArray);
        if (!Intrinsics.areEqual((Object)hash, (Object)receivedHash)) {
            throw new SecurityException("Hash mismatch for content " + (String)url);
        }
        JsonObject jsonContentD2 = JsonUtil.fromString(content);
        PackUtil.openPackFileSystem(this.remote.getParent().getLocation(), LockUtils.createFileFinalizer(this.pack.getLocation()), (Function1<? super Path, Unit>)((Function1)arg_0 -> DynamicRepoSyncBuilder.processContentInit$lambda$0(jsonContentD2, this, id, arg_0)));
    }

    private final void internalProcessDynamicFiles(SyncProgress progress, Path packFs) {
        Path path;
        this.debug("internalProcessDynamicFiles begin");
        NetworkStat.speedMultiplier = DOWNLOAD_THREADS_COUNT;
        if (this.pack.isZip()) {
            Path tmp = new File(System.getProperty("java.io.tmpdir") + File.separator + "dynamicpack_f02ffd55_cd44_458a_8d58_e31b11313a53", this.pack.getName()).toPath();
            if (!Files.exists(tmp, new LinkOption[0])) {
                PathUtil.createDirsToFile(tmp);
                Files.createDirectory(tmp, new FileAttribute[0]);
            }
            path = tmp;
        } else {
            path = null;
        }
        Path tempPath = path;
        ExecutorService executor = this.getExecutor();
        ((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> DynamicRepoSyncBuilder.internalProcessDynamicFiles$lambda$0(this), executor).thenCompose(arg_0 -> DynamicRepoSyncBuilder.internalProcessDynamicFiles$lambda$2(arg_0 -> DynamicRepoSyncBuilder.internalProcessDynamicFiles$lambda$1(executor, this, tempPath, packFs, progress, arg_0), arg_0))).whenComplete((arg_0, arg_1) -> DynamicRepoSyncBuilder.internalProcessDynamicFiles$lambda$4((arg_0, arg_1) -> DynamicRepoSyncBuilder.internalProcessDynamicFiles$lambda$3(this, tempPath, packFs, arg_0, arg_1), arg_0, arg_1))).join();
        NetworkStat.speedMultiplier = 1L;
        this.debug("internalProcessDynamicFiles end");
    }

    private final void downloadFile(Path rootPath, DynamicFile dynamicFile, SyncProgress progress) {
        Path filePath = rootPath.resolve(dynamicFile.getPath());
        if (StringsKt.contains$default((CharSequence)((Object)filePath.getFileName()).toString(), (CharSequence)"dynamicmcpack.json", (boolean)false, (int)2, null)) {
            this.warn("File dynamicmcpack.json can't be updated remotely!");
            return;
        }
        if (PathUtil.isPathFileExists(filePath)) {
            Intrinsics.checkNotNull((Object)filePath);
            if (StringsKt.equals((String)Hashes.sha1sum(filePath), (String)dynamicFile.getHash(), (boolean)true)) {
                this.warn("File " + dynamicFile.getPath() + " skipped: already exists with same hash");
                dynamicFile.setDownloadedPath(filePath);
                this._downloadedSize += Files.size(filePath);
                return;
            }
        }
        PackUtil.downloadPackFile(dynamicFile.getUrl(), filePath, dynamicFile.getHash(), new UrlsController(progress, filePath, this){
            private long fileSize;
            final /* synthetic */ SyncProgress $progress;
            final /* synthetic */ Path $filePath;
            final /* synthetic */ DynamicRepoSyncBuilder this$0;
            {
                this.$progress = $progress;
                this.$filePath = $filePath;
                this.this$0 = $receiver;
            }

            public void onUpdate(UrlsController it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$progress.downloading(((Object)this.$filePath.getFileName()).toString(), it.getPercentage());
                DynamicRepoSyncBuilder.access$set_downloadedSize$p(this.this$0, DynamicRepoSyncBuilder.access$get_downloadedSize$p(this.this$0) - this.fileSize);
                this.fileSize = it.getLatest();
                DynamicRepoSyncBuilder.access$set_downloadedSize$p(this.this$0, DynamicRepoSyncBuilder.access$get_downloadedSize$p(this.this$0) + this.fileSize);
            }

            public boolean isInterrupted() {
                return DynamicRepoSyncBuilder.access$getInterrupted$p(this.this$0);
            }
        });
        if (this.interrupted) {
            progress.setPhase("Interrupted");
            return;
        }
        dynamicFile.setDownloadedPath(filePath);
        progress.setPhase("File " + dynamicFile.getPath() + " downloaded!");
    }

    private final ExecutorService getExecutor() {
        int n = executorCounter;
        executorCounter = n + 1;
        int execNum = n;
        ExecutorService executorService = Executors.newFixedThreadPool(DOWNLOAD_THREADS_COUNT, new ThreadFactory(execNum){
            private int count;
            final /* synthetic */ int $execNum;
            {
                this.$execNum = $execNum;
                this.count = 1;
            }

            public Thread newThread(Runnable r) {
                Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                int n = this.count;
                this.count = n + 1;
                return new Thread(r, "DownloadWorker" + this.$execNum + "-" + n);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newFixedThreadPool(...)");
        return executorService;
    }

    private final String getUrlFromPathAndCheck(String remoteParent, String path) {
        Companion.checkPathSafety(remoteParent);
        return ((CharSequence)remoteParent).length() == 0 ? this.remote.getUrl() + "/" + path : this.remote.getUrl() + "/" + remoteParent + "/" + path;
    }

    private final List<JsonObject> calcActiveContents() {
        List active = new ArrayList();
        JsonObject jsonObject = this.repoJson;
        if (jsonObject == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repoJson");
            jsonObject = null;
        }
        JsonArray arr = jsonObject.getAsJsonArray("contents");
        Iterator iterator = arr.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            JsonElement content = (JsonElement)iterator2.next();
            JsonObject obj = content.getAsJsonObject();
            Intrinsics.checkNotNull((Object)obj);
            String id = JsonUtil.getString(obj, "id");
            InputValidator.throwIsContentIdInvalid(id);
            boolean defaultActive = JsonUtil.optBoolean(obj, "default_active", true);
            boolean required = JsonUtil.optBoolean(obj, "required", false);
            if (!required && !this.remote.getPreferences().isContentActive(id, defaultActive)) continue;
            active.add(obj);
        }
        return active;
    }

    public final boolean isReloadRequired() {
        return this.reloadRequired;
    }

    private final void markReloadRequired(Object obj) {
        if (!this.reloadRequired) {
            this.debug("Now reload is required because " + obj);
        }
        this.reloadRequired = true;
    }

    private final void debug(String s) {
        this.pack.debug(s);
    }

    private final void error(String s, Throwable e) {
        this.pack.error(s, e);
    }

    private final void warn(String s) {
        this.pack.warn(s);
    }

    private final void println(String s) {
        this.pack.println(s);
    }

    private static final Unit init$lambda$0(DynamicRepoSyncBuilder this$0, Path fs) {
        Intrinsics.checkNotNullParameter((Object)fs, (String)"fs");
        PathUtil.walkScan(this$0.oldestFilesList, fs);
        return Unit.INSTANCE;
    }

    private static final Unit doUpdate$lambda$0(DynamicRepoSyncBuilder this$0, SyncProgress $progress, Path packFs) {
        Intrinsics.checkNotNullParameter((Object)packFs, (String)"packFs");
        this$0.internalProcessDynamicFiles($progress, packFs);
        if (!this$0.doNotDeleteOldestFiles && !this$0.interrupted) {
            $progress.setPhase("Deleting unnecessary files");
            Iterable $this$forEach$iv = this$0.oldestFilesList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String s = (String)element$iv;
                boolean bl = false;
                Path pathToFile = packFs.resolve(s);
                if (StringsKt.equals((String)((Object)pathToFile.getFileName()).toString(), (String)"dynamicmcpack.json", (boolean)true)) continue;
                Intrinsics.checkNotNull((Object)pathToFile);
                $progress.deleted(pathToFile);
                PathUtil.nioSmartDelete(pathToFile);
                this$0.markReloadRequired(s);
            }
        }
        $progress.setPhase("Updating metadata...");
        JsonObject jsonObject = this$0.pack.getPackJson().getAsJsonObject("current");
        JsonObject jsonObject2 = this$0.repoJson;
        if (jsonObject2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repoJson");
            jsonObject2 = null;
        }
        jsonObject.addProperty("build", (Number)JsonUtil.getLong(jsonObject2, "build"));
        this$0.pack.updateJsonLatestUpdate();
        this$0.pack.saveClientFile(packFs);
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private static final Unit processContentInit$lambda$0(JsonObject $jsonContentD2, DynamicRepoSyncBuilder this$0, String $id, Path packFs) {
        Intrinsics.checkNotNullParameter((Object)packFs, (String)"packFs");
        formatVersion = JsonUtil.getLong($jsonContentD2, "formatVersion");
        if (formatVersion != 1L) {
            throw new RuntimeException("Incompatible formatVersion=" + formatVersion);
        }
        c = $jsonContentD2.getAsJsonObject("content");
        Intrinsics.checkNotNull((Object)c);
        v0 = JsonUtil.optString(c, "parent", "");
        if (v0 == null) {
            v0 = parentPath = "";
        }
        if ((v1 = JsonUtil.optString(c, "remote_parent", "")) == null) {
            v1 = "";
        }
        rem = v1;
        files = c.getAsJsonObject("files");
        processedFiles = 0;
        for (String fileEntry : files.keySet()) {
            if (this$0.interrupted) {
                return Unit.INSTANCE;
            }
            pathValidated = false;
            try {
                Intrinsics.checkNotNull((Object)fileEntry);
                relPath = DynamicRepoSyncBuilder.Companion.getAndCheckPath(parentPath, fileEntry);
                InputValidator.throwIsPathInvalid(relPath);
                pathValidated = true;
                filePath = packFs.resolve(relPath);
                if (StringsKt.contains$default((CharSequence)filePath.getFileName().toString(), (CharSequence)"dynamicmcpack.json", (boolean)false, (int)2, null)) {
                    this$0.warn("File dynamicmcpack.json can't be updated remotely!");
                    continue;
                }
                fileRemoteUrl = this$0.getUrlFromPathAndCheck(rem, relPath);
                fileExtra = files.getAsJsonObject(fileEntry);
                Intrinsics.checkNotNull((Object)fileExtra);
                fileHash = JsonUtil.getString(fileExtra, "hash");
                fileSize = JsonUtil.optInt(fileExtra, "size", 0x7FFFFFFF);
                if (!InputValidator.isHashValid(fileHash)) {
                    this$0.warn("Hash not valid for file: " + relPath);
                    continue;
                }
                this$0.oldestFilesList.remove(relPath);
                if (!Files.exists(filePath, new LinkOption[0])) ** GOTO lbl-1000
                Intrinsics.checkNotNull((Object)filePath);
                if (!Intrinsics.areEqual((Object)Hashes.sha1sum(filePath), (Object)fileHash)) lbl-1000:
                // 2 sources

                {
                    v2 = true;
                } else {
                    v2 = isNeedOverwrite = false;
                }
                if (this$0.dynamicFiles.containsKey(relPath)) {
                    this$0.warn("File duplicates across contents: " + relPath);
                    v3 = this$0._updateSize;
                    v4 = this$0.dynamicFiles.get(relPath);
                    Intrinsics.checkNotNull((Object)v4);
                    this$0._updateSize = v3 - (long)v4.getSize();
                    isNeedOverwrite = true;
                }
                if (isNeedOverwrite) {
                    dyn = new DynamicFile(fileRemoteUrl, relPath, fileSize, fileHash, null, 16, null);
                    this$0._updateSize += (long)fileSize;
                    this$0.dynamicFiles.put(relPath, dyn);
                }
                ++processedFiles;
            }
            catch (Exception e) {
                errorFile = pathValidated != false ? fileEntry : "(failed to validate)";
                this$0.error("Error while process file " + errorFile, e);
            }
        }
        this$0.println("Total initialized files in content '" + $id + "': " + processedFiles);
        return Unit.INSTANCE;
    }

    private static final Collection internalProcessDynamicFiles$lambda$0(DynamicRepoSyncBuilder this$0) {
        return this$0.dynamicFiles.values();
    }

    /*
     * WARNING - void declaration
     */
    private static final CompletionStage internalProcessDynamicFiles$lambda$1(ExecutorService $executor, DynamicRepoSyncBuilder this$0, Path $tempPath, Path $packFs, SyncProgress $progress, Collection files) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNull((Object)files);
        Iterable $this$map$iv = files;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void file;
            DynamicFile dynamicFile = (DynamicFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(CompletableFuture.supplyAsync(() -> DynamicRepoSyncBuilder.internalProcessDynamicFiles$lambda$1$0$0(this$0, $tempPath, $packFs, (DynamicFile)file, $progress), $executor).exceptionally(arg_0 -> DynamicRepoSyncBuilder.internalProcessDynamicFiles$lambda$1$0$1(this$0, arg_0)));
        }
        List futs = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = futs;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        CompletableFuture[] completableFutureArray = thisCollection$iv.toArray(new CompletableFuture[0]);
        return CompletableFuture.allOf(Arrays.copyOf(completableFutureArray, completableFutureArray.length)).thenApply(arg_0 -> DynamicRepoSyncBuilder.internalProcessDynamicFiles$lambda$1$2(arg_0 -> DynamicRepoSyncBuilder.internalProcessDynamicFiles$lambda$1$1(futs, arg_0), arg_0));
    }

    private static final DynamicFile internalProcessDynamicFiles$lambda$1$0$0(DynamicRepoSyncBuilder this$0, Path $tempPath, Path $packFs, DynamicFile $file, SyncProgress $progress) {
        if (this$0.interrupted) {
            throw new InterruptedException("Interrupted");
        }
        Path path = $tempPath;
        if (path == null) {
            path = $packFs;
        }
        this$0.downloadFile(path, $file, $progress);
        return $file;
    }

    private static final DynamicFile internalProcessDynamicFiles$lambda$1$0$1(DynamicRepoSyncBuilder this$0, Throwable it) {
        Intrinsics.checkNotNull((Object)it);
        this$0.error("Error while download a file", it);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static final List internalProcessDynamicFiles$lambda$1$1(List $futs, Void it) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = $futs;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            DynamicFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            CompletableFuture it2 = (CompletableFuture)element$iv$iv;
            boolean bl2 = false;
            if ((DynamicFile)it2.join() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final List internalProcessDynamicFiles$lambda$1$2(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final CompletionStage internalProcessDynamicFiles$lambda$2(Function1 $tmp0, Object p0) {
        return (CompletionStage)$tmp0.invoke(p0);
    }

    private static final Unit internalProcessDynamicFiles$lambda$3(DynamicRepoSyncBuilder this$0, Path $tempPath, Path $packFs, List files, Throwable th) {
        if (this$0.interrupted) {
            return Unit.INSTANCE;
        }
        if (th == null) {
            Intrinsics.checkNotNull((Object)files);
            Iterable $this$forEach$iv = files;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DynamicFile file = (DynamicFile)element$iv;
                boolean bl = false;
                if (file.getDownloadedPath() == null) {
                    this$0.warn("Downloaded file with null path: " + file);
                    continue;
                }
                this$0.markReloadRequired(file);
                if ($tempPath == null) continue;
                try {
                    Path src;
                    Path dest = $packFs.resolve(file.getPath());
                    Intrinsics.checkNotNull((Object)file.getDownloadedPath());
                    PathUtil.createDirsToFile(dest);
                    CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                    Files.move(src, dest, copyOptionArray);
                    PathUtil.nioSmartDelete(src);
                }
                catch (Exception e) {
                    this$0.error("Error while moving file " + file.getPath(), e);
                }
            }
        } else {
            throw new RuntimeException(th);
        }
        return Unit.INSTANCE;
    }

    private static final void internalProcessDynamicFiles$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    @JvmStatic
    @NotNull
    public static final String getAndCheckPath(@NotNull String parent, @NotNull String path) {
        return Companion.getAndCheckPath(parent, path);
    }

    @JvmStatic
    public static final void checkPathSafety(@NotNull String s) {
        Companion.checkPathSafety(s);
    }

    public static final /* synthetic */ boolean access$getInterrupted$p(DynamicRepoSyncBuilder $this) {
        return $this.interrupted;
    }

    public static final /* synthetic */ void access$set_downloadedSize$p(DynamicRepoSyncBuilder $this, long l) {
        $this._downloadedSize = l;
    }

    public static final /* synthetic */ long access$get_downloadedSize$p(DynamicRepoSyncBuilder $this) {
        return $this._downloadedSize;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u000b\u0010\fR\"\u0010\u000e\u001a\u00020\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lcom/calculatorsteam/dynamicpack/pack/dynamicrepo/DynamicRepoSyncBuilder$Companion;", "", "<init>", "()V", "", "parent", "path", "getAndCheckPath", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "s", "", "checkPathSafety", "(Ljava/lang/String;)V", "", "DOWNLOAD_THREADS_COUNT", "I", "getDOWNLOAD_THREADS_COUNT", "()I", "setDOWNLOAD_THREADS_COUNT", "(I)V", "executorCounter", "dynamicpack"})
    @SourceDebugExtension(value={"SMAP\nDynamicRepoSyncBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DynamicRepoSyncBuilder.kt\ncom/calculatorsteam/dynamicpack/pack/dynamicrepo/DynamicRepoSyncBuilder$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,378:1\n12970#2,2:379\n*S KotlinDebug\n*F\n+ 1 DynamicRepoSyncBuilder.kt\ncom/calculatorsteam/dynamicpack/pack/dynamicrepo/DynamicRepoSyncBuilder$Companion\n*L\n345#1:379,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final int getDOWNLOAD_THREADS_COUNT() {
            return DOWNLOAD_THREADS_COUNT;
        }

        public final void setDOWNLOAD_THREADS_COUNT(int n) {
            DOWNLOAD_THREADS_COUNT = n;
        }

        @JvmStatic
        @NotNull
        public final String getAndCheckPath(@NotNull String parent, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.checkPathSafety(path);
            this.checkPathSafety(parent);
            return ((CharSequence)parent).length() == 0 ? path : parent + "/" + path;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final void checkPathSafety(@NotNull String s) {
            boolean bl;
            block2: {
                void $this$any$iv;
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                String[] stringArray = new String[]{"://", "..", "  ", ".exe", ":", ".jar"};
                boolean $i$f$any = false;
                int n = ((void)$this$any$iv).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv;
                    void it = element$iv = $this$any$iv[i];
                    boolean bl2 = false;
                    if (!StringsKt.contains$default((CharSequence)s, (CharSequence)((CharSequence)it), (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            if (bl) {
                throw new SecurityException("This path not safe: " + s);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

