/*
 * Decompiled with CFR 0.152.
 */
package com.calculatorsteam.dynamicpack.util;

import com.calculatorsteam.dynamicpack.Constants;
import com.calculatorsteam.dynamicpack.util.PathUtil;
import com.calculatorsteam.dynamicpack.util.Urls;
import com.calculatorsteam.dynamicpack.util.UrlsController;
import com.calculatorsteam.dynamicpack.util.exception.FailedOpenPackFileSystemException;
import com.calculatorsteam.dynamicpack.util.log.FileLog;
import com.calculatorsteam.dynamicpack.util.log.Out;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J9\u0010\f\u001a\u00020\n2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0007\u00a2\u0006\u0004\b\f\u0010\rJ1\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/calculatorsteam/dynamicpack/util/PackUtil;", "", "<init>", "()V", "Ljava/io/File;", "file", "Ljava/lang/Runnable;", "preClose", "Lkotlin/Function1;", "Ljava/nio/file/Path;", "", "consumer", "openPackFileSystem", "(Ljava/io/File;Ljava/lang/Runnable;Lkotlin/jvm/functions/Function1;)V", "", "url", "path", "hash", "Lcom/calculatorsteam/dynamicpack/util/UrlsController;", "controller", "downloadPackFile", "(Ljava/lang/String;Ljava/nio/file/Path;Ljava/lang/String;Lcom/calculatorsteam/dynamicpack/util/UrlsController;)V", "dynamicpack"})
public final class PackUtil {
    @NotNull
    public static final PackUtil INSTANCE = new PackUtil();

    private PackUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final void openPackFileSystem(@Nullable File file, @Nullable Runnable preClose, @NotNull Function1<? super Path, Unit> consumer) throws Exception {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        File file2 = file;
        if (file2 == null) {
            throw new FileNotFoundException("File is null");
        }
        File realFile = file2;
        if (!realFile.exists()) {
            throw new FileNotFoundException(realFile.getCanonicalPath());
        }
        if (realFile.isDirectory()) {
            Path path = realFile.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            consumer.invoke((Object)path);
            return;
        }
        if (!realFile.isFile()) throw new FailedOpenPackFileSystemException("Failed to recognize pack filesystem: not dir or zip", null, false, false, 14, null);
        String string = realFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        if (!StringsKt.endsWith$default((String)string2, (String)".zip", (boolean)false, (int)2, null)) throw new FailedOpenPackFileSystemException("Failed to recognize pack filesystem: not dir or zip", null, false, false, 14, null);
        Map env = MapsKt.mapOf((Pair)TuplesKt.to((Object)"create", (Object)"true"));
        URI uri = URI.create("jar:" + realFile.toPath().toUri());
        Exception caught = null;
        Closeable closeable = FileSystems.newFileSystem(uri, env);
        Throwable throwable = null;
        try {
            FileSystem fs = (FileSystem)closeable;
            boolean bl = false;
            try {
                Path path = fs.getPath("", new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
                consumer.invoke((Object)path);
            }
            catch (Exception e) {
                caught = e;
            }
            finally {
                Runnable runnable = preClose;
                if (runnable != null) {
                    runnable.run();
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Exception exception = caught;
        if (exception == null) return;
        throw (Throwable)exception;
    }

    public static /* synthetic */ void openPackFileSystem$default(File file, Runnable runnable, Function1 function1, int n, Object object) throws Exception {
        if ((n & 2) != 0) {
            runnable = null;
        }
        PackUtil.openPackFileSystem(file, runnable, (Function1<? super Path, Unit>)function1);
    }

    @JvmStatic
    public static final void downloadPackFile(@NotNull String url, @Nullable Path path, @NotNull String hash, @NotNull UrlsController controller) throws IOException {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Path path2 = path;
        if (path2 == null) {
            throw new IOException("Path is null");
        }
        Path target = path2;
        int maxAttempts = 3;
        int n = 0;
        while (n < maxAttempts) {
            int attempt = n++;
            boolean bl = false;
            try {
                PathUtil.createDirsToFile(target);
                if (Files.exists(target, new LinkOption[0])) {
                    PathUtil.delete(target);
                }
                PathUtil.createFile(target);
                try {
                    InputStream inputStream = Urls.INSTANCE._getInputStreamOfUrl$dynamicpack(url, Constants.INSTANCE.getDYNAMIC_PACK_HTTPS_FILE_SIZE_LIMIT(), controller);
                    OutputStream outputStream = Files.newOutputStream(target, new OpenOption[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
                    Urls.INSTANCE._transferStreamsWithHash$dynamicpack(hash, inputStream, outputStream, controller);
                    FileLog.INSTANCE.writtenByUrl(target, url);
                }
                catch (Exception e) {
                    throw new RuntimeException("File " + target + " download error. From url: " + url + ". Expected hash: " + hash, e);
                }
                return;
            }
            catch (Exception e) {
                Out.error("downloadPackFile. Attempt=" + (attempt + 1) + "/" + maxAttempts, e);
                if (attempt != maxAttempts - 1) continue;
                throw e;
            }
        }
    }
}

