/*
 * Decompiled with CFR 0.152.
 */
package com.calculatorsteam.dynamicpack.util;

import com.calculatorsteam.dynamicpack.util.PackUtil;
import com.calculatorsteam.dynamicpack.util.log.FileLog;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0007\u001a\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\t\u001a\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0004\b\t\u0010\bJ!\u0010\r\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ#\u0010\u0011\u001a\u00020\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\nH\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J#\u0010\u0015\u001a\u00020\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\nH\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0012J\u0019\u0010\u0016\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0019\u0010\u0019\u001a\u00020\u00182\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0019\u0010\u001c\u001a\u00020\u00062\b\u0010\u001b\u001a\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0004\b\u001c\u0010\bJ!\u0010\u001f\u001a\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001e\u001a\u00020\u001dH\u0007\u00a2\u0006\u0004\b\u001f\u0010 J\u0019\u0010!\u001a\u00020\u001d2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0004\b!\u0010\"J\u0019\u0010#\u001a\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0004\b#\u0010\bJ'\u0010&\u001a\u00020\u00062\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001d0$2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0004\b&\u0010'J\u0019\u0010(\u001a\u00020\u00182\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0004\b(\u0010\u001aJ\u0017\u0010+\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020)H\u0007\u00a2\u0006\u0004\b+\u0010,J\u0019\u0010+\u001a\u00020\u001d2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0004\b+\u0010\"\u00a8\u0006-"}, d2={"Lcom/calculatorsteam/dynamicpack/util/PathUtil;", "", "<init>", "()V", "Ljava/nio/file/Path;", "path", "", "delete", "(Ljava/nio/file/Path;)V", "createFile", "Ljava/io/File;", "file", "", "listFiles", "(Ljava/io/File;)[Ljava/io/File;", "source", "dest", "moveFile", "(Ljava/io/File;Ljava/io/File;)V", "zipFilePath", "dir", "unzip", "recursiveDeleteDirectory", "(Ljava/io/File;)V", "", "nioIsDirExistsAndEmpty", "(Ljava/nio/file/Path;)Z", "toDel", "nioSmartDelete", "", "text", "nioWriteText", "(Ljava/nio/file/Path;Ljava/lang/String;)V", "nioReadText", "(Ljava/nio/file/Path;)Ljava/lang/String;", "createDirsToFile", "", "buffer", "walkScan", "(Ljava/util/Set;Ljava/nio/file/Path;)V", "isPathFileExists", "Ljava/io/InputStream;", "inputStream", "readString", "(Ljava/io/InputStream;)Ljava/lang/String;", "dynamicpack"})
@SourceDebugExtension(value={"SMAP\nPathUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathUtil.kt\ncom/calculatorsteam/dynamicpack/util/PathUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,174:1\n1#2:175\n1869#3,2:176\n*S KotlinDebug\n*F\n+ 1 PathUtil.kt\ncom/calculatorsteam/dynamicpack/util/PathUtil\n*L\n58#1:176,2\n*E\n"})
public final class PathUtil {
    @NotNull
    public static final PathUtil INSTANCE = new PathUtil();

    private PathUtil() {
    }

    @JvmStatic
    public static final void delete(@Nullable Path path) throws IOException {
        Path path2 = path;
        if (path2 == null) {
            return;
        }
        Path p = path2;
        if (Files.exists(p, new LinkOption[0])) {
            Files.delete(p);
            FileLog.INSTANCE.deleted(p);
        }
    }

    @JvmStatic
    public static final void createFile(@Nullable Path path) throws IOException {
        Path path2 = path;
        if (path2 == null) {
            throw new IOException("Path is null");
        }
        Path p = path2;
        Files.createFile(p, new FileAttribute[0]);
        FileLog.INSTANCE.created(p);
    }

    @JvmStatic
    @Nullable
    public static final File[] listFiles(@Nullable File file) {
        File file2 = file;
        return file2 != null ? file2.listFiles() : null;
    }

    @JvmStatic
    public static final void moveFile(@Nullable File source, @Nullable File dest) throws IOException {
        File file = source;
        if (file == null) {
            throw new IOException("Source file is null");
        }
        File s = file;
        File file2 = dest;
        if (file2 == null) {
            throw new IOException("Destination file is null");
        }
        File d = file2;
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Files.move(s.toPath(), d.toPath(), copyOptionArray);
    }

    @JvmStatic
    public static final void unzip(@Nullable File zipFilePath, @Nullable File dir) throws Exception {
        File file = zipFilePath;
        if (file == null) {
            throw new IOException("Zip file is null");
        }
        File z = file;
        File file2 = dir;
        if (file2 == null) {
            throw new IOException("Destination dir is null");
        }
        File d = file2;
        PackUtil.openPackFileSystem$default(z, null, arg_0 -> PathUtil.unzip$lambda$0(d, arg_0), 2, null);
    }

    @JvmStatic
    public static final void recursiveDeleteDirectory(@Nullable File file) {
        File file2 = file;
        if (file2 == null) {
            return;
        }
        File f = file2;
        try {
            if (!f.isDirectory()) {
                throw new RuntimeException("File not a directory.");
            }
            FileUtils.deleteDirectory((File)f);
            Path path = f.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            FileLog.INSTANCE.deleted(path);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while recursive delete dir " + f, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean nioIsDirExistsAndEmpty(Path path) {
        Path path2 = path;
        if (path2 == null) {
            return false;
        }
        Path p = path2;
        if (Files.isDirectory(p, new LinkOption[0])) {
            AutoCloseable autoCloseable = Files.list(p);
            Throwable throwable = null;
            try {
                Stream it = (Stream)autoCloseable;
                boolean bl = false;
                boolean bl2 = it.count() == 0L;
                return bl2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        return false;
    }

    @JvmStatic
    public static final void nioSmartDelete(@Nullable Path toDel) throws IOException {
        Path path = toDel;
        if (path == null) {
            return;
        }
        Path p = path;
        FileLog.INSTANCE.deleted(p);
        Path par = p.getParent();
        Files.deleteIfExists(p);
        if (par != null && INSTANCE.nioIsDirExistsAndEmpty(par)) {
            PathUtil.nioSmartDelete(par);
        }
    }

    @JvmStatic
    public static final void nioWriteText(@Nullable Path path, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Path path2 = path;
        if (path2 == null) {
            throw new IOException("Path is null");
        }
        Path p = path2;
        try {
            if (Files.exists(p, new LinkOption[0]) && !Files.isRegularFile(p, new LinkOption[0])) {
                throw new SecurityException("Try to write text to a not regular file.");
            }
            Files.deleteIfExists(p);
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE};
            Files.writeString(p, (CharSequence)text, openOptionArray);
        }
        catch (IOException e) {
            throw new RuntimeException("nioWriteText exception!", e);
        }
    }

    @JvmStatic
    @NotNull
    public static final String nioReadText(@Nullable Path path) {
        Path path2 = path;
        if (path2 == null) {
            throw new IOException("Path is null");
        }
        Path p = path2;
        try {
            if (!Files.exists(p, new LinkOption[0]) || Files.isDirectory(p, new LinkOption[0])) {
                throw new RuntimeException("This is not a file. Not found or directory.");
            }
            String string = Files.readString(p);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("nioReadText exception!", e);
        }
    }

    @JvmStatic
    public static final void createDirsToFile(@Nullable Path path) throws IOException {
        Path path2 = path;
        if (path2 == null) {
            return;
        }
        Path p = path2;
        Path par = p.getParent();
        if (par != null && !Files.exists(par, new LinkOption[0])) {
            Files.createDirectories(par, new FileAttribute[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void walkScan(@NotNull Set<String> buffer, @Nullable Path path) {
        Intrinsics.checkNotNullParameter(buffer, (String)"buffer");
        Path path2 = path;
        if (path2 == null) {
            return;
        }
        Path p = path2;
        try {
            AutoCloseable autoCloseable = Files.walk(p, Integer.MAX_VALUE, new FileVisitOption[0]);
            Throwable throwable = null;
            try {
                Stream entries = (Stream)autoCloseable;
                boolean bl = false;
                entries.forEach(arg_0 -> PathUtil.walkScan$lambda$0$1(arg_0 -> PathUtil.walkScan$lambda$0$0(buffer, p, arg_0), arg_0));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while walkScan", e);
        }
    }

    @JvmStatic
    public static final boolean isPathFileExists(@Nullable Path path) {
        return path != null && Files.exists(path, new LinkOption[0]) && !Files.isDirectory(path, new LinkOption[0]);
    }

    @JvmStatic
    @NotNull
    public static final String readString(@NotNull InputStream inputStream) throws IOException {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        byte[] byArray = inputStream.readAllBytes();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
        byte[] byArray2 = byArray;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        return new String(byArray2, charset2);
    }

    @JvmStatic
    @NotNull
    public static final String readString(@Nullable Path path) throws IOException {
        Path path2 = path;
        if (path2 == null) {
            throw new IOException("Path is null");
        }
        Path p = path2;
        String string = Files.readString(p, StandardCharsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
        return string;
    }

    private static final Unit unzip$lambda$0(File $d, Path zip) {
        Intrinsics.checkNotNullParameter((Object)zip, (String)"zip");
        Set buffer = new LinkedHashSet();
        PathUtil.walkScan(buffer, zip);
        Iterable $this$forEach$iv = buffer;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String relative = (String)element$iv;
            boolean bl = false;
            Path path = zip.resolve(relative);
            Path toPath = $d.toPath().resolve(relative);
            PathUtil.createDirsToFile(toPath);
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            Files.copy(path, toPath, copyOptionArray);
        }
        return Unit.INSTANCE;
    }

    private static final Unit walkScan$lambda$0$0(Set $buffer, Path $p, Path child) {
        if (!Files.isDirectory(child, new LinkOption[0])) {
            $buffer.add(((Object)$p.relativize(child)).toString());
        }
        return Unit.INSTANCE;
    }

    private static final void walkScan$lambda$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

