/*
 * Decompiled with CFR 0.152.
 */
package com.calculatorsteam.dynamicpack.sync;

import com.calculatorsteam.dynamicpack.DynamicPackMod;
import com.calculatorsteam.dynamicpack.PacksContainer;
import com.calculatorsteam.dynamicpack.client.config.Config;
import com.calculatorsteam.dynamicpack.pack.DynamicResourcePack;
import com.calculatorsteam.dynamicpack.sync.SyncBuilder;
import com.calculatorsteam.dynamicpack.sync.SyncProgress;
import com.calculatorsteam.dynamicpack.util.log.Out;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0007H\u0007J\b\u0010\u0015\u001a\u00020\u0010H\u0007J\b\u0010\u0016\u001a\u00020\u0007H\u0007J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0005H\u0007J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\b\u0010\u0019\u001a\u00020\rH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u0004\u0018\u00010\r8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/calculatorsteam/dynamicpack/sync/SyncingTask;", "", "<init>", "()V", "isSyncing", "", "syncingLog1", "", "syncingLog2", "syncingLog3", "eta", "", "currentRootSyncBuilder", "Lcom/calculatorsteam/dynamicpack/sync/SyncBuilder;", "currentPackName", "launchTaskAsSyncing", "", "runnable", "Lkotlin/Function0;", "log", "s", "clearLog", "getLogs", "setSyncing", "syncing", "rootSyncBuilder", "dynamicpack"})
public final class SyncingTask {
    @NotNull
    public static final SyncingTask INSTANCE = new SyncingTask();
    private static boolean isSyncing;
    @NotNull
    private static String syncingLog1;
    @NotNull
    private static String syncingLog2;
    @NotNull
    private static String syncingLog3;
    @JvmField
    public static long eta;
    @JvmField
    @Nullable
    public static SyncBuilder currentRootSyncBuilder;
    @JvmField
    @Nullable
    public static String currentPackName;

    private SyncingTask() {
    }

    @JvmStatic
    public static final void launchTaskAsSyncing(@NotNull Function0<Unit> runnable) {
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        if (SyncingTask.isSyncing()) {
            throw new RuntimeException("Failed to launchTaskAsSyncing. Other task currently working...");
        }
        PacksContainer packs = DynamicPackMod.Companion.getPacksContainer();
        SyncingTask.setSyncing(true);
        packs.lockRescan();
        SyncingTask.log("[SyncingTask] launchTaskAsSyncing start!");
        runnable.invoke();
        SyncingTask.log("[SyncingTask] launchTaskAsSyncing end!");
        SyncingTask.setSyncing(false);
        packs.unlockRescan();
        currentPackName = null;
        currentRootSyncBuilder = null;
    }

    @JvmStatic
    public static final void log(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Out.INSTANCE.debug("[SyncingTask] log: " + s);
        syncingLog1 = syncingLog2;
        syncingLog2 = syncingLog3;
        syncingLog3 = s;
    }

    @JvmStatic
    public static final void clearLog() {
        syncingLog3 = "";
        syncingLog2 = "";
        syncingLog1 = "";
    }

    @JvmStatic
    @NotNull
    public static final String getLogs() {
        return syncingLog1 + "\n" + syncingLog2 + "\n" + syncingLog3;
    }

    @JvmStatic
    public static final void setSyncing(boolean syncing) {
        isSyncing = syncing;
    }

    @JvmStatic
    public static final boolean isSyncing() {
        return isSyncing;
    }

    @JvmStatic
    @NotNull
    public static final SyncBuilder rootSyncBuilder() {
        return new SyncBuilder(){
            private final Set<SyncBuilder> builders;
            private boolean updateAvailable;
            private long totalSize;
            private boolean interrupted;
            {
                this.builders = new LinkedHashSet<E>();
            }

            public void init(boolean ignoreCaches) throws Exception {
                SyncingTask.clearLog();
                for (DynamicResourcePack pack : DynamicPackMod.Companion.getPacksContainer().getPacksArray()) {
                    boolean enabled;
                    if (this.interrupted) {
                        return;
                    }
                    if (Config.Companion.getInstance().isUpdateOnlyEnabledPacks() && !(enabled = DynamicPackMod.Companion.isResourcePackActive(pack))) continue;
                    SyncBuilder builder = pack.syncBuilder();
                    builder.init(ignoreCaches);
                    ((Collection)this.builders).add(builder);
                    this.totalSize += builder.getUpdateSize();
                    if (!builder.isUpdateAvailable()) continue;
                    this.updateAvailable = true;
                }
                Out.INSTANCE.debug("[SyncingTask] rootSyncBuilder() totalSize=" + this.totalSize + " updateAvailable=" + this.updateAvailable);
            }

            public boolean isUpdateAvailable() {
                return this.updateAvailable;
            }

            public long getUpdateSize() {
                return this.totalSize;
            }

            /*
             * WARNING - void declaration
             */
            public long getDownloadedSize() {
                Iterable iterable = this.builders;
                long l = 0L;
                for (T t : iterable) {
                    void it;
                    SyncBuilder syncBuilder2 = (SyncBuilder)t;
                    long l2 = l;
                    boolean bl = false;
                    long l3 = it.getDownloadedSize();
                    l = l2 + l3;
                }
                return l;
            }

            public boolean doUpdate(SyncProgress progress) throws Exception {
                Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
                boolean reload = false;
                for (SyncBuilder syncBuilder2 : this.builders) {
                    boolean rel;
                    if (this.interrupted) {
                        return false;
                    }
                    if (!syncBuilder2.isUpdateAvailable() || !(rel = syncBuilder2.doUpdate(progress))) continue;
                    reload = true;
                }
                return reload;
            }

            public void interrupt() {
                this.interrupted = true;
                Iterable $this$forEach$iv = this.builders;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    SyncBuilder it = (SyncBuilder)element$iv;
                    boolean bl = false;
                    it.interrupt();
                }
            }
        };
    }

    static {
        syncingLog1 = "";
        syncingLog2 = "";
        syncingLog3 = "";
    }
}

