/*
 * Decompiled with CFR 0.152.
 */
package com.calculatorsteam.dynamicpack.util;

import com.calculatorsteam.dynamicpack.Constants;
import com.calculatorsteam.dynamicpack.DynamicPackMod;
import com.calculatorsteam.dynamicpack.InputValidator;
import com.calculatorsteam.dynamicpack.util.Hashes;
import com.calculatorsteam.dynamicpack.util.UrlsController;
import com.calculatorsteam.dynamicpack.util.log.NetworkStat;
import com.calculatorsteam.dynamicpack.util.log.Out;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.GZIPInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\b\u0010\u0006\u001a\u00020\u0005H\u0007J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0007J$\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0007J$\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0007J2\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0013\u001a\u0004\u0018\u00010\rH\u0007J'\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u000b2\b\u0010\u0013\u001a\u0004\u0018\u00010\rH\u0000\u00a2\u0006\u0002\b\u0017J\"\u0010\u0018\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u000b2\b\u0010\u0013\u001a\u0004\u0018\u00010\rH\u0002J!\u0010\u0019\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001a\u001a\u00020\u00152\b\u0010\u0013\u001a\u0004\u0018\u00010\rH\u0000\u00a2\u0006\u0002\b\u001bJ\"\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 2\b\u0010\u0013\u001a\u0004\u0018\u00010\rH\u0002J/\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 2\b\u0010\u0013\u001a\u0004\u0018\u00010\rH\u0000\u00a2\u0006\u0002\b#Jw\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u00152\u0006\u0010&\u001a\u00020'2\b\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010(\u001a\u00020\u00052K\u0010)\u001aG\u0012\u0013\u0012\u00110'\u00a2\u0006\f\b+\u0012\b\b,\u0012\u0004\b\b(-\u0012\u0013\u0012\u00110.\u00a2\u0006\f\b+\u0012\b\b,\u0012\u0004\b\b(/\u0012\u0013\u0012\u00110.\u00a2\u0006\f\b+\u0012\b\b,\u0012\u0004\b\b(0\u0012\u0004\u0012\u00020\u001d0*H\u0002J\u0010\u0010(\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u0015H\u0002J\u0010\u00102\u001a\u00020\u001d2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a8\u00063"}, d2={"Lcom/calculatorsteam/dynamicpack/util/Urls;", "", "<init>", "()V", "isFileDebugSchemeAllowed", "", "isHTTPTrafficAllowed", "parseTextContent", "", "url", "limit", "", "progress", "Lcom/calculatorsteam/dynamicpack/util/UrlsController;", "parseTextGZippedContent", "downloadFileToTemp", "Ljava/io/File;", "tmpPrefix", "tmpSuffix", "controller", "_getInputStreamOfUrl", "Ljava/io/InputStream;", "sizeLimit", "_getInputStreamOfUrl$dynamicpack", "__unsafeInputStreamFromUrl", "_parseTextFromStream", "stream", "_parseTextFromStream$dynamicpack", "_transferStreams", "", "inputStream", "outputStream", "Ljava/io/OutputStream;", "_transferStreamsWithHash", "hash", "_transferStreamsWithHash$dynamicpack", "readLoop", "input", "buf", "", "isNetwork", "onBytes", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "data", "", "offset", "length", "isrc", "throwIsUrlNotTrust", "dynamicpack"})
public final class Urls {
    @NotNull
    public static final Urls INSTANCE = new Urls();

    private Urls() {
    }

    @JvmStatic
    public static final boolean isFileDebugSchemeAllowed() {
        return Constants.INSTANCE.isFileDebugSchemeAllowed();
    }

    @JvmStatic
    public static final boolean isHTTPTrafficAllowed() {
        return Constants.INSTANCE.isHTTPTrafficAllowed();
    }

    @JvmStatic
    @Nullable
    public static final String parseTextContent(@NotNull String url, long limit) throws IOException {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return Urls.parseTextContent(url, limit, null);
    }

    @JvmStatic
    @Nullable
    public static final String parseTextContent(@NotNull String url, long limit, @Nullable UrlsController progress) throws IOException {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return INSTANCE._parseTextFromStream$dynamicpack(INSTANCE._getInputStreamOfUrl$dynamicpack(url, limit, progress), progress);
    }

    @JvmStatic
    @Nullable
    public static final String parseTextGZippedContent(@NotNull String url, long limit, @Nullable UrlsController progress) throws IOException {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return INSTANCE._parseTextFromStream$dynamicpack(new GZIPInputStream(INSTANCE._getInputStreamOfUrl$dynamicpack(url, limit, progress)), progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final File downloadFileToTemp(@NotNull String url, @NotNull String tmpPrefix, @NotNull String tmpSuffix, long limit, @Nullable UrlsController controller) throws IOException {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)tmpPrefix, (String)"tmpPrefix");
        Intrinsics.checkNotNullParameter((Object)tmpSuffix, (String)"tmpSuffix");
        File file = File.createTempFile(tmpPrefix, tmpSuffix);
        Closeable closeable = INSTANCE._getInputStreamOfUrl$dynamicpack(url, limit, controller);
        Throwable throwable = null;
        try {
            InputStream input = (InputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = Files.newOutputStream(file.toPath(), new OpenOption[0]);
            Throwable throwable2 = null;
            try {
                OutputStream output = (OutputStream)closeable2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)output);
                INSTANCE._transferStreams(input, output, controller);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNull((Object)file);
        return file;
    }

    @NotNull
    public final InputStream _getInputStreamOfUrl$dynamicpack(@NotNull String url, long sizeLimit, @Nullable UrlsController controller) throws IOException {
        InputStream inputStream;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (StringsKt.contains$default((CharSequence)url, (CharSequence)" ", (boolean)false, (int)2, null)) {
            throw new IOException("URL can't contain spaces!");
        }
        InputValidator.throwIsUrlInvalid(url);
        if (StringsKt.startsWith$default((String)url, (String)"file_debug_only://", (boolean)false, (int)2, null)) {
            if (!Urls.isFileDebugSchemeAllowed()) {
                throw new RuntimeException("Not allowed scheme.");
            }
            File gameDir = DynamicPackMod.Companion.getGameDir();
            File file = new File(gameDir, StringsKt.removePrefix((String)url, (CharSequence)"file_debug_only://"));
            inputStream = new FileInputStream(file);
        } else if (StringsKt.startsWith$default((String)url, (String)"http://", (boolean)false, (int)2, null)) {
            if (!Urls.isHTTPTrafficAllowed()) {
                throw new RuntimeException("HTTP (not secure) not allowed scheme.");
            }
            this.throwIsUrlNotTrust(url);
            inputStream = this.__unsafeInputStreamFromUrl(url, sizeLimit, controller);
        } else if (StringsKt.startsWith$default((String)url, (String)"https://", (boolean)false, (int)2, null)) {
            this.throwIsUrlNotTrust(url);
            inputStream = this.__unsafeInputStreamFromUrl(url, sizeLimit, controller);
        } else {
            throw new RuntimeException("Unsupported scheme for url " + url);
        }
        return inputStream;
    }

    private final InputStream __unsafeInputStreamFromUrl(String url, long sizeLimit, UrlsController controller) throws IOException {
        long metaSize = 24L + (long)url.length();
        Object r = NetworkStat.INSTANCE.runNetworkTask(metaSize, () -> Urls.__unsafeInputStreamFromUrl$lambda$0(url, sizeLimit, controller));
        Intrinsics.checkNotNullExpressionValue(r, (String)"runNetworkTask(...)");
        return (InputStream)r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String _parseTextFromStream$dynamicpack(@NotNull InputStream stream, @Nullable UrlsController controller) throws IOException {
        String string;
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Closeable closeable = stream;
        Throwable throwable = null;
        try {
            InputStream input = (InputStream)closeable;
            boolean bl = false;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buf = new byte[Constants.URLS_BUFFER_SIZE];
            boolean isNetwork = INSTANCE.isNetwork(input);
            INSTANCE.readLoop(input, buf, controller, isNetwork, (Function3<? super byte[], ? super Integer, ? super Integer, Unit>)((Function3)(arg_0, arg_1, arg_2) -> Urls._parseTextFromStream$lambda$0$0(out, arg_0, arg_1, arg_2)));
            string = out.toString(StandardCharsets.UTF_8);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void _transferStreams(InputStream inputStream, OutputStream outputStream, UrlsController controller) throws IOException {
        Closeable closeable = inputStream;
        Throwable throwable = null;
        try {
            long l;
            InputStream inp = (InputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = outputStream;
            Throwable throwable2 = null;
            try {
                long l2;
                OutputStream outp = (OutputStream)closeable2;
                boolean bl2 = false;
                Closeable closeable3 = new BufferedInputStream(inp);
                Throwable throwable3 = null;
                try {
                    BufferedInputStream inBuf = (BufferedInputStream)closeable3;
                    boolean bl3 = false;
                    byte[] buf = new byte[Constants.URLS_BUFFER_SIZE];
                    boolean isNetwork = INSTANCE.isNetwork(inp);
                    l2 = INSTANCE.readLoop(inBuf, buf, controller, isNetwork, (Function3<? super byte[], ? super Integer, ? super Integer, Unit>)((Function3)(arg_0, arg_1, arg_2) -> Urls._transferStreams$lambda$0$0$0$0(outp, arg_0, arg_1, arg_2)));
                }
                catch (Throwable throwable4) {
                    throwable3 = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                }
                l = l2;
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            long l3 = l;
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void _transferStreamsWithHash$dynamicpack(@NotNull String hash, @NotNull InputStream inputStream, @NotNull OutputStream outputStream, @Nullable UrlsController controller) throws IOException {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        byte[] buf = new byte[Constants.URLS_BUFFER_SIZE];
        boolean isNetwork = this.isNetwork(inputStream);
        Closeable closeable = new BufferedInputStream(inputStream);
        Throwable throwable = null;
        try {
            BufferedInputStream inBuf = (BufferedInputStream)closeable;
            boolean bl = false;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            INSTANCE.readLoop(inBuf, buf, controller, isNetwork, (Function3<? super byte[], ? super Integer, ? super Integer, Unit>)((Function3)(arg_0, arg_1, arg_2) -> Urls._transferStreamsWithHash$lambda$0$0(out, arg_0, arg_1, arg_2)));
            byArray = out.toByteArray();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        byte[] bytes = byArray;
        Intrinsics.checkNotNull((Object)bytes);
        String calcHash = Hashes.sha1sum(bytes);
        if (!Intrinsics.areEqual((Object)calcHash, (Object)hash)) {
            throw new SecurityException("Hash mismatch: expected=" + hash + " actual=" + calcHash);
        }
        this._transferStreams(new ByteArrayInputStream(bytes), outputStream, null);
    }

    private final long readLoop(InputStream input, byte[] buf, UrlsController controller, boolean isNetwork, Function3<? super byte[], ? super Integer, ? super Integer, Unit> onBytes) {
        long total = 0L;
        int bytesRead = 0;
        while (true) {
            if (UrlsController.Companion.isInterrupted(controller)) {
                Out.INSTANCE.debug("interrupted readLoop");
                break;
            }
            long start = System.currentTimeMillis();
            bytesRead = input.read(buf);
            if (bytesRead == -1) break;
            onBytes.invoke((Object)buf, (Object)0, (Object)bytesRead);
            UrlsController.Companion.updateCurrent(controller, total += (long)bytesRead);
            if (!isNetwork) continue;
            Constants.INSTANCE.debugNetwork(bytesRead, total);
            NetworkStat.INSTANCE.addLap(System.currentTimeMillis() - start, bytesRead);
        }
        return total;
    }

    private final boolean isNetwork(InputStream isrc) {
        return !(isrc instanceof ByteArrayInputStream);
    }

    private final void throwIsUrlNotTrust(String url) throws IOException {
        if (!Constants.INSTANCE.isUrlHostTrusted(url) && Constants.INSTANCE.isBlockAllNotTrustedNetworks()) {
            throw new SecurityException("Url '" + url + "' host is not trusted!");
        }
    }

    private static final InputStream __unsafeInputStreamFromUrl$lambda$0(String $url, long $sizeLimit, UrlsController $controller) {
        URLConnection connection;
        block1: {
            URLConnection uRLConnection = new URI($url).toURL().openConnection();
            Intrinsics.checkNotNullExpressionValue((Object)uRLConnection, (String)"openConnection(...)");
            connection = uRLConnection;
            long length = connection.getContentLengthLong();
            if (length > $sizeLimit) {
                throw new RuntimeException("File size exceeds " + length + " bytes > limit " + $sizeLimit + "; url=" + $url);
            }
            UrlsController urlsController = $controller;
            if (urlsController == null) break block1;
            urlsController.updateMax(length);
        }
        return connection.getInputStream();
    }

    private static final Unit _parseTextFromStream$lambda$0$0(ByteArrayOutputStream $out, byte[] data, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        $out.write(data, off, len);
        return Unit.INSTANCE;
    }

    private static final Unit _transferStreams$lambda$0$0$0$0(OutputStream $outp, byte[] data, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        $outp.write(data, off, len);
        return Unit.INSTANCE;
    }

    private static final Unit _transferStreamsWithHash$lambda$0$0(ByteArrayOutputStream $out, byte[] data, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        $out.write(data, off, len);
        return Unit.INSTANCE;
    }
}

