/*
 * Decompiled with CFR 0.152.
 */
package com.calculatorsteam.dynamicpack.client.config;

import com.calculatorsteam.dynamicpack.Constants;
import com.calculatorsteam.dynamicpack.pack.dynamicrepo.DynamicRepoSyncBuilder;
import com.calculatorsteam.dynamicpack.util.PathUtil;
import com.calculatorsteam.dynamicpack.util.log.FileLog;
import com.calculatorsteam.dynamicpack.util.log.Out;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0017\u0018\u0000 !2\u00020\u0001:\u0001!B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\t\u001a\u00020\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007J\u0006\u0010\u000e\u001a\u00020\u0007J\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007J\u0006\u0010\u0011\u001a\u00020\u0005J\u000e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u0006\u0010\u0014\u001a\u00020\u0005J\u000e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u0006\u0010\u0017\u001a\u00020\u0005J\u000e\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u0006\u0010\u001a\u001a\u00020\u0005J\u000e\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u0006\u0010\u001d\u001a\u00020\u0005J\u000e\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\b\u0010\u001f\u001a\u00020\u000bH\u0002J\u0006\u0010 \u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/calculatorsteam/dynamicpack/client/config/Config;", "", "<init>", "()V", "def", "", "formatVersion", "", "networkBufferSize", "getNetworkBufferSize", "setNetworkBufferSize", "", "value", "networkMultithreadDownloadThreads", "getNetworkMultithreadDownloadThreads", "setNetworkMultithreadDownloadThreads", "logAllFilesChanges", "isLogAllFilesChanges", "setLogAllFilesChanges", "autoUpdateAtLaunch", "isAutoUpdateAtLaunch", "setAutoUpdateAtLaunch", "updateOnlyEnabledPacks", "isUpdateOnlyEnabledPacks", "setUpdateOnlyEnabledPacks", "debugIgnoreHiddenFlagInContents", "dynamicRepoIsIgnoreHiddenContentFlag", "setDebugIgnoreHiddenFlagInContents", "debugLogs", "isDebugLogs", "setDebugLogs", "checkAndValidateConfig", "save", "Companion", "dynamicpack"})
public final class Config {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private transient boolean def;
    private int formatVersion = 1;
    private int networkBufferSize = 1024;
    private int networkMultithreadDownloadThreads = 12;
    private boolean logAllFilesChanges;
    private boolean autoUpdateAtLaunch = true;
    private boolean updateOnlyEnabledPacks = true;
    private boolean debugIgnoreHiddenFlagInContents;
    private boolean debugLogs;
    @JvmField
    @NotNull
    public static final Config DEF = com.calculatorsteam.dynamicpack.client.config.Config$Companion.access$createDefConfig(Companion);
    @Nullable
    private static Config instance;
    @Nullable
    private static File fileRef;

    private Config() {
    }

    public final int getNetworkBufferSize() {
        return this.networkBufferSize;
    }

    public final void setNetworkBufferSize(int value) {
        this.networkBufferSize = value;
        Config.Companion.updateStaticVariables(this);
    }

    public final int getNetworkMultithreadDownloadThreads() {
        return this.networkMultithreadDownloadThreads;
    }

    public final void setNetworkMultithreadDownloadThreads(int value) {
        this.networkMultithreadDownloadThreads = value;
        Config.Companion.updateStaticVariables(this);
    }

    public final boolean isLogAllFilesChanges() {
        return this.logAllFilesChanges;
    }

    public final void setLogAllFilesChanges(boolean value) {
        this.logAllFilesChanges = value;
        Config.Companion.updateStaticVariables(this);
    }

    public final boolean isAutoUpdateAtLaunch() {
        return this.autoUpdateAtLaunch;
    }

    public final void setAutoUpdateAtLaunch(boolean value) {
        this.autoUpdateAtLaunch = value;
    }

    public final boolean isUpdateOnlyEnabledPacks() {
        return this.updateOnlyEnabledPacks;
    }

    public final void setUpdateOnlyEnabledPacks(boolean value) {
        this.updateOnlyEnabledPacks = value;
    }

    public final boolean dynamicRepoIsIgnoreHiddenContentFlag() {
        return this.debugIgnoreHiddenFlagInContents;
    }

    public final void setDebugIgnoreHiddenFlagInContents(boolean value) {
        this.debugIgnoreHiddenFlagInContents = value;
    }

    public final boolean isDebugLogs() {
        return this.debugLogs;
    }

    public final void setDebugLogs(boolean value) {
        this.debugLogs = value;
    }

    private final void checkAndValidateConfig() {
        int n;
        boolean save = false;
        if (this.networkBufferSize < 256) {
            this.networkBufferSize = 256;
            save = true;
            Out.INSTANCE.warn("Config invalid 'networkBufferSize'. Sets to " + this.networkBufferSize);
        }
        if (!(1 <= (n = this.networkMultithreadDownloadThreads) ? n < 256 : false)) {
            this.networkMultithreadDownloadThreads = 8;
            save = true;
            Out.INSTANCE.warn("Config invalid 'networkMultithreadDownloadThreads'. Sets to " + this.networkMultithreadDownloadThreads);
        }
        if (save) {
            this.save();
        }
    }

    public final void save() {
        if (this.def) {
            throw new RuntimeException("Can't save a DEF config!");
        }
        try {
            String json = Constants.GSON.toJson((Object)this);
            File file = fileRef;
            Intrinsics.checkNotNull((Object)file);
            Path path = file.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            Path file2 = path;
            PathUtil.delete(file2);
            PathUtil.createDirsToFile(file2);
            PathUtil.createFile(file2);
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.WRITE};
            Files.writeString(file2, (CharSequence)json, openOptionArray);
        }
        catch (Exception e) {
            Out.error("Config save failed :(", e);
        }
    }

    @JvmStatic
    @NotNull
    public static final Config load() {
        return Companion.load();
    }

    @JvmStatic
    @NotNull
    public static final Config getInstance() {
        return Companion.getInstance();
    }

    public /* synthetic */ Config(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u0005H\u0002J\b\u0010\u000e\u001a\u00020\u0005H\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\b\u0010\u0012\u001a\u00020\u0005H\u0007R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/calculatorsteam/dynamicpack/client/config/Config$Companion;", "", "<init>", "()V", "DEF", "Lcom/calculatorsteam/dynamicpack/client/config/Config;", "instance", "fileRef", "Ljava/io/File;", "getFileRef$dynamicpack", "()Ljava/io/File;", "setFileRef$dynamicpack", "(Ljava/io/File;)V", "createDefConfig", "load", "updateStaticVariables", "", "config", "getInstance", "dynamicpack"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final File getFileRef$dynamicpack() {
            return fileRef;
        }

        public final void setFileRef$dynamicpack(@Nullable File file) {
            fileRef = file;
        }

        private final Config createDefConfig() {
            Config cfg = new Config(null);
            cfg.def = true;
            return cfg;
        }

        @JvmStatic
        @NotNull
        public final Config load() {
            Config config;
            if (instance != null) {
                throw new RuntimeException("Config already loaded");
            }
            File file = this.getFileRef$dynamicpack();
            if (file == null) {
                throw new RuntimeException("Config.fileRef not set before load()!");
            }
            File file2 = file;
            if (!file2.exists()) {
                Config cfg = new Config(null);
                this.updateStaticVariables(cfg);
                instance = cfg;
                return cfg;
            }
            try {
                Config config2 = (Config)Constants.GSON.fromJson(PathUtil.readString(file2.toPath()), Config.class);
                Intrinsics.checkNotNull((Object)config2);
                this.updateStaticVariables(config2);
                instance = config2;
                config = config2;
            }
            catch (Exception e) {
                Out.error("Config load failed (return default config)", e);
                Config fallback = new Config(null);
                this.updateStaticVariables(fallback);
                instance = fallback;
                config = fallback;
            }
            return config;
        }

        private final void updateStaticVariables(Config config) {
            config.checkAndValidateConfig();
            Constants.URLS_BUFFER_SIZE = config.networkBufferSize;
            Constants.DEBUG_LOGS = config.debugLogs;
            DynamicRepoSyncBuilder.Companion.setDOWNLOAD_THREADS_COUNT(config.networkMultithreadDownloadThreads);
            FileLog.logAllChanges = config.logAllFilesChanges;
        }

        @JvmStatic
        @NotNull
        public final Config getInstance() {
            Config config = instance;
            if (config == null) {
                throw new IllegalStateException("Config not initialized!");
            }
            return config;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ Config access$createDefConfig(Companion $this) {
            return $this.createDefConfig();
        }
    }
}

