/*
 * Decompiled with CFR 0.152.
 */
package com.calculatorsteam.dynamicpack.mixins;

import com.calculatorsteam.dynamicpack.client.gui.widget.DynamicPackResourcePackEntryWidget;
import com.calculatorsteam.dynamicpack.client.gui.widget.ResourcePackEntryWidget;
import com.calculatorsteam.dynamicpack.platform.VersionFunctions;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.packs.PackSelectionModel;
import net.minecraft.client.gui.screens.packs.TransferableSelectionList;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TransferableSelectionList.PackEntry.class})
public abstract class ResourcePackEntryMixin
extends ObjectSelectionList.Entry<TransferableSelectionList.Entry> {
    @Shadow
    @Final
    private PackSelectionModel.Entry pack;
    @Shadow
    @Final
    private TransferableSelectionList parent;
    @Unique
    int dynamicpack$selected = -1;
    @Unique
    private Boolean fold;
    @Unique
    int dynamicpack$foldTicks = 0;
    @Unique
    private static final int maxFoldTicks = 10;
    @Unique
    private static final ResourcePackEntryWidget DYNAMIC_WIDGET = new DynamicPackResourcePackEntryWidget();

    @Shadow
    protected abstract boolean showHoverOverlay();

    @Inject(at={@At(value="TAIL")}, method={"renderContent"})
    private void render(GuiGraphics context, int mouseX, int mouseY, boolean hovered, float tickDelta, CallbackInfo info) {
        int x = this.getX();
        int y = this.getY() + 2;
        int entryWidth = this.getWidth();
        int entryHeight = this.getHeight();
        int prevMargin = 0;
        int deltaX = 3 + (VersionFunctions.maxScrollAmount(this.parent) > 0 ? 7 : 0);
        boolean selectable = this.showHoverOverlay();
        this.dynamicpack$selected = -1;
        if (this.dynamicpack$foldTicks == 10) {
            VersionFunctions.blitSprite(context, ResourceLocation.withDefaultNamespace((String)"transferable_list/unselect"), x + entryWidth - 16 - deltaX, y + entryWidth / 20 - 16, 16, 32);
        } else {
            ResourcePackEntryWidget widget = DYNAMIC_WIDGET;
            if (widget.isVisible(this.pack, selectable)) {
                deltaX = Math.max(prevMargin, widget.getXMargin(this.pack));
                int width = widget.getWidth(this.pack);
                int height = widget.getHeight(this.pack, entryHeight);
                int entryX = x + entryWidth - (deltaX + width) * (10 - this.dynamicpack$foldTicks) / 10;
                int entryY = y + widget.getY(this.pack, entryHeight);
                deltaX += width;
                boolean widgetHovered = mouseX <= entryX + width && mouseX >= entryX && mouseY <= entryY + height && mouseY >= entryY;
                widget.render(this.pack, context, entryX, entryY, widgetHovered, tickDelta);
                if (widgetHovered) {
                    this.dynamicpack$selected = 0;
                }
                prevMargin = widget.getXMargin(this.pack);
            }
        }
        if (this.fold == null) {
            this.fold = deltaX > 48;
        }
        if (!this.fold.booleanValue()) {
            return;
        }
        int mouseRange = Math.max(10, deltaX) + 40;
        this.dynamicpack$foldTicks = mouseX >= x + entryWidth - mouseRange && mouseX <= x + entryWidth && mouseY <= y + entryHeight && mouseY >= y ? Math.max(this.dynamicpack$foldTicks - 1, 0) : Math.min(this.dynamicpack$foldTicks + 1, 10);
    }

    @Inject(method={"mouseClicked"}, at={@At(value="RETURN")}, cancellable=true)
    private void dynamicpack$afterMouseClicked(MouseButtonEvent event, boolean isDoubleClick, CallbackInfoReturnable<Boolean> cir) {
        if (this.dynamicpack$selected != -1) {
            cir.setReturnValue((Object)false);
            DYNAMIC_WIDGET.onClick(this.pack);
        }
    }
}

