/*
 * Decompiled with CFR 0.152.
 */
package com.calculatorsteam.dynamicpack.pack;

import com.calculatorsteam.dynamicpack.Constants;
import com.calculatorsteam.dynamicpack.DynamicPackMod;
import com.calculatorsteam.dynamicpack.pack.AbstractPack;
import com.calculatorsteam.dynamicpack.pack.DynamicResourcePack;
import com.calculatorsteam.dynamicpack.pack.Remote;
import com.calculatorsteam.dynamicpack.sync.SyncBuilder;
import com.calculatorsteam.dynamicpack.sync.SyncProgress;
import com.calculatorsteam.dynamicpack.sync.SyncingTask;
import com.calculatorsteam.dynamicpack.util.JsonUtil;
import com.calculatorsteam.dynamicpack.util.LockUtils;
import com.calculatorsteam.dynamicpack.util.PackUtil;
import com.calculatorsteam.dynamicpack.util.PathUtil;
import com.calculatorsteam.dynamicpack.util.log.Out;
import com.calculatorsteam.dynamicpack.util.status.StatusChecker;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\t\n\u0002\b\u0010\n\u0002\u0010\u0003\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u001b\u001a\u00020\u0018J\u0006\u0010\u001c\u001a\u00020\u0014J\u000e\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\rJ\b\u0010 \u001a\u00020\u0014H\u0002J\u0006\u0010!\u001a\u00020\rJ\u0006\u0010\"\u001a\u00020\rJ\u0006\u0010#\u001a\u00020\tJ\u0006\u0010$\u001a\u00020\u0003J\u0006\u0010/\u001a\u00020\u000bJ\u0016\u00100\u001a\u00020\u00142\u000e\u00101\u001a\n\u0018\u00010\u000fj\u0004\u0018\u0001`\u0010J\u000e\u00102\u001a\n\u0018\u00010\u000fj\u0004\u0018\u0001`\u0010J\u0006\u00103\u001a\u000204J\u0006\u00105\u001a\u00020\u0014J\u0006\u00106\u001a\u00020\rJ\u0006\u00107\u001a\u00020\rJ\b\u00108\u001a\u00020\u0014H\u0002J\u0010\u00109\u001a\u00020\r2\u0006\u0010:\u001a\u00020\u000bH\u0002J\u001a\u0010;\u001a\u00020\u00142\u0012\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00140\u0013J\u001a\u0010=\u001a\u00020\u00142\u0012\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00140\u0013J\u0010\u0010>\u001a\u00020\u00142\b\u0010?\u001a\u0004\u0018\u00010\u0000J\u0010\u0010@\u001a\u00020\u00142\u0006\u0010A\u001a\u00020\u0000H\u0002J\b\u0010B\u001a\u00020\u0014H\u0002J\u000e\u0010C\u001a\u00020\u00142\u0006\u0010:\u001a\u00020\u000bJ\u0016\u0010D\u001a\u00020\u00142\u0006\u0010:\u001a\u00020\u000b2\u0006\u00101\u001a\u00020EJ\u000e\u0010F\u001a\u00020\u00142\u0006\u0010:\u001a\u00020\u000bJ\u000e\u0010G\u001a\u00020\u00142\u0006\u0010:\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0018\u00010\u000fj\u0004\u0018\u0001`\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00140\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010%\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0011\u0010(\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010'R\u0011\u0010*\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0011\u0010-\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b.\u0010,\u00a8\u0006H"}, d2={"Lcom/calculatorsteam/dynamicpack/pack/DynamicResourcePack;", "Lcom/calculatorsteam/dynamicpack/pack/AbstractPack;", "location", "Ljava/io/File;", "cachedJson", "Lcom/google/gson/JsonObject;", "<init>", "(Ljava/io/File;Lcom/google/gson/JsonObject;)V", "remote", "Lcom/calculatorsteam/dynamicpack/pack/Remote;", "remoteTypeStr", "", "cachedUpdateAvailable", "", "latestException", "Ljava/lang/Exception;", "Lkotlin/Exception;", "destroyListeners", "", "Lkotlin/Function1;", "", "_isSyncing", "destroyed", "activeSyncBuilder", "Lcom/calculatorsteam/dynamicpack/sync/SyncBuilder;", "isSyncing", "()Z", "syncBuilder", "saveClientFile", "packRoot", "Ljava/nio/file/Path;", "isNetworkBlocked", "checkNetwork", "isZip", "isDestroyed", "getRemote", "getLocation", "name", "getName", "()Ljava/lang/String;", "minecraftId", "getMinecraftId", "packJson", "getPackJson", "()Lcom/google/gson/JsonObject;", "currentJson", "getCurrentJson", "getRemoteType", "setLatestException", "e", "getLatestException", "getLatestUpdated", "", "updateJsonLatestUpdate", "checkIsUpdateAvailable", "getCachedUpdateAvailableStatus", "validateSafePackMinecraftMeta", "checkMinecraftMetaIsValid", "s", "addDestroyListener", "runnable", "removeDestroyListener", "flashback", "oldestPack", "markAsDestroyed", "heirPack", "interrupt", "debug", "error", "", "warn", "println", "dynamicpack"})
@SourceDebugExtension(value={"SMAP\nDynamicResourcePack.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DynamicResourcePack.kt\ncom/calculatorsteam/dynamicpack/pack/DynamicResourcePack\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,254:1\n1#2:255\n37#3,2:256\n13805#4,2:258\n*S KotlinDebug\n*F\n+ 1 DynamicResourcePack.kt\ncom/calculatorsteam/dynamicpack/pack/DynamicResourcePack\n*L\n230#1:256,2\n230#1:258,2\n*E\n"})
public final class DynamicResourcePack
implements AbstractPack {
    @NotNull
    private final File location;
    @NotNull
    private final JsonObject cachedJson;
    @NotNull
    private final Remote remote;
    @NotNull
    private final String remoteTypeStr;
    private boolean cachedUpdateAvailable;
    @Nullable
    private Exception latestException;
    @NotNull
    private final List<Function1<DynamicResourcePack, Unit>> destroyListeners;
    private boolean _isSyncing;
    private boolean destroyed;
    @Nullable
    private SyncBuilder activeSyncBuilder;

    public DynamicResourcePack(@NotNull File location, @NotNull JsonObject cachedJson) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)cachedJson, (String)"cachedJson");
        this.location = location;
        this.cachedJson = cachedJson;
        this.destroyListeners = new ArrayList();
        try {
            JsonObject remoteJson = this.cachedJson.getAsJsonObject("remote");
            String string = remoteJson.getAsJsonPrimitive("type").getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
            this.remoteTypeStr = string;
            Object object = Remote.REMOTES.get(this.remoteTypeStr);
            if (object == null || (object = (Remote)object.invoke()) == null) {
                throw new RuntimeException("Unknown remote type: " + this.remoteTypeStr);
            }
            this.remote = object;
            Intrinsics.checkNotNull((Object)remoteJson);
            this.remote.init(this, remoteJson);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse 'remote' block", e);
        }
    }

    @Override
    public boolean isSyncing() {
        return this._isSyncing;
    }

    @NotNull
    public final SyncBuilder syncBuilder() {
        return new SyncBuilder(this){
            private SyncBuilder builder;
            private boolean notUpdate;
            final /* synthetic */ DynamicResourcePack this$0;
            {
                this.this$0 = $receiver;
            }

            private final void wrapThrowable(Function0<Unit> funBlock) {
                this.wrapThrowableRet((Function0)new Function0(funBlock){
                    final /* synthetic */ Function0<Unit> $funBlock;
                    {
                        this.$funBlock = $funBlock;
                    }

                    public final Void invoke() {
                        this.$funBlock.invoke();
                        return null;
                    }
                }, null);
            }

            private final <T> T wrapThrowableRet(Function0<? extends T> funBlock, T def) {
                Object object;
                try {
                    object = funBlock.invoke();
                }
                catch (Exception e) {
                    DynamicResourcePack.access$set_isSyncing$p(this.this$0, false);
                    this.this$0.setLatestException(e);
                    this.notUpdate = true;
                    this.this$0.error("Error while doUpdate (or init) SyncBuilder", e);
                    object = def;
                }
                return (T)object;
            }

            public void init(boolean ignoreCaches) {
                DynamicResourcePack.access$set_isSyncing$p(this.this$0, true);
                DynamicResourcePack.access$setActiveSyncBuilder$p(this.this$0, this);
                this.wrapThrowable((Function0<Unit>)((Function0)() -> syncBuilder.1.init$lambda$0(this.this$0, this, ignoreCaches)));
                DynamicResourcePack.access$set_isSyncing$p(this.this$0, false);
                DynamicResourcePack.access$setActiveSyncBuilder$p(this.this$0, null);
            }

            public long getDownloadedSize() {
                return this.notUpdate ? 0L : ((Number)this.wrapThrowableRet(() -> syncBuilder.1._get_downloadedSize_$lambda$1(this), -1L)).longValue();
            }

            public boolean isUpdateAvailable() {
                return this.notUpdate ? false : this.wrapThrowableRet(() -> syncBuilder.1._get_isUpdateAvailable_$lambda$2(this), false);
            }

            public long getUpdateSize() {
                return this.notUpdate ? 0L : ((Number)this.wrapThrowableRet(() -> syncBuilder.1._get_updateSize_$lambda$3(this), -1L)).longValue();
            }

            public boolean doUpdate(SyncProgress progress) {
                Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
                if (this.notUpdate) {
                    return false;
                }
                SyncingTask.currentPackName = this.this$0.getName();
                return this.wrapThrowableRet(() -> syncBuilder.1.doUpdate$lambda$4(this.this$0, this, progress), false);
            }

            public void interrupt() {
                block0: {
                    SyncBuilder syncBuilder2 = this.builder;
                    if (syncBuilder2 == null) break block0;
                    syncBuilder2.interrupt();
                }
            }

            /*
             * WARNING - void declaration
             */
            private static final Unit init$lambda$0(DynamicResourcePack this$0, syncBuilder.1 this$1, boolean $ignoreCaches) {
                void $this$init_u24lambda_u240_u240;
                SyncBuilder syncBuilder2;
                DynamicResourcePack.access$checkNetwork(this$0);
                SyncBuilder syncBuilder3 = syncBuilder2 = DynamicResourcePack.access$getRemote$p(this$0).syncBuilder();
                syncBuilder.1 var6_5 = this$1;
                boolean bl = false;
                $this$init_u24lambda_u240_u240.init($ignoreCaches);
                var6_5.builder = syncBuilder2;
                return Unit.INSTANCE;
            }

            private static final long _get_downloadedSize_$lambda$1(syncBuilder.1 this$0) {
                SyncBuilder syncBuilder2 = this$0.builder;
                return syncBuilder2 != null ? syncBuilder2.getDownloadedSize() : -1L;
            }

            private static final boolean _get_isUpdateAvailable_$lambda$2(syncBuilder.1 this$0) {
                SyncBuilder syncBuilder2 = this$0.builder;
                return syncBuilder2 != null ? syncBuilder2.isUpdateAvailable() : false;
            }

            private static final long _get_updateSize_$lambda$3(syncBuilder.1 this$0) {
                SyncBuilder syncBuilder2 = this$0.builder;
                return syncBuilder2 != null ? syncBuilder2.getUpdateSize() : -1L;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private static final boolean doUpdate$lambda$4(DynamicResourcePack this$0, syncBuilder.1 this$1, SyncProgress $progress) {
                DynamicResourcePack.access$setActiveSyncBuilder$p(this$0, this$1);
                DynamicResourcePack.access$set_isSyncing$p(this$0, true);
                SyncBuilder syncBuilder2 = this$1.builder;
                boolean b = syncBuilder2 != null ? syncBuilder2.doUpdate($progress) : false;
                try {
                    DynamicResourcePack.access$validateSafePackMinecraftMeta(this$0);
                    this$0.setLatestException(null);
                }
                catch (Exception e2) {
                    this$0.error("Error while check safe pack meta", e2);
                    this$0.setLatestException(e2);
                }
                finally {
                    DynamicResourcePack.access$set_isSyncing$p(this$0, false);
                    DynamicResourcePack.access$setActiveSyncBuilder$p(this$0, null);
                }
                return b;
            }
        };
    }

    public final void saveClientFile() {
        try {
            PackUtil.openPackFileSystem(this.location, LockUtils.createFileFinalizer(this.location), (Function1<? super Path, Unit>)((Function1)arg_0 -> DynamicResourcePack.saveClientFile$lambda$0(this, arg_0)));
        }
        catch (Exception e) {
            throw new RuntimeException("saveClientFile failed.", e);
        }
    }

    public final void saveClientFile(@NotNull Path packRoot) {
        Intrinsics.checkNotNullParameter((Object)packRoot, (String)"packRoot");
        PathUtil.nioWriteText(packRoot.resolve("dynamicmcpack.json"), JsonUtil.toString(this.getPackJson()));
    }

    public final boolean isNetworkBlocked() {
        return StatusChecker.isBlockUpdating(this.remoteTypeStr);
    }

    private final void checkNetwork() {
        if (this.isNetworkBlocked()) {
            throw new SecurityException("Network is blocked for remote_type=" + this.remoteTypeStr + " current version of mod not safe. Update mod!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isZip() {
        if (this.location.isDirectory()) return false;
        String string = this.location.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        if (!StringsKt.endsWith$default((String)string2, (String)".zip", (boolean)false, (int)2, null)) return false;
        return true;
    }

    public final boolean isDestroyed() {
        return this.destroyed;
    }

    @NotNull
    public final Remote getRemote() {
        return this.remote;
    }

    @NotNull
    public final File getLocation() {
        return this.location;
    }

    @NotNull
    public final String getName() {
        String string = this.location.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @NotNull
    public final String getMinecraftId() {
        return "file/" + this.location.getName();
    }

    @NotNull
    public final JsonObject getPackJson() {
        return this.cachedJson;
    }

    @NotNull
    public final JsonObject getCurrentJson() {
        JsonObject jsonObject = this.cachedJson.getAsJsonObject("current");
        Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"getAsJsonObject(...)");
        return jsonObject;
    }

    @NotNull
    public final String getRemoteType() {
        return this.remoteTypeStr;
    }

    public final void setLatestException(@Nullable Exception e) {
        this.debug("latestException=" + e);
        this.latestException = e;
    }

    @Nullable
    public final Exception getLatestException() {
        return this.latestException;
    }

    public final long getLatestUpdated() {
        long l;
        try {
            l = this.cachedJson.getAsJsonObject("current").get("latest_updated").getAsLong();
        }
        catch (Exception e) {
            l = -1L;
        }
        return l;
    }

    public final void updateJsonLatestUpdate() {
        this.cachedJson.getAsJsonObject("current").addProperty("latest_updated", (Number)(System.currentTimeMillis() / (long)1000));
    }

    public final boolean checkIsUpdateAvailable() throws IOException {
        boolean bl;
        this.checkNetwork();
        boolean it = bl = this.remote.checkUpdateAvailable();
        boolean bl2 = false;
        this.cachedUpdateAvailable = it;
        return bl;
    }

    public final boolean getCachedUpdateAvailableStatus() {
        return this.cachedUpdateAvailable;
    }

    private final void validateSafePackMinecraftMeta() throws Exception {
        PackUtil.openPackFileSystem$default(this.location, null, arg_0 -> DynamicResourcePack.validateSafePackMinecraftMeta$lambda$0(this, arg_0), 2, null);
    }

    private final boolean checkMinecraftMetaIsValid(String s) {
        boolean bl;
        try {
            bl = DynamicPackMod.Companion.getInstance().checkResourcePackMetaValid(s);
        }
        catch (Exception e) {
            this.error("Error while check meta valid.", e);
            bl = false;
        }
        return bl;
    }

    public final void addDestroyListener(@NotNull Function1<? super DynamicResourcePack, Unit> runnable) {
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        ((Collection)this.destroyListeners).add(runnable);
    }

    public final void removeDestroyListener(@NotNull Function1<? super DynamicResourcePack, Unit> runnable) {
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        ((Collection)this.destroyListeners).remove(runnable);
    }

    public final void flashback(@Nullable DynamicResourcePack oldestPack) {
        if (oldestPack == null) {
            return;
        }
        oldestPack.markAsDestroyed(this);
        if (this.latestException == null) {
            this.latestException = oldestPack.latestException;
        }
    }

    private final void markAsDestroyed(DynamicResourcePack heirPack) {
        Collection $this$toTypedArray$iv = this.destroyListeners;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Function1[] $this$forEach$iv = thisCollection$iv.toArray(new Function1[0]);
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Function1 element$iv;
            Function1 it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            it.invoke((Object)heirPack);
        }
        this.destroyListeners.clear();
        this.destroyed = true;
    }

    private final void interrupt() {
        block0: {
            SyncBuilder syncBuilder2 = this.activeSyncBuilder;
            if (syncBuilder2 == null) break block0;
            syncBuilder2.interrupt();
        }
    }

    public final void debug(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Out.INSTANCE.debug("{" + this.getName() + "} " + s);
    }

    public final void error(@NotNull String s, @NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Out.error("{" + this.getName() + "} " + s, e);
    }

    public final void warn(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Out.INSTANCE.warn("{" + this.getName() + "} " + s);
    }

    public final void println(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Out.println("{" + this.getName() + "} " + s);
    }

    private static final Unit saveClientFile$lambda$0(DynamicResourcePack this$0, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.saveClientFile(it);
        return Unit.INSTANCE;
    }

    private static final Unit validateSafePackMinecraftMeta$lambda$0(DynamicResourcePack this$0, Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path mcmeta = path.resolve("pack.mcmeta");
        boolean safe = PathUtil.isPathFileExists(mcmeta);
        if (safe) {
            boolean bl;
            try {
                bl = this$0.checkMinecraftMetaIsValid(PathUtil.readString(mcmeta));
            }
            catch (IOException iOException) {
                bl = false;
            }
            safe = bl;
        }
        if (!safe) {
            PathUtil.nioWriteText(mcmeta, Constants.INSTANCE.getUNKNOWN_PACK_MCMETA());
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$set_isSyncing$p(DynamicResourcePack $this, boolean bl) {
        $this._isSyncing = bl;
    }

    public static final /* synthetic */ void access$setActiveSyncBuilder$p(DynamicResourcePack $this, SyncBuilder syncBuilder2) {
        $this.activeSyncBuilder = syncBuilder2;
    }

    public static final /* synthetic */ void access$checkNetwork(DynamicResourcePack $this) {
        $this.checkNetwork();
    }

    public static final /* synthetic */ Remote access$getRemote$p(DynamicResourcePack $this) {
        return $this.remote;
    }

    public static final /* synthetic */ void access$validateSafePackMinecraftMeta(DynamicResourcePack $this) {
        $this.validateSafePackMinecraftMeta();
    }
}

