/*
 * Decompiled with CFR 0.152.
 */
package com.calculatorsteam.dynamicpack.pack;

import com.calculatorsteam.dynamicpack.Constants;
import com.calculatorsteam.dynamicpack.DynamicPackMod;
import com.calculatorsteam.dynamicpack.pack.DynamicResourcePack;
import com.calculatorsteam.dynamicpack.pack.ModrinthRemote;
import com.calculatorsteam.dynamicpack.pack.Remote;
import com.calculatorsteam.dynamicpack.sync.SyncBuilder;
import com.calculatorsteam.dynamicpack.sync.SyncProgress;
import com.calculatorsteam.dynamicpack.util.Hashes;
import com.calculatorsteam.dynamicpack.util.JsonUtil;
import com.calculatorsteam.dynamicpack.util.LockUtils;
import com.calculatorsteam.dynamicpack.util.PackUtil;
import com.calculatorsteam.dynamicpack.util.PathUtil;
import com.calculatorsteam.dynamicpack.util.Urls;
import com.calculatorsteam.dynamicpack.util.UrlsController;
import com.calculatorsteam.dynamicpack.util.exception.TranslatableException;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001:\u0001 B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0007H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0006\u0010\u0014\u001a\u00020\tJ\u0006\u0010\u0015\u001a\u00020\tJ\u0006\u0010\u0016\u001a\u00020\tJ\u0006\u0010\u0017\u001a\u00020\tJ\u0006\u0010\u0018\u001a\u00020\fJ\u0006\u0010\u0019\u001a\u00020\u0007J\b\u0010\u001a\u001a\u00020\fH\u0016J\u0012\u0010\u001b\u001a\u00020\f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0007H\u0002J\u000e\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\tJ\u000e\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/calculatorsteam/dynamicpack/pack/ModrinthRemote;", "Lcom/calculatorsteam/dynamicpack/pack/Remote;", "<init>", "()V", "parent", "Lcom/calculatorsteam/dynamicpack/pack/DynamicResourcePack;", "cachedCurrentJson", "Lcom/google/gson/JsonObject;", "projectId", "", "gameVersion", "usesCurrentGameVersion", "", "noSpecifyGameVersion", "init", "", "pack", "remote", "syncBuilder", "Lcom/calculatorsteam/dynamicpack/sync/SyncBuilder;", "getCurrentUnique", "getCurrentVersionNumber", "getApiVersionsUrl", "getProjectId", "isUsesCurrentGameVersion", "parseModrinthLatestVersionJson", "checkUpdateAvailable", "_isUpdateAvailable", "latest", "debug", "s", "warn", "LatestModrinthVersion", "dynamicpack"})
@SourceDebugExtension(value={"SMAP\nModrinthRemote.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModrinthRemote.kt\ncom/calculatorsteam/dynamicpack/pack/ModrinthRemote\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,230:1\n1563#2:231\n1634#2,3:232\n1761#2,3:235\n*S KotlinDebug\n*F\n+ 1 ModrinthRemote.kt\ncom/calculatorsteam/dynamicpack/pack/ModrinthRemote\n*L\n169#1:231\n169#1:232,3\n170#1:235,3\n*E\n"})
public final class ModrinthRemote
extends Remote {
    private DynamicResourcePack parent;
    private JsonObject cachedCurrentJson;
    private String projectId;
    private String gameVersion;
    private boolean usesCurrentGameVersion;
    private boolean noSpecifyGameVersion;

    @Override
    public void init(@NotNull DynamicResourcePack pack, @NotNull JsonObject remote) {
        Intrinsics.checkNotNullParameter((Object)pack, (String)"pack");
        Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
        this.parent = pack;
        this.cachedCurrentJson = pack.getCurrentJson();
        this.projectId = remote.has("project_id") ? JsonUtil.getString(remote, "project_id") : JsonUtil.getString(remote, "modrinth_project_id");
        String string = JsonUtil.optString(remote, "game_version", "no_specify");
        if (string == null) {
            string = "no_specify";
        }
        String ver = string;
        this.usesCurrentGameVersion = StringsKt.equals((String)ver, (String)"current", (boolean)true);
        this.noSpecifyGameVersion = StringsKt.equals((String)ver, (String)"no_specify", (boolean)true);
        this.gameVersion = this.usesCurrentGameVersion ? DynamicPackMod.Companion.getInstance().getCurrentGameVersion() : ver;
    }

    @Override
    @NotNull
    public SyncBuilder syncBuilder() {
        return new SyncBuilder(this){
            private UrlsController urlsController;
            private LatestModrinthVersion latest;
            private JsonObject latestJson;
            private Boolean isUpdateAvailableCache;
            private long downloaded;
            private long updateSizeBytes;
            final /* synthetic */ ModrinthRemote this$0;
            {
                this.this$0 = $receiver;
            }

            public long getDownloadedSize() {
                return this.downloaded;
            }

            public boolean isUpdateAvailable() {
                Boolean bl = this.isUpdateAvailableCache;
                if (bl != null) {
                    boolean it = bl;
                    boolean bl2 = false;
                    return it;
                }
                boolean b = ModrinthRemote.access$_isUpdateAvailable(this.this$0, this.latestJson);
                this.isUpdateAvailableCache = b;
                return b;
            }

            public long getUpdateSize() {
                return this.updateSizeBytes;
            }

            public void init(boolean ignoreCaches) throws Exception {
                JsonObject jsonObject = this.latestJson = this.this$0.parseModrinthLatestVersionJson();
                Intrinsics.checkNotNull((Object)jsonObject);
                this.latest = LatestModrinthVersion.Companion.ofJson(jsonObject);
                if (this.isUpdateAvailable()) {
                    LatestModrinthVersion latestModrinthVersion = this.latest;
                    if (latestModrinthVersion == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"latest");
                        latestModrinthVersion = null;
                    }
                    this.updateSizeBytes = latestModrinthVersion.getSize();
                }
            }

            /*
             * WARNING - void declaration
             */
            public boolean doUpdate(SyncProgress progress) throws Exception {
                LatestModrinthVersion latestModrinthVersion;
                int attempts;
                Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
                if (!this.isUpdateAvailable()) {
                    this.this$0.warn("Call doUpdate in modrinth-remote when update not available");
                    return false;
                }
                progress.setPhase("Downloading resourcepack from modrinth");
                LatestModrinthVersion latestModrinthVersion2 = this.latest;
                if (latestModrinthVersion2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"latest");
                    latestModrinthVersion2 = null;
                }
                String fileName = StringsKt.substringAfterLast$default((String)latestModrinthVersion2.getUrl(), (char)'/', null, (int)2, null);
                File tempFile = null;
                for (attempts = 3; attempts > 0; --attempts) {
                    void it;
                    UrlsController urlsController;
                    LatestModrinthVersion latestModrinthVersion3 = this.latest;
                    if (latestModrinthVersion3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"latest");
                        latestModrinthVersion3 = null;
                    }
                    UrlsController urlsController2 = urlsController = new UrlsController(progress, fileName, this){
                        final /* synthetic */ SyncProgress $progress;
                        final /* synthetic */ String $fileName;
                        final /* synthetic */ syncBuilder.1 this$0;
                        {
                            this.$progress = $progress;
                            this.$fileName = $fileName;
                            this.this$0 = $receiver;
                        }

                        public void onUpdate(UrlsController it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            this.$progress.downloading(this.$fileName, it.getPercentage());
                            syncBuilder.1.access$setDownloaded$p(this.this$0, it.getLatest());
                        }
                    };
                    long l = Constants.INSTANCE.getMODRINTH_HTTPS_FILE_SIZE_LIMIT();
                    String string = ".zip";
                    String string2 = "dynamicpack_modrinth";
                    String string3 = latestModrinthVersion3.getUrl();
                    boolean bl = false;
                    this.urlsController = (UrlsController)it;
                    Unit unit = Unit.INSTANCE;
                    tempFile = Urls.downloadFileToTemp(string3, string2, string, l, urlsController);
                    UrlsController urlsController3 = this.urlsController;
                    boolean bl2 = urlsController3 != null ? urlsController3.isInterrupted() : false;
                    if (bl2) {
                        return false;
                    }
                    String string4 = Hashes.sha1sum(tempFile);
                    LatestModrinthVersion latestModrinthVersion4 = this.latest;
                    if (latestModrinthVersion4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"latest");
                        latestModrinthVersion4 = null;
                    }
                    if (Intrinsics.areEqual((Object)string4, (Object)latestModrinthVersion4.getFileHash())) break;
                    progress.setPhase("Failed. Downloading again...");
                }
                if (attempts == 0) {
                    progress.setPhase("Fatal error.");
                    throw new RuntimeException("Failed to download correct file from modrinth.");
                }
                progress.setPhase("Updating metadata...");
                JsonObject jsonObject = ModrinthRemote.access$getCachedCurrentJson$p(this.this$0);
                if (jsonObject == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"cachedCurrentJson");
                    jsonObject = null;
                }
                if ((latestModrinthVersion = this.latest) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"latest");
                    latestModrinthVersion = null;
                }
                jsonObject.addProperty("version", latestModrinthVersion.getId());
                JsonObject jsonObject2 = ModrinthRemote.access$getCachedCurrentJson$p(this.this$0);
                if (jsonObject2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"cachedCurrentJson");
                    jsonObject2 = null;
                }
                jsonObject2.remove("version_number");
                DynamicResourcePack dynamicResourcePack = ModrinthRemote.access$getParent$p(this.this$0);
                if (dynamicResourcePack == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"parent");
                    dynamicResourcePack = null;
                }
                dynamicResourcePack.updateJsonLatestUpdate();
                PackUtil.openPackFileSystem$default(tempFile, null, arg_0 -> syncBuilder.1.doUpdate$lambda$2(this.this$0, arg_0), 2, null);
                DynamicResourcePack dynamicResourcePack2 = ModrinthRemote.access$getParent$p(this.this$0);
                if (dynamicResourcePack2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"parent");
                    dynamicResourcePack2 = null;
                }
                if (dynamicResourcePack2.isZip()) {
                    progress.setPhase("Unlocking file.");
                    DynamicResourcePack dynamicResourcePack3 = ModrinthRemote.access$getParent$p(this.this$0);
                    if (dynamicResourcePack3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"parent");
                        dynamicResourcePack3 = null;
                    }
                    LockUtils.closeFile(dynamicResourcePack3.getLocation());
                    progress.setPhase("Move files...");
                    DynamicResourcePack dynamicResourcePack4 = ModrinthRemote.access$getParent$p(this.this$0);
                    if (dynamicResourcePack4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"parent");
                        dynamicResourcePack4 = null;
                    }
                    PathUtil.moveFile(tempFile, dynamicResourcePack4.getLocation());
                } else {
                    progress.setPhase("Extracting files...");
                    DynamicResourcePack dynamicResourcePack5 = ModrinthRemote.access$getParent$p(this.this$0);
                    if (dynamicResourcePack5 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"parent");
                        dynamicResourcePack5 = null;
                    }
                    PathUtil.recursiveDeleteDirectory(dynamicResourcePack5.getLocation());
                    DynamicResourcePack dynamicResourcePack6 = ModrinthRemote.access$getParent$p(this.this$0);
                    if (dynamicResourcePack6 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"parent");
                        dynamicResourcePack6 = null;
                    }
                    PathUtil.unzip(tempFile, dynamicResourcePack6.getLocation());
                    File file = tempFile;
                    PathUtil.delete(file != null ? file.toPath() : null);
                }
                progress.setPhase("Saving dynamicmcpack.json");
                DynamicResourcePack dynamicResourcePack7 = ModrinthRemote.access$getParent$p(this.this$0);
                if (dynamicResourcePack7 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"parent");
                    dynamicResourcePack7 = null;
                }
                dynamicResourcePack7.saveClientFile();
                progress.setPhase("Success");
                return true;
            }

            public void interrupt() {
                block0: {
                    UrlsController urlsController = this.urlsController;
                    if (urlsController == null) break block0;
                    urlsController.interrupt();
                }
            }

            private static final Unit doUpdate$lambda$2(ModrinthRemote this$0, Path it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                DynamicResourcePack dynamicResourcePack = ModrinthRemote.access$getParent$p(this$0);
                if (dynamicResourcePack == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"parent");
                    dynamicResourcePack = null;
                }
                dynamicResourcePack.saveClientFile(it);
                return Unit.INSTANCE;
            }

            public static final /* synthetic */ void access$setDownloaded$p(syncBuilder.1 $this, long l) {
                $this.downloaded = l;
            }
        };
    }

    @NotNull
    public final String getCurrentUnique() {
        String string;
        JsonObject jsonObject = this.cachedCurrentJson;
        if (jsonObject == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cachedCurrentJson");
            jsonObject = null;
        }
        if ((string = JsonUtil.optString(jsonObject, "version", "")) == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public final String getCurrentVersionNumber() {
        String string;
        JsonObject jsonObject = this.cachedCurrentJson;
        if (jsonObject == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cachedCurrentJson");
            jsonObject = null;
        }
        if ((string = JsonUtil.optString(jsonObject, "version_number", "")) == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public final String getApiVersionsUrl() {
        String string = this.projectId;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"projectId");
            string = null;
        }
        return "https://api.modrinth.com/v2/project/" + string + "/version";
    }

    @NotNull
    public final String getProjectId() {
        String string = this.projectId;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"projectId");
            string = null;
        }
        return string;
    }

    public final boolean isUsesCurrentGameVersion() {
        return this.usesCurrentGameVersion;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JsonObject parseModrinthLatestVersionJson() throws IOException {
        String string = Urls.parseTextContent(this.getApiVersionsUrl(), Constants.INSTANCE.getMOD_MODTINTH_API_LIMIT());
        if (string == null) {
            throw new IOException("Failed to fetch Modrinth API response");
        }
        String content = string;
        JsonArray versions = JsonUtil.arrayFromString(content);
        Iterator iterator = versions.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            boolean supportGameVersion;
            boolean bl;
            JsonObject version;
            block8: {
                void $this$any$iv;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                JsonElement o = (JsonElement)iterator2.next();
                version = o.getAsJsonObject();
                if (this.noSpecifyGameVersion) {
                    Intrinsics.checkNotNull((Object)version);
                    return version;
                }
                JsonArray gameVersions = version.getAsJsonArray("game_versions");
                Intrinsics.checkNotNull((Object)gameVersions);
                Iterable iterable = (Iterable)gameVersions;
                boolean $i$f$map = false;
                Iterator iterator3 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    JsonElement jsonElement = (JsonElement)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.getAsString());
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        String string2 = this.gameVersion;
                        if (string2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"gameVersion");
                            string2 = null;
                        }
                        if (!Intrinsics.areEqual((Object)it, (Object)string2)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (!(supportGameVersion = bl)) continue;
            Intrinsics.checkNotNull((Object)version);
            return version;
        }
        throw new TranslatableException("Could not find the latest version on modrinth with suitable parameters", "dynamicpack.exceptions.pack.remote.modrinth.not_found_latest_version", new Object[0]);
    }

    @Override
    public boolean checkUpdateAvailable() throws IOException {
        JsonObject latest = this.parseModrinthLatestVersionJson();
        return this._isUpdateAvailable(latest);
    }

    private final boolean _isUpdateAvailable(JsonObject latest) {
        if (latest == null) {
            this.warn("Latest version not available for this game_version");
            return false;
        }
        if (Intrinsics.areEqual((Object)JsonUtil.optString(latest, "version_number", ""), (Object)this.getCurrentVersionNumber())) {
            this.debug("Version number equal. Update not available");
            return false;
        }
        String id = JsonUtil.getString(latest, "id");
        this.debug("Version remote.id=" + id + "; current=" + this.getCurrentUnique());
        return !Intrinsics.areEqual((Object)this.getCurrentUnique(), (Object)id);
    }

    public final void debug(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        DynamicResourcePack dynamicResourcePack = this.parent;
        if (dynamicResourcePack == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"parent");
            dynamicResourcePack = null;
        }
        dynamicResourcePack.debug(s);
    }

    public final void warn(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        DynamicResourcePack dynamicResourcePack = this.parent;
        if (dynamicResourcePack == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"parent");
            dynamicResourcePack = null;
        }
        dynamicResourcePack.warn(s);
    }

    public static final /* synthetic */ boolean access$_isUpdateAvailable(ModrinthRemote $this, JsonObject latest) {
        return $this._isUpdateAvailable(latest);
    }

    public static final /* synthetic */ JsonObject access$getCachedCurrentJson$p(ModrinthRemote $this) {
        return $this.cachedCurrentJson;
    }

    public static final /* synthetic */ DynamicResourcePack access$getParent$p(ModrinthRemote $this) {
        return $this.parent;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\bH\u00c6\u0003J;\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lcom/calculatorsteam/dynamicpack/pack/ModrinthRemote$LatestModrinthVersion;", "", "id", "", "versionNumber", "url", "fileHash", "size", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;I)V", "getId", "()Ljava/lang/String;", "getVersionNumber", "getUrl", "getFileHash", "getSize", "()I", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "Companion", "dynamicpack"})
    public static final class LatestModrinthVersion {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String id;
        @NotNull
        private final String versionNumber;
        @NotNull
        private final String url;
        @NotNull
        private final String fileHash;
        private final int size;

        public LatestModrinthVersion(@NotNull String id, @NotNull String versionNumber, @NotNull String url, @NotNull String fileHash, int size) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)versionNumber, (String)"versionNumber");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)fileHash, (String)"fileHash");
            this.id = id;
            this.versionNumber = versionNumber;
            this.url = url;
            this.fileHash = fileHash;
            this.size = size;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getVersionNumber() {
            return this.versionNumber;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final String getFileHash() {
            return this.fileHash;
        }

        public final int getSize() {
            return this.size;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.versionNumber;
        }

        @NotNull
        public final String component3() {
            return this.url;
        }

        @NotNull
        public final String component4() {
            return this.fileHash;
        }

        public final int component5() {
            return this.size;
        }

        @NotNull
        public final LatestModrinthVersion copy(@NotNull String id, @NotNull String versionNumber, @NotNull String url, @NotNull String fileHash, int size) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)versionNumber, (String)"versionNumber");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)fileHash, (String)"fileHash");
            return new LatestModrinthVersion(id, versionNumber, url, fileHash, size);
        }

        public static /* synthetic */ LatestModrinthVersion copy$default(LatestModrinthVersion latestModrinthVersion, String string, String string2, String string3, String string4, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = latestModrinthVersion.id;
            }
            if ((n2 & 2) != 0) {
                string2 = latestModrinthVersion.versionNumber;
            }
            if ((n2 & 4) != 0) {
                string3 = latestModrinthVersion.url;
            }
            if ((n2 & 8) != 0) {
                string4 = latestModrinthVersion.fileHash;
            }
            if ((n2 & 0x10) != 0) {
                n = latestModrinthVersion.size;
            }
            return latestModrinthVersion.copy(string, string2, string3, string4, n);
        }

        @NotNull
        public String toString() {
            return "LatestModrinthVersion(id=" + this.id + ", versionNumber=" + this.versionNumber + ", url=" + this.url + ", fileHash=" + this.fileHash + ", size=" + this.size + ")";
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + this.versionNumber.hashCode();
            result = result * 31 + this.url.hashCode();
            result = result * 31 + this.fileHash.hashCode();
            result = result * 31 + Integer.hashCode(this.size);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LatestModrinthVersion)) {
                return false;
            }
            LatestModrinthVersion latestModrinthVersion = (LatestModrinthVersion)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)latestModrinthVersion.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.versionNumber, (Object)latestModrinthVersion.versionNumber)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.url, (Object)latestModrinthVersion.url)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.fileHash, (Object)latestModrinthVersion.fileHash)) {
                return false;
            }
            return this.size == latestModrinthVersion.size;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/calculatorsteam/dynamicpack/pack/ModrinthRemote$LatestModrinthVersion$Companion;", "", "<init>", "()V", "ofJson", "Lcom/calculatorsteam/dynamicpack/pack/ModrinthRemote$LatestModrinthVersion;", "latest", "Lcom/google/gson/JsonObject;", "dynamicpack"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final LatestModrinthVersion ofJson(@NotNull JsonObject latest) {
                Intrinsics.checkNotNullParameter((Object)latest, (String)"latest");
                String latestId = JsonUtil.getString(latest, "id");
                String latestVersionNumber = JsonUtil.getString(latest, "version_number");
                JsonArray files = latest.getAsJsonArray("files");
                Iterator iterator = files.iterator();
                Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
                Iterator iterator2 = iterator;
                while (iterator2.hasNext()) {
                    JsonElement element = (JsonElement)iterator2.next();
                    JsonObject file = element.getAsJsonObject();
                    if (!file.getAsJsonPrimitive("primary").getAsBoolean()) continue;
                    String url = file.getAsJsonPrimitive("url").getAsString();
                    int size = file.getAsJsonPrimitive("size").getAsInt();
                    String hash = file.getAsJsonObject("hashes").getAsJsonPrimitive("sha1").getAsString();
                    Intrinsics.checkNotNull((Object)url);
                    Intrinsics.checkNotNull((Object)hash);
                    return new LatestModrinthVersion(latestId, latestVersionNumber, url, hash, size);
                }
                throw new NoSuchElementException("File json-object with primary=true not found... Modrinth API???");
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

