/*
 * Decompiled with CFR 0.152.
 */
package com.calculatorsteam.dynamicpack.util.log;

import com.calculatorsteam.dynamicpack.Constants;
import com.calculatorsteam.dynamicpack.util.log.LoopLog;
import com.calculatorsteam.dynamicpack.util.log.Out;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\u0006\u0010\t\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u0010\u001a\u00020\u0005J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005J\u000e\u0010\u0015\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J\b\u0010\u0016\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/calculatorsteam/dynamicpack/util/log/NetworkStat;", "", "<init>", "()V", "MAGIC_NO_STATISTIC", "", "debugCallLoopLog", "Lcom/calculatorsteam/dynamicpack/util/log/LoopLog;", "millis", "bytes", "speedMultiplier", "runNetworkTask", "R", "runnable", "Lkotlin/Function0;", "(JLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "getSpeed", "addLap", "", "elapsed", "bytesRead", "remainingETA", "debugCall", "dynamicpack"})
public final class NetworkStat {
    @NotNull
    public static final NetworkStat INSTANCE = new NetworkStat();
    public static final long MAGIC_NO_STATISTIC = -1L;
    @NotNull
    private static final LoopLog debugCallLoopLog = new LoopLog(DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS), null);
    private static long millis;
    private static long bytes;
    @JvmField
    public static long speedMultiplier;

    private NetworkStat() {
    }

    public final <R> R runNetworkTask(long bytes, @NotNull Function0<? extends R> runnable) throws IOException {
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        long start = System.currentTimeMillis();
        IOException exception = null;
        Object result = null;
        try {
            result = runnable.invoke();
        }
        catch (IOException e) {
            exception = e;
        }
        long elapsed = System.currentTimeMillis() - start;
        this.addLap(elapsed, bytes);
        if (exception != null) {
            throw exception;
        }
        Object object = result;
        if (object == null) {
            throw new IllegalStateException("Runnable returned null");
        }
        return (R)object;
    }

    public final long getSpeed() {
        if (millis < 1000L || bytes == 0L) {
            return -1L;
        }
        return (long)((float)bytes / ((float)millis / 1000.0f)) * speedMultiplier;
    }

    public final void addLap(long elapsed, long bytesRead) {
        if (!(elapsed >= 0L && bytesRead >= 0L)) {
            boolean bl = false;
            String string = "elapsed and bytesRead can't be negative!";
            throw new IllegalArgumentException(string.toString());
        }
        if (bytes > Constants.INSTANCE.getNETWORK_STAT_RESET_LIMIT()) {
            bytes /= (long)3;
            millis /= (long)3;
            Out.INSTANCE.debug("[NetworkStat] reset by divide all by 3");
        }
        millis += elapsed;
        bytes += bytesRead;
        this.debugCall();
    }

    public final long remainingETA(long bytes) {
        long speed = this.getSpeed();
        if (speed <= 0L) {
            return -1L;
        }
        return bytes / speed;
    }

    private final void debugCall() {
    }

    static {
        speedMultiplier = 1L;
    }
}

