/*
 * Decompiled with CFR 0.152.
 */
package com.calculatorsteam.dynamicpack;

import com.calculatorsteam.dynamicpack.Constants;
import com.calculatorsteam.dynamicpack.util.log.Out;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0007\u001a\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\n\u001a\u00020\t2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0019\u0010\r\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0004\b\r\u0010\bJ\u0019\u0010\u000f\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0004\b\u000f\u0010\bJ\u0019\u0010\u0011\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u000bJ\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0013\u0010\bJ\u0019\u0010\u0014\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u000bJ\u0019\u0010\u0016\u001a\u00020\u00062\b\u0010\u0015\u001a\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0004\b\u0016\u0010\bJ\u0017\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001b\u001a\u00020\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001cR\u0014\u0010\u001e\u001a\u00020\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001c\u00a8\u0006\u001f"}, d2={"Lcom/calculatorsteam/dynamicpack/InputValidator;", "", "<init>", "()V", "", "contentId", "", "isDynamicContentIdValid", "(Ljava/lang/String;)Z", "", "throwIsContentIdInvalid", "(Ljava/lang/String;)V", "contentName", "isDynamicContentNameValid", "name", "isDynamicPackNameValid", "path", "throwIsPathInvalid", "url", "isUrlValid", "throwIsUrlInvalid", "hash", "isHashValid", "s", "safeOutput", "(Ljava/lang/String;)Ljava/lang/String;", "Ljava/util/regex/Pattern;", "CONTENT_ID_PATTERN", "Ljava/util/regex/Pattern;", "PATH_PATTERN", "URL_PATTERN", "dynamicpack"})
public final class InputValidator {
    @NotNull
    public static final InputValidator INSTANCE = new InputValidator();
    @NotNull
    private static final Pattern CONTENT_ID_PATTERN;
    @NotNull
    private static final Pattern PATH_PATTERN;
    @NotNull
    private static final Pattern URL_PATTERN;

    private InputValidator() {
    }

    @JvmStatic
    public static final boolean isDynamicContentIdValid(@Nullable String contentId) {
        return contentId != null && CONTENT_ID_PATTERN.matcher(contentId).matches();
    }

    @JvmStatic
    public static final void throwIsContentIdInvalid(@Nullable String contentId) {
        if (!InputValidator.isDynamicContentIdValid(contentId)) {
            String string = contentId;
            if (string == null) {
                string = "<null>";
            }
            throw new RuntimeException("Id of content is not valid: " + INSTANCE.safeOutput(string));
        }
    }

    @JvmStatic
    public static final boolean isDynamicContentNameValid(@Nullable String contentName) {
        boolean bl;
        String string = contentName;
        if (string != null && (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) != null) {
            String it = string;
            boolean bl2 = false;
            bl = it.length() < 64 && ((CharSequence)it).length() > 0 && !StringsKt.contains$default((CharSequence)it, (CharSequence)"\n", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)it, (CharSequence)"\r", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)it, (CharSequence)"\b", (boolean)false, (int)2, null);
        } else {
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    public static final boolean isDynamicPackNameValid(@Nullable String name) {
        boolean bl;
        String string = name;
        if (string != null && (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) != null) {
            String it = string;
            boolean bl2 = false;
            bl = it.length() < 64 && ((CharSequence)it).length() > 0 && !StringsKt.contains$default((CharSequence)it, (CharSequence)"\n", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)it, (CharSequence)"\r", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)it, (CharSequence)"\b", (boolean)false, (int)2, null);
        } else {
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    public static final void throwIsPathInvalid(@Nullable String path) {
        if (path == null) {
            throw new SecurityException("Null path", new NullPointerException("path to valid is null"));
        }
        String trim = ((Object)StringsKt.trim((CharSequence)path)).toString();
        if (trim.length() < 2 || !PATH_PATTERN.matcher(path).matches()) {
            Object object = path;
            Charset charset = StandardCharsets.US_ASCII;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"US_ASCII");
            byte[] byArray = ((String)object).getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            object = byArray;
            Charset charset2 = StandardCharsets.US_ASCII;
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"US_ASCII");
            Charset charset3 = charset2;
            String safe = new String((byte[])object, charset3);
            throw new SecurityException("Not valid path: " + safe);
        }
    }

    @JvmStatic
    public static final boolean isUrlValid(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            if (Constants.INSTANCE.isLocalHostAllowed() && Intrinsics.areEqual((Object)Constants.INSTANCE.getUrlHost(url), (Object)"localhost")) {
                Out.INSTANCE.warn("isUrlValid return true for localhost! Behavior only when isLocalHostAllowed()=true");
                return true;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return URL_PATTERN.matcher(url).matches();
    }

    @JvmStatic
    public static final void throwIsUrlInvalid(@Nullable String url) {
        if (url == null) {
            throw new SecurityException("null", new NullPointerException("url to valid is null"));
        }
        if (!InputValidator.isUrlValid(url)) {
            throw new SecurityException("Not valid url: " + INSTANCE.safeOutput(url));
        }
    }

    @JvmStatic
    public static final boolean isHashValid(@Nullable String hash) {
        return hash != null && hash.length() == 40 && !StringsKt.contains$default((CharSequence)hash, (CharSequence)" ", (boolean)false, (int)2, null);
    }

    private final String safeOutput(String s) {
        String string = s.length() >= 100 ? StringsKt.take((String)s, (int)100) : s;
        Object object = string;
        Charset charset = StandardCharsets.US_ASCII;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"US_ASCII");
        byte[] byArray = ((String)object).getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        object = byArray;
        Charset charset2 = StandardCharsets.US_ASCII;
        Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"US_ASCII");
        Charset charset3 = charset2;
        return new String((byte[])object, charset3);
    }

    static {
        Pattern pattern = Pattern.compile("^[a-z0-9_:-]{2,128}$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        CONTENT_ID_PATTERN = pattern;
        Pattern pattern2 = Pattern.compile("^[A-Za-z0-9_./() +-]{0,255}$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(...)");
        PATH_PATTERN = pattern2;
        Pattern pattern3 = Pattern.compile("(https?://)?(www\\.)?[-a-zA-Z0-9@:%._\\+~#=]{2,256}\\.[a-z]{2,6}\\b([-a-zA-Z0-9@:%_\\+.~#?&//=]*)");
        Intrinsics.checkNotNullExpressionValue((Object)pattern3, (String)"compile(...)");
        URL_PATTERN = pattern3;
    }
}

