/*
 * Decompiled with CFR 0.152.
 */
package com.calculatorsteam.dynamicpack.client;

import com.calculatorsteam.dynamicpack.Constants;
import com.calculatorsteam.dynamicpack.DynamicPackMod;
import com.calculatorsteam.dynamicpack.pack.DynamicResourcePack;
import com.calculatorsteam.dynamicpack.platform.VersionFunctions;
import com.calculatorsteam.dynamicpack.sync.SyncThread;
import com.calculatorsteam.dynamicpack.util.log.Out;
import com.calculatorsteam.dynamicpack.util.status.StatusChecker;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.LazilyParsedNumber;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.WorldVersion;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastManager;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\b\u0010\r\u001a\u00020\u000bH\u0002J\u0010\u0010\u000e\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\b\u0010\u0011\u001a\u00020\tH\u0016J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0015H\u0016J\b\u0010\u0019\u001a\u00020\tH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/calculatorsteam/dynamicpack/client/DynamicPackModBase;", "Lcom/calculatorsteam/dynamicpack/DynamicPackMod;", "<init>", "()V", "toast", "Lnet/minecraft/client/gui/components/toasts/SystemToast;", "toastUpdated", "", "setToastContent", "", "title", "Lnet/minecraft/network/chat/Component;", "text", "createDownloadComponent", "onWorldJoinForUpdateChecks", "player", "Lnet/minecraft/client/player/LocalPlayer;", "startManuallySync", "pack", "Lcom/calculatorsteam/dynamicpack/pack/DynamicResourcePack;", "getCurrentGameVersion", "", "checkResourcePackMetaValid", "", "s", "needResourcesReload", "dynamicpack"})
@SourceDebugExtension(value={"SMAP\nDynamicPackModBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DynamicPackModBase.kt\ncom/calculatorsteam/dynamicpack/client/DynamicPackModBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,152:1\n1#2:153\n*E\n"})
public abstract class DynamicPackModBase
extends DynamicPackMod {
    @Nullable
    private SystemToast toast;
    private long toastUpdated;

    /*
     * WARNING - void declaration
     */
    public final void setToastContent(@NotNull Component title, @NotNull Component text) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (!this.isMinecraftInitialized()) {
            return;
        }
        long now = System.currentTimeMillis();
        if (this.toast == null || now - this.toastUpdated > 5000L) {
            void it;
            SystemToast systemToast;
            ToastManager toastManager = VersionFunctions.INSTANCE.getToastManager();
            SystemToast systemToast2 = systemToast = new SystemToast(VersionFunctions.INSTANCE.getSystemToastId(), title, text);
            DynamicPackModBase dynamicPackModBase = this;
            boolean bl = false;
            toastManager.addToast((Toast)it);
            dynamicPackModBase.toast = systemToast;
        } else {
            SystemToast systemToast = this.toast;
            if (systemToast != null) {
                systemToast.reset(title, text);
            }
        }
        this.toastUpdated = now;
    }

    private final Component createDownloadComponent() {
        MutableComponent mutableComponent = Component.translatable((String)"dynamicpack.status_checker.download");
        Object[] objectArray = new Object[1];
        ChatFormatting[] chatFormattingArray = new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.AQUA};
        objectArray[0] = Component.literal((String)"https://modrinth.com/mod/dynamicpack").withStyle(chatFormattingArray);
        MutableComponent mutableComponent2 = Component.translatable((String)"dynamicpack.status_checker.download.hover", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"translatable(...)");
        ChatFormatting[] chatFormattingArray2 = new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.UNDERLINE};
        MutableComponent mutableComponent3 = mutableComponent.withStyle(Style.EMPTY.withHoverEvent(VersionFunctions.INSTANCE.getHoverEventShowText((Component)mutableComponent2)).withClickEvent(VersionFunctions.INSTANCE.getClickEventOpenUrl("https://modrinth.com/mod/dynamicpack"))).withStyle(chatFormattingArray2);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent3, (String)"withStyle(...)");
        return (Component)mutableComponent3;
    }

    public final void onWorldJoinForUpdateChecks(@Nullable LocalPlayer player) {
        if (Constants.INSTANCE.isDebugMessageOnWorldJoin()) {
            MutableComponent mutableComponent = Component.literal((String)"Debug message on world join").withStyle(ChatFormatting.GREEN);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
            VersionFunctions.INSTANCE.displayClientMessage(player, (Component)mutableComponent);
        }
        if (player == null) {
            Out.INSTANCE.warn("player == null on world join");
        } else if (!StatusChecker.isSafe()) {
            Object[] objectArray = new Object[]{this.createDownloadComponent()};
            MutableComponent mutableComponent = Component.translatable((String)"dynamicpack.status_checker.not_safe", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
            VersionFunctions.INSTANCE.displayClientMessage(player, (Component)mutableComponent);
            MutableComponent mutableComponent2 = Component.translatable((String)"dynamicpack.status_checker.not_safe.toast.title");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"translatable(...)");
            Component component = (Component)mutableComponent2;
            MutableComponent mutableComponent3 = Component.translatable((String)"dynamicpack.status_checker.not_safe.toast.description");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent3, (String)"translatable(...)");
            this.setToastContent(component, (Component)mutableComponent3);
        } else if (!StatusChecker.isFormatActual()) {
            Object[] objectArray = new Object[]{this.createDownloadComponent()};
            MutableComponent mutableComponent = Component.translatable((String)"dynamicpack.status_checker.format_not_actual", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
            VersionFunctions.INSTANCE.displayClientMessage(player, (Component)mutableComponent);
        } else if (StatusChecker.isModUpdateAvailable()) {
            Out.println("DynamicPack mod update available: https://modrinth.com/mod/dynamicpack");
        } else if (!StatusChecker.isChecked()) {
            Out.INSTANCE.warn("StatusChecker isChecked = false :(");
        } else {
            Out.println("Mod in actual state in current time!");
        }
    }

    @Override
    public void startManuallySync() {
        int n = this.getManuallySyncThreadCounter();
        this.setManuallySyncThreadCounter(n + 1);
        new SyncThread("SyncThread-" + n, null, 2, null).start();
    }

    @Override
    public void startManuallySync(@NotNull DynamicResourcePack pack) {
        Intrinsics.checkNotNullParameter((Object)pack, (String)"pack");
        int n = this.getManuallySyncThreadCounter();
        this.setManuallySyncThreadCounter(n + 1);
        new SyncThread("SyncThread-" + n, pack).start();
    }

    @Override
    @NotNull
    public String getCurrentGameVersion() {
        SharedConstants.tryDetectVersion();
        WorldVersion worldVersion = SharedConstants.getCurrentVersion();
        Intrinsics.checkNotNullExpressionValue((Object)worldVersion, (String)"getCurrentVersion(...)");
        return VersionFunctions.INSTANCE.versionName(worldVersion);
    }

    @Override
    public boolean checkResourcePackMetaValid(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        JsonObject jsonObject = GsonHelper.parse((String)s).getAsJsonObject("pack");
        Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"getAsJsonObject(...)");
        JsonObject pack = jsonObject;
        if (pack.get("pack_format").getAsNumber() instanceof LazilyParsedNumber) {
            Number number = pack.get("pack_format").getAsNumber();
            Intrinsics.checkNotNull((Object)number, (String)"null cannot be cast to non-null type com.google.gson.internal.LazilyParsedNumber");
            ((LazilyParsedNumber)number).intValue();
        }
        JsonElement jsonElement = pack.get("description");
        Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"get(...)");
        JsonElement description = jsonElement;
        if (description.isJsonNull()) {
            throw new NullPointerException("description is null in pack.mcmeta");
        }
        return true;
    }

    @Override
    public void needResourcesReload() {
        Minecraft client = Minecraft.getInstance();
        if (client != null && client.level == null) {
            client.execute(() -> DynamicPackModBase.needResourcesReload$lambda$0(client));
        } else {
            MutableComponent mutableComponent = Component.translatable((String)"dynamicpack.toast.needReload");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
            Component component = (Component)mutableComponent;
            MutableComponent mutableComponent2 = Component.translatable((String)"dynamicpack.toast.needReload.description");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"translatable(...)");
            this.setToastContent(component, (Component)mutableComponent2);
        }
    }

    private static final void needResourcesReload$lambda$0(Minecraft $client) {
        $client.reloadResourcePacks();
    }
}

