/*
 * Decompiled with CFR 0.152.
 */
package com.calculatorsteam.dynamicpack.client.gui;

import com.calculatorsteam.dynamicpack.client.config.Config;
import com.calculatorsteam.dynamicpack.client.gui.ContentsScreen;
import com.calculatorsteam.dynamicpack.pack.dynamicrepo.BaseContent;
import com.calculatorsteam.dynamicpack.pack.dynamicrepo.BaseEnum;
import com.calculatorsteam.dynamicpack.platform.VersionFunctions;
import com.calculatorsteam.dynamicpack.util.enums.OverrideType;
import com.calculatorsteam.dynamicpack.util.log.Out;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\f\u0012\b\u0012\u00060\u0002R\u00020\u00000\u0001:\u0003\u000e\u000f\u0010B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\nH\u0016J\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/calculatorsteam/dynamicpack/client/gui/ContentsList;", "Lnet/minecraft/client/gui/components/ContainerObjectSelectionList;", "Lcom/calculatorsteam/dynamicpack/client/gui/ContentsList$ContentEntry;", "parent", "Lcom/calculatorsteam/dynamicpack/client/gui/ContentsScreen;", "minecraft", "Lnet/minecraft/client/Minecraft;", "<init>", "(Lcom/calculatorsteam/dynamicpack/client/gui/ContentsScreen;Lnet/minecraft/client/Minecraft;)V", "getScrollbarPosition", "", "getRowWidth", "refreshAll", "", "BaseContentEntry", "EnumContentEntry", "ContentEntry", "dynamicpack"})
@SourceDebugExtension(value={"SMAP\nContentsList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContentsList.kt\ncom/calculatorsteam/dynamicpack/client/gui/ContentsList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,211:1\n1869#2,2:212\n*S KotlinDebug\n*F\n+ 1 ContentsList.kt\ncom/calculatorsteam/dynamicpack/client/gui/ContentsList\n*L\n47#1:212,2\n*E\n"})
public final class ContentsList
extends ContainerObjectSelectionList<ContentEntry> {
    @NotNull
    private final ContentsScreen parent;

    public ContentsList(@NotNull ContentsScreen parent, @NotNull Minecraft minecraft) {
        Intrinsics.checkNotNullParameter((Object)((Object)parent), (String)"parent");
        Intrinsics.checkNotNullParameter((Object)minecraft, (String)"minecraft");
        super(minecraft, parent.width, parent.height - 52, 20, 40);
        this.parent = parent;
        for (BaseContent knownContent : this.parent.getBaseContents()) {
            if (knownContent.getHidden() && !Config.Companion.getInstance().dynamicRepoIsIgnoreHiddenContentFlag()) continue;
            this.addEntry((AbstractSelectionList.Entry)new BaseContentEntry(knownContent));
        }
        for (BaseEnum anEnum : this.parent.getBaseEnum()) {
            this.addEntry((AbstractSelectionList.Entry)new EnumContentEntry(anEnum));
        }
    }

    protected int getScrollbarPosition() {
        return super.getScrollbarPosition() + 15;
    }

    public int getRowWidth() {
        return super.getRowWidth() + 32;
    }

    public final void refreshAll() {
        List list = this.children();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"children(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ContentEntry it = (ContentEntry)((Object)element$iv);
            boolean bl = false;
            it.refresh();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0002JX\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/calculatorsteam/dynamicpack/client/gui/ContentsList$BaseContentEntry;", "Lcom/calculatorsteam/dynamicpack/client/gui/ContentsList$ContentEntry;", "Lcom/calculatorsteam/dynamicpack/client/gui/ContentsList;", "content", "Lcom/calculatorsteam/dynamicpack/pack/dynamicrepo/BaseContent;", "<init>", "(Lcom/calculatorsteam/dynamicpack/client/gui/ContentsList;Lcom/calculatorsteam/dynamicpack/pack/dynamicrepo/BaseContent;)V", "createStateButton", "Lnet/minecraft/client/gui/components/Button;", "clicked", "", "refresh", "currentState", "Lnet/minecraft/network/chat/Component;", "render", "context", "Lnet/minecraft/client/gui/GuiGraphics;", "index", "", "y", "x", "entryWidth", "entryHeight", "mouseX", "mouseY", "hovered", "", "tickDelta", "", "dynamicpack"})
    public final class BaseContentEntry
    extends ContentEntry {
        @NotNull
        private final BaseContent content;

        public BaseContentEntry(BaseContent content) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            this.content = content;
            this.setStateButton(this.createStateButton());
            boolean bl = this.getStateButton().active = !this.content.getRequired();
            if (!this.getStateButton().active) {
                VersionFunctions.INSTANCE.setTooltip(this.getStateButton(), Tooltip.create((Component)((Component)Component.translatable((String)"dynamicpack.screen.pack_contents.state.tooltip_disabled"))));
            }
        }

        private final Button createStateButton() {
            Object[] objectArray = new Object[]{this.currentState()};
            Button button = Button.builder((Component)((Component)Component.translatable((String)"dynamicpack.screen.pack_contents.state", (Object[])objectArray)), arg_0 -> BaseContentEntry.createStateButton$lambda$0(this, arg_0)).bounds(0, 0, 140, 20).build();
            Intrinsics.checkNotNullExpressionValue((Object)button, (String)"build(...)");
            return button;
        }

        private final void clicked() {
            try {
                this.content.nextOverride(ContentsList.this.parent.getBaseContents());
            }
            catch (Exception e) {
                Out.error("Error while content.nextOverride() in gui", e);
            }
            ContentsList.this.parent.onAfterChange();
            ContentsList.this.refreshAll();
        }

        @Override
        public void refresh() {
            Object[] objectArray = new Object[]{this.currentState()};
            this.getStateButton().setMessage((Component)Component.translatable((String)"dynamicpack.screen.pack_contents.state", (Object[])objectArray));
        }

        private final Component currentState() {
            String key = switch (WhenMappings.$EnumSwitchMapping$0[this.content.getOverrideType().ordinal()]) {
                case 1 -> "dynamicpack.screen.pack_contents.state.true";
                case 2 -> "dynamicpack.screen.pack_contents.state.false";
                case 3 -> {
                    if (this.content.getDefaultState()) {
                        yield "dynamicpack.screen.pack_contents.state.default.true";
                    }
                    yield "dynamicpack.screen.pack_contents.state.default.false";
                }
                default -> throw new NoWhenBranchMatchedException();
            };
            MutableComponent mutableComponent = Component.translatable((String)key);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
            return (Component)mutableComponent;
        }

        public void render(@NotNull GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            String string = this.content.getName();
            if (string == null) {
                string = this.content.getId();
            }
            String txt = string;
            MutableComponent text = Component.literal((String)txt);
            context.drawString(((ContentsList)ContentsList.this).minecraft.font, (Component)text, x - 50, y + 10, -1, false);
            this.getStateButton().setX(x + entryWidth - 140);
            this.getStateButton().setY(y);
            this.getStateButton().render(context, mouseX, mouseY, tickDelta);
        }

        private static final void createStateButton$lambda$0(BaseContentEntry this$0, Button it) {
            this$0.clicked();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[OverrideType.values().length];
                try {
                    nArray[OverrideType.TRUE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OverrideType.FALSE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OverrideType.NOT_SET.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00a6\u0004\u0018\u00002\f\u0012\b\u0012\u00060\u0000R\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH&J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eH\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lcom/calculatorsteam/dynamicpack/client/gui/ContentsList$ContentEntry;", "Lnet/minecraft/client/gui/components/ContainerObjectSelectionList$Entry;", "Lcom/calculatorsteam/dynamicpack/client/gui/ContentsList;", "<init>", "(Lcom/calculatorsteam/dynamicpack/client/gui/ContentsList;)V", "stateButton", "Lnet/minecraft/client/gui/components/Button;", "getStateButton", "()Lnet/minecraft/client/gui/components/Button;", "setStateButton", "(Lnet/minecraft/client/gui/components/Button;)V", "refresh", "", "children", "", "Lnet/minecraft/client/gui/components/events/GuiEventListener;", "narratables", "Lnet/minecraft/client/gui/narration/NarratableEntry;", "dynamicpack"})
    public abstract class ContentEntry
    extends ContainerObjectSelectionList.Entry<ContentEntry> {
        protected Button stateButton;

        @NotNull
        protected final Button getStateButton() {
            Button button = this.stateButton;
            if (button != null) {
                return button;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"stateButton");
            return null;
        }

        protected final void setStateButton(@NotNull Button button) {
            Intrinsics.checkNotNullParameter((Object)button, (String)"<set-?>");
            this.stateButton = button;
        }

        public abstract void refresh();

        @NotNull
        public List<GuiEventListener> children() {
            return CollectionsKt.listOf((Object)this.getStateButton());
        }

        @NotNull
        public List<NarratableEntry> narratables() {
            return CollectionsKt.listOf((Object)this.getStateButton());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0002JX\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/calculatorsteam/dynamicpack/client/gui/ContentsList$EnumContentEntry;", "Lcom/calculatorsteam/dynamicpack/client/gui/ContentsList$ContentEntry;", "Lcom/calculatorsteam/dynamicpack/client/gui/ContentsList;", "baseEnum", "Lcom/calculatorsteam/dynamicpack/pack/dynamicrepo/BaseEnum;", "<init>", "(Lcom/calculatorsteam/dynamicpack/client/gui/ContentsList;Lcom/calculatorsteam/dynamicpack/pack/dynamicrepo/BaseEnum;)V", "createStateButton", "Lnet/minecraft/client/gui/components/Button;", "clicked", "", "refresh", "currentState", "Lnet/minecraft/network/chat/Component;", "render", "context", "Lnet/minecraft/client/gui/GuiGraphics;", "index", "", "y", "x", "entryWidth", "entryHeight", "mouseX", "mouseY", "hovered", "", "tickDelta", "", "dynamicpack"})
    public final class EnumContentEntry
    extends ContentEntry {
        @NotNull
        private final BaseEnum baseEnum;

        public EnumContentEntry(BaseEnum baseEnum) {
            Intrinsics.checkNotNullParameter((Object)baseEnum, (String)"baseEnum");
            this.baseEnum = baseEnum;
            this.setStateButton(this.createStateButton());
        }

        private final Button createStateButton() {
            Button button = Button.builder((Component)this.currentState(), arg_0 -> EnumContentEntry.createStateButton$lambda$0(this, arg_0)).bounds(0, 0, 140, 20).build();
            Intrinsics.checkNotNullExpressionValue((Object)button, (String)"build(...)");
            return button;
        }

        private final void clicked() {
            try {
                this.baseEnum.applyNext(ContentsList.this.parent.getBaseContents());
            }
            catch (Exception e) {
                Out.error("Error while applyNext (gui)", e);
            }
            ContentsList.this.parent.onAfterChange();
            ContentsList.this.refreshAll();
        }

        @Override
        public void refresh() {
            this.getStateButton().setMessage(this.currentState());
        }

        private final Component currentState() {
            MutableComponent mutableComponent = Component.literal((String)this.baseEnum.getCurrentState(ContentsList.this.parent.getBaseContents()));
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
            return (Component)mutableComponent;
        }

        public void render(@NotNull GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            String string = this.baseEnum.getName();
            if (string == null) {
                string = this.baseEnum.getId();
            }
            String txt = string;
            MutableComponent text = Component.literal((String)txt);
            context.drawString(((ContentsList)ContentsList.this).minecraft.font, (Component)text, x - 50, y + 10, -1, false);
            this.getStateButton().setX(x + entryWidth - 140);
            this.getStateButton().setY(y);
            this.getStateButton().render(context, mouseX, mouseY, tickDelta);
        }

        private static final void createStateButton$lambda$0(EnumContentEntry this$0, Button it) {
            this$0.clicked();
        }
    }
}

