/*
 * Decompiled with CFR 0.152.
 */
package com.calculatorsteam.dynamicpack.pack.dynamicrepo;

import com.calculatorsteam.dynamicpack.InputValidator;
import com.calculatorsteam.dynamicpack.pack.DynamicResourcePack;
import com.calculatorsteam.dynamicpack.pack.Remote;
import com.calculatorsteam.dynamicpack.pack.dynamicrepo.DynamicRepoPreferences;
import com.calculatorsteam.dynamicpack.pack.dynamicrepo.DynamicRepoSyncBuilder;
import com.calculatorsteam.dynamicpack.sync.SyncBuilder;
import com.calculatorsteam.dynamicpack.util.JsonUtil;
import com.calculatorsteam.dynamicpack.util.Urls;
import com.google.gson.JsonObject;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u000b\u0018\u0000 +2\u00020\u0001:\u0001+B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\nH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u000e\u0010)\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\nR\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\f@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\f@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u001e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\f@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u001e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u0014@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010 \u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010&\u00a8\u0006,"}, d2={"Lcom/calculatorsteam/dynamicpack/pack/dynamicrepo/DynamicRepoRemote;", "Lcom/calculatorsteam/dynamicpack/pack/Remote;", "<init>", "()V", "value", "Lcom/calculatorsteam/dynamicpack/pack/DynamicResourcePack;", "parent", "getParent", "()Lcom/calculatorsteam/dynamicpack/pack/DynamicResourcePack;", "cachedCurrentJson", "Lcom/google/gson/JsonObject;", "cachedRemoteJson", "", "url", "getUrl", "()Ljava/lang/String;", "buildUrl", "getBuildUrl", "packUrl", "getPackUrl", "Lcom/calculatorsteam/dynamicpack/pack/dynamicrepo/DynamicRepoPreferences;", "preferences", "getPreferences", "()Lcom/calculatorsteam/dynamicpack/pack/dynamicrepo/DynamicRepoPreferences;", "init", "", "pack", "remote", "syncBuilder", "Lcom/calculatorsteam/dynamicpack/sync/SyncBuilder;", "checkUpdateAvailable", "", "currentBuild", "", "getCurrentBuild", "()J", "cachedCurrent", "getCachedCurrent", "()Lcom/google/gson/JsonObject;", "cachedRemote", "getCachedRemote", "notifyNewRemoteJson", "repoJson", "Companion", "dynamicpack"})
public final class DynamicRepoRemote
extends Remote {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private DynamicResourcePack parent;
    private JsonObject cachedCurrentJson;
    private JsonObject cachedRemoteJson;
    private String url;
    private String buildUrl;
    private String packUrl;
    private DynamicRepoPreferences preferences;
    @NotNull
    public static final String REPO_JSON = "dynamicmcpack.repo.json";
    @NotNull
    public static final String REPO_BUILD = "dynamicmcpack.repo.build";

    @NotNull
    public final DynamicResourcePack getParent() {
        DynamicResourcePack dynamicResourcePack = this.parent;
        if (dynamicResourcePack != null) {
            return dynamicResourcePack;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"parent");
        return null;
    }

    @NotNull
    public final String getUrl() {
        String string = this.url;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"url");
        return null;
    }

    @NotNull
    public final String getBuildUrl() {
        String string = this.buildUrl;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"buildUrl");
        return null;
    }

    @NotNull
    public final String getPackUrl() {
        String string = this.packUrl;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"packUrl");
        return null;
    }

    @NotNull
    public final DynamicRepoPreferences getPreferences() {
        DynamicRepoPreferences dynamicRepoPreferences = this.preferences;
        if (dynamicRepoPreferences != null) {
            return dynamicRepoPreferences;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
        return null;
    }

    @Override
    public void init(@NotNull DynamicResourcePack pack, @NotNull JsonObject remote) {
        Intrinsics.checkNotNullParameter((Object)pack, (String)"pack");
        Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
        this.parent = pack;
        this.cachedRemoteJson = remote;
        this.cachedCurrentJson = pack.getCurrentJson();
        this.url = JsonUtil.getString(remote, "url");
        InputValidator.throwIsUrlInvalid(this.getUrl());
        this.buildUrl = this.getUrl() + "/dynamicmcpack.repo.build";
        this.packUrl = this.getUrl() + "/dynamicmcpack.repo.json";
        this.preferences = new DynamicRepoPreferences(pack, this);
        boolean signNoRequired = JsonUtil.optBoolean(remote, "sign_no_required", false);
        if (signNoRequired == remote.has("public_key")) {
            throw new RuntimeException("Please add sign_no_required=true");
        }
    }

    @Override
    @NotNull
    public SyncBuilder syncBuilder() {
        return new DynamicRepoSyncBuilder(this.getParent(), this);
    }

    @Override
    public boolean checkUpdateAvailable() throws IOException {
        String string = Urls.parseTextContent(this.getBuildUrl(), 64L);
        if (string == null || (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) == null) {
            throw new IOException("Empty response from " + this.getBuildUrl());
        }
        String content = string;
        return this.getCurrentBuild() != Long.parseLong(content);
    }

    public final long getCurrentBuild() {
        JsonObject jsonObject = this.cachedCurrentJson;
        if (jsonObject == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cachedCurrentJson");
            jsonObject = null;
        }
        return JsonUtil.optLong(jsonObject, "build", -1L);
    }

    @NotNull
    public final JsonObject getCachedCurrent() {
        JsonObject jsonObject = this.cachedCurrentJson;
        if (jsonObject == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cachedCurrentJson");
            jsonObject = null;
        }
        return jsonObject;
    }

    @NotNull
    public final JsonObject getCachedRemote() {
        JsonObject jsonObject = this.cachedRemoteJson;
        if (jsonObject == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cachedRemoteJson");
            jsonObject = null;
        }
        return jsonObject;
    }

    public final void notifyNewRemoteJson(@NotNull JsonObject repoJson) {
        Intrinsics.checkNotNullParameter((Object)repoJson, (String)"repoJson");
        JsonObject copy = repoJson.deepCopy();
        DynamicRepoPreferences dynamicRepoPreferences = this.getPreferences();
        Intrinsics.checkNotNull((Object)copy);
        dynamicRepoPreferences.notifyNewRemoteJson(copy);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/calculatorsteam/dynamicpack/pack/dynamicrepo/DynamicRepoRemote$Companion;", "", "<init>", "()V", "REPO_JSON", "", "REPO_BUILD", "dynamicpack"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

