/*
 * Decompiled with CFR 0.152.
 */
package com.calculatorsteam.dynamicpack.client.gui;

import com.calculatorsteam.dynamicpack.DynamicPackMod;
import com.calculatorsteam.dynamicpack.client.gui.ContentsList;
import com.calculatorsteam.dynamicpack.pack.DynamicResourcePack;
import com.calculatorsteam.dynamicpack.pack.Remote;
import com.calculatorsteam.dynamicpack.pack.dynamicrepo.BaseContent;
import com.calculatorsteam.dynamicpack.pack.dynamicrepo.BaseEnum;
import com.calculatorsteam.dynamicpack.pack.dynamicrepo.DynamicRepoPreferences;
import com.calculatorsteam.dynamicpack.pack.dynamicrepo.DynamicRepoRemote;
import com.calculatorsteam.dynamicpack.platform.VersionFunctions;
import com.calculatorsteam.dynamicpack.util.enums.OverrideType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010&\u001a\u00020\u000fJ\u0006\u0010'\u001a\u00020\u000bJ\u0006\u0010(\u001a\u00020\u000bJ\b\u0010)\u001a\u00020\u000bH\u0016J\b\u0010*\u001a\u00020\u000bH\u0002J\b\u0010+\u001a\u00020\u000fH\u0016J(\u0010,\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002002\u0006\u00102\u001a\u000203H\u0016J\b\u00104\u001a\u00020\u000bH\u0014J\b\u00105\u001a\u00020\u000bH\u0002J\u0010\u0010=\u001a\u0004\u0018\u00010\u00162\u0006\u0010>\u001a\u00020\u0015R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R0\u0010\u0013\u001a\u001e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014j\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0016`\u0017X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R0\u0010\u001a\u001a\u001e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001c0\u001bj\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001c`\u001dX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR$\u0010 \u001a\u0012\u0012\u0004\u0012\u00020\"0!j\b\u0012\u0004\u0012\u00020\"`#X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0017\u00106\u001a\b\u0012\u0004\u0012\u00020\u0016078F\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u0017\u0010:\u001a\b\u0012\u0004\u0012\u00020\"078F\u00a2\u0006\u0006\u001a\u0004\b;\u0010<\u00a8\u0006?"}, d2={"Lcom/calculatorsteam/dynamicpack/client/gui/ContentsScreen;", "Lnet/minecraft/client/gui/screens/Screen;", "parent", "pack", "Lcom/calculatorsteam/dynamicpack/pack/DynamicResourcePack;", "<init>", "(Lnet/minecraft/client/gui/screens/Screen;Lcom/calculatorsteam/dynamicpack/pack/DynamicResourcePack;)V", "preferences", "Lcom/calculatorsteam/dynamicpack/pack/dynamicrepo/DynamicRepoPreferences;", "onPackReSync", "Lkotlin/Function1;", "", "contentsList", "Lcom/calculatorsteam/dynamicpack/client/gui/ContentsList;", "syncOnExit", "", "doneButton", "Lnet/minecraft/client/gui/components/Button;", "resetButton", "contentIdsAssociation", "Ljava/util/HashMap;", "", "Lcom/calculatorsteam/dynamicpack/pack/dynamicrepo/BaseContent;", "Lkotlin/collections/HashMap;", "getContentIdsAssociation", "()Ljava/util/HashMap;", "preChangeStates", "Ljava/util/LinkedHashMap;", "Lcom/calculatorsteam/dynamicpack/util/enums/OverrideType;", "Lkotlin/collections/LinkedHashMap;", "getPreChangeStates", "()Ljava/util/LinkedHashMap;", "enums", "Ljava/util/LinkedHashSet;", "Lcom/calculatorsteam/dynamicpack/pack/dynamicrepo/BaseEnum;", "Lkotlin/collections/LinkedHashSet;", "getEnums", "()Ljava/util/LinkedHashSet;", "isChanges", "reset", "onAfterChange", "onClose", "applyChanges", "shouldCloseOnEsc", "render", "context", "Lnet/minecraft/client/gui/GuiGraphics;", "mouseX", "", "mouseY", "delta", "", "init", "updateDoneButton", "baseContents", "", "getBaseContents", "()[Lcom/calculatorsteam/dynamicpack/pack/dynamicrepo/BaseContent;", "baseEnum", "getBaseEnum", "()[Lcom/calculatorsteam/dynamicpack/pack/dynamicrepo/BaseEnum;", "getById", "id", "dynamicpack"})
@SourceDebugExtension(value={"SMAP\nContentsScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContentsScreen.kt\ncom/calculatorsteam/dynamicpack/client/gui/ContentsScreen\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,140:1\n13805#2,2:141\n188#3,3:143\n216#3,2:146\n1869#4,2:148\n1#5:150\n37#6,2:151\n37#6,2:153\n*S KotlinDebug\n*F\n+ 1 ContentsScreen.kt\ncom/calculatorsteam/dynamicpack/client/gui/ContentsScreen\n*L\n41#1:141,2\n49#1:143,3\n52#1:146,2\n74#1:148,2\n133#1:151,2\n136#1:153,2\n*E\n"})
public final class ContentsScreen
extends Screen {
    @NotNull
    private final Screen parent;
    @NotNull
    private final DynamicResourcePack pack;
    @NotNull
    private final DynamicRepoPreferences preferences;
    @NotNull
    private final Function1<DynamicResourcePack, Unit> onPackReSync;
    private ContentsList contentsList;
    private boolean syncOnExit;
    private Button doneButton;
    private Button resetButton;
    @NotNull
    private final HashMap<String, BaseContent> contentIdsAssociation;
    @NotNull
    private final LinkedHashMap<BaseContent, OverrideType> preChangeStates;
    @NotNull
    private final LinkedHashSet<BaseEnum> enums;

    public ContentsScreen(@NotNull Screen parent, @NotNull DynamicResourcePack pack) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)pack, (String)"pack");
        super((Component)Component.translatable((String)"dynamicpack.screen.pack_contents.title"));
        this.parent = parent;
        this.pack = pack;
        this.onPackReSync = arg_0 -> ContentsScreen.onPackReSync$lambda$0(this, arg_0);
        this.contentIdsAssociation = new HashMap();
        this.preChangeStates = new LinkedHashMap();
        this.enums = new LinkedHashSet();
        this.minecraft = Minecraft.getInstance();
        this.pack.addDestroyListener(this.onPackReSync);
        Remote remote = this.pack.getRemote();
        Intrinsics.checkNotNull((Object)remote, (String)"null cannot be cast to non-null type com.calculatorsteam.dynamicpack.pack.dynamicrepo.DynamicRepoRemote");
        this.preferences = ((DynamicRepoRemote)remote).getPreferences();
        BaseContent[] $this$forEach$iv = this.preferences.getKnownContents();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            BaseContent element$iv;
            BaseContent knownContent = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            ((Map)this.contentIdsAssociation).put(knownContent.getId(), knownContent);
            ((Map)this.preChangeStates).put(knownContent, knownContent.getOverrideType());
        }
        CollectionsKt.addAll((Collection)this.enums, (Object[])this.preferences.getKnownEnums());
    }

    @NotNull
    protected final HashMap<String, BaseContent> getContentIdsAssociation() {
        return this.contentIdsAssociation;
    }

    @NotNull
    protected final LinkedHashMap<BaseContent, OverrideType> getPreChangeStates() {
        return this.preChangeStates;
    }

    @NotNull
    protected final LinkedHashSet<BaseEnum> getEnums() {
        return this.enums;
    }

    public final boolean isChanges() {
        boolean bl;
        block3: {
            Map $this$any$iv = this.preChangeStates;
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Iterator iterator = $this$any$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator.next();
                    boolean bl2 = false;
                    BaseContent content = (BaseContent)entry.getKey();
                    OverrideType override = (OverrideType)((Object)entry.getValue());
                    if (!(override != content.getOverrideType())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void reset() {
        Map $this$forEach$iv = this.preChangeStates;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            BaseContent content = (BaseContent)entry.getKey();
            OverrideType overrideType = (OverrideType)((Object)entry.getValue());
            content.setOverrideType(overrideType, this.getBaseContents());
        }
        ContentsList contentsList = this.contentsList;
        if (contentsList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentsList");
            contentsList = null;
        }
        contentsList.refreshAll();
        this.onAfterChange();
    }

    public final void onAfterChange() {
        this.syncOnExit = this.isChanges();
        this.updateDoneButton();
    }

    public void onClose() {
        this.applyChanges();
        Minecraft.getInstance().setScreen(this.parent);
        this.pack.removeDestroyListener(this.onPackReSync);
        if (this.syncOnExit) {
            DynamicPackMod.Companion.getInstance().startManuallySync(this.pack);
        }
    }

    private final void applyChanges() {
        Set<BaseContent> set = this.preChangeStates.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BaseContent baseContent = (BaseContent)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)baseContent);
            this.preferences.setContentOverride(baseContent, baseContent.getOverrideType());
        }
        this.pack.saveClientFile();
    }

    public boolean shouldCloseOnEsc() {
        return !this.syncOnExit;
    }

    public void render(@NotNull GuiGraphics context, int mouseX, int mouseY, float delta) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.render(context, mouseX, mouseY, delta);
        ContentsList contentsList = this.contentsList;
        if (contentsList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentsList");
            contentsList = null;
        }
        contentsList.render(context, mouseX, mouseY, delta);
        Font font = this.font;
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"font");
        Component component = this.title;
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"title");
        VersionFunctions.INSTANCE.drawCenteredString(context, font, component, this.width / 2, 8, -1);
    }

    protected void init() {
        Button it;
        super.init();
        Minecraft minecraft = this.minecraft;
        Intrinsics.checkNotNull((Object)minecraft);
        this.contentsList = new ContentsList(this, minecraft);
        ContentsList contentsList = this.contentsList;
        if (contentsList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentsList");
            contentsList = null;
        }
        this.addWidget((GuiEventListener)contentsList);
        Component component = CommonComponents.GUI_DONE;
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"GUI_DONE");
        Object t = VersionFunctions.INSTANCE.createButton(component, (Function0<Unit>)((Function0)() -> ContentsScreen.init$lambda$0(this)), 150, 20, this.width / 2 + 4, this.height - 26);
        Button button = (Button)t;
        ContentsScreen contentsScreen = this;
        boolean bl = false;
        this.doneButton = it;
        contentsScreen.addRenderableWidget((GuiEventListener)t);
        MutableComponent mutableComponent = Component.translatable((String)"controls.reset");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        t = VersionFunctions.INSTANCE.createButton((Component)mutableComponent, (Function0<Unit>)((Function0)() -> ContentsScreen.init$lambda$2(this)), 150, 20, this.width / 2 - 154, this.height - 26);
        it = (Button)t;
        contentsScreen = this;
        boolean bl2 = false;
        this.resetButton = it;
        contentsScreen.addRenderableWidget((GuiEventListener)t);
        this.updateDoneButton();
    }

    private final void updateDoneButton() {
        Button button;
        if (this.syncOnExit) {
            Button button2 = this.doneButton;
            if (button2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"doneButton");
                button2 = null;
            }
            ChatFormatting[] chatFormattingArray = new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.GOLD};
            button2.setMessage((Component)Component.translatable((String)"dynamicpack.screen.pack_contents.apply").withStyle(chatFormattingArray));
            Button button3 = this.doneButton;
            if (button3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"doneButton");
                button3 = null;
            }
            VersionFunctions.INSTANCE.setTooltip(button3, Tooltip.create((Component)((Component)Component.translatable((String)"dynamicpack.screen.pack_contents.apply.tooltip"))));
        } else {
            Button button4 = this.doneButton;
            if (button4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"doneButton");
                button4 = null;
            }
            button4.setMessage(CommonComponents.GUI_DONE);
            Button button5 = this.doneButton;
            if (button5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"doneButton");
                button5 = null;
            }
            VersionFunctions.INSTANCE.setTooltip(button5, null);
        }
        if ((button = this.resetButton) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"resetButton");
            button = null;
        }
        button.visible = this.syncOnExit;
    }

    @NotNull
    public final BaseContent[] getBaseContents() {
        Set<BaseContent> set = this.preChangeStates.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        Collection $this$toTypedArray$iv = set;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new BaseContent[0]);
    }

    @NotNull
    public final BaseEnum[] getBaseEnum() {
        Collection $this$toTypedArray$iv = this.enums;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new BaseEnum[0]);
    }

    @Nullable
    public final BaseContent getById(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.contentIdsAssociation.get(id);
    }

    private static final Unit onPackReSync$lambda$0(ContentsScreen this$0, DynamicResourcePack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        VersionFunctions.INSTANCE.runAtUI((Function0<Unit>)((Function0)() -> ContentsScreen.onPackReSync$lambda$0$0(this$0)));
        return Unit.INSTANCE;
    }

    private static final Unit onPackReSync$lambda$0$0(ContentsScreen this$0) {
        this$0.onClose();
        return Unit.INSTANCE;
    }

    private static final Unit init$lambda$0(ContentsScreen this$0) {
        this$0.onClose();
        return Unit.INSTANCE;
    }

    private static final Unit init$lambda$2(ContentsScreen this$0) {
        this$0.reset();
        return Unit.INSTANCE;
    }
}

