/*
 * Decompiled with CFR 0.152.
 */
package com.calculatorsteam.dynamicpack.client.gui;

import com.calculatorsteam.dynamicpack.Constants;
import com.calculatorsteam.dynamicpack.DynamicPackMod;
import com.calculatorsteam.dynamicpack.client.config.Config;
import com.calculatorsteam.dynamicpack.client.gui.ContentsScreen;
import com.calculatorsteam.dynamicpack.pack.DynamicResourcePack;
import com.calculatorsteam.dynamicpack.pack.dynamicrepo.DynamicRepoRemote;
import com.calculatorsteam.dynamicpack.platform.VersionFunctions;
import com.calculatorsteam.dynamicpack.sync.SyncBuilder;
import com.calculatorsteam.dynamicpack.sync.SyncingTask;
import com.calculatorsteam.dynamicpack.util.exception.TranslatableException;
import com.calculatorsteam.dynamicpack.util.log.NetworkStat;
import java.awt.Color;
import java.text.DateFormat;
import java.util.Date;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J(\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\tH\u0002J\b\u0010\u0019\u001a\u00020\tH\u0014J\b\u0010\u001a\u001a\u00020\tH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/calculatorsteam/dynamicpack/client/gui/DynamicPackScreen;", "Lnet/minecraft/client/gui/screens/Screen;", "parent", "pack", "Lcom/calculatorsteam/dynamicpack/pack/DynamicResourcePack;", "<init>", "(Lnet/minecraft/client/gui/screens/Screen;Lcom/calculatorsteam/dynamicpack/pack/DynamicResourcePack;)V", "destroyListener", "Lkotlin/Function1;", "", "syncButton", "Lnet/minecraft/client/gui/components/Button;", "contentsButton", "syncButtonThis", "syncButtonAll", "setPack", "render", "context", "Lnet/minecraft/client/gui/GuiGraphics;", "mouseX", "", "mouseY", "delta", "", "hideSyncSpecButtons", "init", "onClose", "dynamicpack"})
@SourceDebugExtension(value={"SMAP\nDynamicPackScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DynamicPackScreen.kt\ncom/calculatorsteam/dynamicpack/client/gui/DynamicPackScreen\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,218:1\n1#2:219\n*E\n"})
public final class DynamicPackScreen
extends Screen {
    @Nullable
    private final Screen parent;
    @NotNull
    private DynamicResourcePack pack;
    @NotNull
    private final Function1<DynamicResourcePack, Unit> destroyListener;
    private Button syncButton;
    private Button contentsButton;
    private Button syncButtonThis;
    private Button syncButtonAll;

    public DynamicPackScreen(@Nullable Screen parent, @NotNull DynamicResourcePack pack) {
        Intrinsics.checkNotNullParameter((Object)pack, (String)"pack");
        super((Component)Component.literal((String)pack.getName()).withStyle(ChatFormatting.BOLD));
        this.parent = parent;
        this.pack = pack;
        this.destroyListener = arg_0 -> DynamicPackScreen.destroyListener$lambda$0(this, arg_0);
        this.minecraft = Minecraft.getInstance();
        this.setPack(this.pack);
    }

    private final void setPack(DynamicResourcePack pack) {
        this.pack.removeDestroyListener(this.destroyListener);
        this.pack = pack;
        pack.addDestroyListener(this.destroyListener);
    }

    public void render(@NotNull GuiGraphics context, int mouseX, int mouseY, float delta) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.render(context, mouseX, mouseY, delta);
        Button button = this.syncButton;
        if (button == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"syncButton");
            button = null;
        }
        button.active = !SyncingTask.isSyncing();
        Button button2 = this.contentsButton;
        if (button2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentsButton");
            button2 = null;
        }
        boolean bl = button2.active = !SyncingTask.isSyncing();
        if (SyncingTask.isSyncing()) {
            this.hideSyncSpecButtons();
        }
        int h = 20;
        Font font = this.font;
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"font");
        Component component = this.title;
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"title");
        VersionFunctions.INSTANCE.drawString(context, font, component, 20, 8, -1);
        String string = Component.translatable((String)"dynamicpack.screen.pack.description").getString(999);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        VersionFunctions.INSTANCE.drawWrappedString(context, string, 20, 20 + h, this.width - 125, 2, -11141291);
        Font font2 = this.font;
        Intrinsics.checkNotNullExpressionValue((Object)font2, (String)"font");
        Object[] objectArray = new Object[]{this.pack.getRemoteType()};
        MutableComponent mutableComponent = Component.translatable((String)"dynamicpack.screen.pack.remote_type", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        VersionFunctions.INSTANCE.drawString(context, font2, (Component)mutableComponent, 20, 40 + h, -1);
        if (SyncingTask.isSyncing()) {
            VersionFunctions.INSTANCE.drawWrappedString(context, SyncingTask.getLogs(), 20, 108 + h, 500, 99, -3355444);
            StringBuilder asciiPercentage = new StringBuilder();
            int percentage = 0;
            try {
                SyncBuilder builder;
                SyncBuilder syncBuilder2 = builder = SyncingTask.currentRootSyncBuilder;
                long down = syncBuilder2 != null ? syncBuilder2.getDownloadedSize() : 0L;
                SyncBuilder syncBuilder3 = builder;
                long total = syncBuilder3 != null ? syncBuilder3.getUpdateSize() : 0L;
                percentage = total > 0L ? (int)((float)down / (float)total * (float)100) : 0;
                int n = 25;
                for (int i = 0; i < n; ++i) {
                    int i2 = i;
                    boolean bl2 = false;
                    int filled = percentage / 4;
                    asciiPercentage.append(i2 >= filled ? "_" : "#");
                }
            }
            catch (Exception builder) {
                // empty catch block
            }
            Object[] down = new Object[]{Constants.INSTANCE.speedToString(NetworkStat.INSTANCE.getSpeed()), Constants.INSTANCE.secondsToString(SyncingTask.eta), percentage, "[" + asciiPercentage + "]"};
            String string2 = Component.translatable((String)"dynamicpack.screen.pack.updateStat", (Object[])down).getString(512);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            VersionFunctions.INSTANCE.drawWrappedString(context, string2, 20, 52 + h, this.width, 3, Color.getHSBColor((float)Math.sin((double)System.currentTimeMillis() / 1850.0), 0.6f, 0.6f).getRGB());
        } else {
            Exception exception;
            long latestUpdated = this.pack.getLatestUpdated();
            if (latestUpdated > 0L) {
                Date date = new Date(latestUpdated * (long)1000);
                String string3 = DateFormat.getDateTimeInstance().format(date);
                Font font3 = this.font;
                Intrinsics.checkNotNullExpressionValue((Object)font3, (String)"font");
                Object[] objectArray2 = new Object[]{string3};
                MutableComponent mutableComponent2 = Component.translatable((String)"dynamicpack.screen.pack.latestUpdated", (Object[])objectArray2);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"translatable(...)");
                VersionFunctions.INSTANCE.drawString(context, font3, (Component)mutableComponent2, 20, 52 + h, -1);
            }
            if ((exception = this.pack.getLatestException()) != null) {
                Object[] objectArray3 = new Object[]{TranslatableException.Companion.getComponentFromException(exception)};
                String string4 = Component.translatable((String)"dynamicpack.screen.pack.latestException", (Object[])objectArray3).getString(512);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(...)");
                VersionFunctions.INSTANCE.drawWrappedString(context, string4, 20, 82 + h, this.width - 40, 4, -56798);
            }
        }
    }

    private final void hideSyncSpecButtons() {
        Button button = this.syncButtonThis;
        if (button == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"syncButtonThis");
            button = null;
        }
        button.visible = false;
        Button button2 = this.syncButtonAll;
        if (button2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"syncButtonAll");
            button2 = null;
        }
        button2.visible = false;
    }

    protected void init() {
        Button it;
        MutableComponent mutableComponent = Component.translatable((String)"dynamicpack.screen.pack.manually_sync");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        Object t = VersionFunctions.INSTANCE.createButton((Component)mutableComponent, (Function0<Unit>)((Function0)() -> DynamicPackScreen.init$lambda$0(this)), 100, 20, this.width - 120, 10);
        Button button = (Button)t;
        DynamicPackScreen dynamicPackScreen = this;
        boolean bl = false;
        this.syncButton = it;
        dynamicPackScreen.addRenderableWidget((GuiEventListener)t);
        MutableComponent mutableComponent2 = Component.translatable((String)"dynamicpack.screen.pack.manually_sync.this");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"translatable(...)");
        t = VersionFunctions.INSTANCE.createButton((Component)mutableComponent2, (Function0<Unit>)((Function0)() -> DynamicPackScreen.init$lambda$2(this)), 48, 20, this.width - 120, 35);
        it = (Button)t;
        dynamicPackScreen = this;
        boolean bl2 = false;
        this.syncButtonThis = it;
        dynamicPackScreen.addRenderableWidget((GuiEventListener)t);
        MutableComponent mutableComponent3 = Component.translatable((String)"dynamicpack.screen.pack.manually_sync.all");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent3, (String)"translatable(...)");
        t = VersionFunctions.INSTANCE.createButton((Component)mutableComponent3, (Function0<Unit>)((Function0)() -> DynamicPackScreen.init$lambda$4(this)), 48, 20, this.width - 66, 35);
        it = (Button)t;
        dynamicPackScreen = this;
        boolean bl3 = false;
        this.syncButtonAll = it;
        dynamicPackScreen.addRenderableWidget((GuiEventListener)t);
        if (!DynamicPackMod.Companion.isResourcePackActive(this.pack) && Config.Companion.getInstance().isUpdateOnlyEnabledPacks()) {
            Button button2 = this.syncButtonAll;
            if (button2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"syncButtonAll");
                button2 = null;
            }
            VersionFunctions.INSTANCE.setTooltip(button2, Tooltip.create((Component)((Component)Component.translatable((String)"dynamicpack.screen.pack.manually_sync.all.warningNotInclude").withStyle(ChatFormatting.RED))));
        }
        this.hideSyncSpecButtons();
        Component component = CommonComponents.GUI_DONE;
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"GUI_DONE");
        this.addRenderableWidget((GuiEventListener)VersionFunctions.INSTANCE.createButton(component, (Function0<Unit>)((Function0)() -> DynamicPackScreen.init$lambda$6(this)), 150, 20, this.width / 2 + 4, this.height - 26));
        MutableComponent mutableComponent4 = Component.translatable((String)"dynamicpack.screen.pack.dynamic.contents");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent4, (String)"translatable(...)");
        t = VersionFunctions.INSTANCE.createButton((Component)mutableComponent4, (Function0<Unit>)((Function0)() -> DynamicPackScreen.init$lambda$7(this)), 150, 20, this.width / 2 - 154, this.height - 26);
        it = (Button)t;
        dynamicPackScreen = this;
        boolean bl4 = false;
        this.contentsButton = it;
        dynamicPackScreen.addRenderableWidget((GuiEventListener)t);
        Button button3 = this.contentsButton;
        if (button3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentsButton");
            button3 = null;
        }
        button3.visible = this.pack.getRemote() instanceof DynamicRepoRemote;
    }

    public void onClose() {
        Minecraft.getInstance().setScreen(this.parent);
        this.pack.removeDestroyListener(this.destroyListener);
    }

    private static final Unit destroyListener$lambda$0(DynamicPackScreen this$0, DynamicResourcePack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.setPack(it);
        return Unit.INSTANCE;
    }

    private static final Unit init$lambda$0(DynamicPackScreen this$0) {
        Button button;
        Button button2;
        Button button3 = this$0.syncButtonThis;
        if (button3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"syncButtonThis");
            button3 = null;
        }
        if ((button2 = this$0.syncButtonThis) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"syncButtonThis");
            button2 = null;
        }
        button3.visible = !button2.visible;
        Button button4 = this$0.syncButtonAll;
        if (button4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"syncButtonAll");
            button4 = null;
        }
        if ((button = this$0.syncButtonAll) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"syncButtonAll");
            button = null;
        }
        button4.visible = !button.visible;
        return Unit.INSTANCE;
    }

    private static final Unit init$lambda$2(DynamicPackScreen this$0) {
        DynamicPackMod.Companion.getInstance().startManuallySync(this$0.pack);
        this$0.hideSyncSpecButtons();
        return Unit.INSTANCE;
    }

    private static final Unit init$lambda$4(DynamicPackScreen this$0) {
        DynamicPackMod.Companion.getInstance().startManuallySync();
        this$0.hideSyncSpecButtons();
        return Unit.INSTANCE;
    }

    private static final Unit init$lambda$6(DynamicPackScreen this$0) {
        this$0.onClose();
        return Unit.INSTANCE;
    }

    private static final Unit init$lambda$7(DynamicPackScreen this$0) {
        Minecraft.getInstance().setScreen((Screen)new ContentsScreen(this$0, this$0.pack));
        return Unit.INSTANCE;
    }
}

